<?php

namespace dpd\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for storeOrders StructType
 * Meta information extracted from the WSDL
 * - documentation: Stores up to 30 shipments and creates corresponding shipment documents.
 * - type: tns:storeOrders
 * @subpackage Structs
 */
class StoreOrders extends AbstractStructBase
{
    /**
     * The order
     * Meta information extracted from the WSDL
     * - documentation: Contains the whole data for the shipments.
     * - maxOccurs: 30
     * - minOccurs: 1
     * @var \dpd\StructType\ShipmentServiceData[]
     */
    public $order;
    /**
     * The printOptions
     * Meta information extracted from the WSDL
     * - documentation: The Options which should be used for parcel printing.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dpd\StructType\PrintOptions
     */
    public $printOptions;
    /**
     * Constructor method for storeOrders
     * @uses StoreOrders::setOrder()
     * @uses StoreOrders::setPrintOptions()
     * @param \dpd\StructType\ShipmentServiceData[] $order
     * @param \dpd\StructType\PrintOptions $printOptions
     */
    public function __construct(array $order = array(), \dpd\StructType\PrintOptions $printOptions = null)
    {
        $this
            ->setOrder($order)
            ->setPrintOptions($printOptions);
    }
    /**
     * Get order value
     * @return \dpd\StructType\ShipmentServiceData[]
     */
    public function getOrder()
    {
        return $this->order;
    }
    /**
     * This method is responsible for validating the values passed to the setOrder method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrder method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderForArrayConstraintsFromSetOrder(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $storeOrdersOrderItem) {
            // validation for constraint: itemType
            if (!$storeOrdersOrderItem instanceof \dpd\StructType\ShipmentServiceData) {
                $invalidValues[] = is_object($storeOrdersOrderItem) ? get_class($storeOrdersOrderItem) : sprintf('%s(%s)', gettype($storeOrdersOrderItem), var_export($storeOrdersOrderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The order property can only contain items of type \dpd\StructType\ShipmentServiceData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set order value
     * @throws \InvalidArgumentException
     * @param \dpd\StructType\ShipmentServiceData[] $order
     * @return \dpd\StructType\StoreOrders
     */
    public function setOrder(array $order = array())
    {
        // validation for constraint: array
        if ('' !== ($orderArrayErrorMessage = self::validateOrderForArrayConstraintsFromSetOrder($order))) {
            throw new \InvalidArgumentException($orderArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($order) && count($order) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 30', count($order)), __LINE__);
        }
        $this->order = $order;
        return $this;
    }
    /**
     * Add item to order value
     * @throws \InvalidArgumentException
     * @param \dpd\StructType\ShipmentServiceData $item
     * @return \dpd\StructType\StoreOrders
     */
    public function addToOrder(\dpd\StructType\ShipmentServiceData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dpd\StructType\ShipmentServiceData) {
            throw new \InvalidArgumentException(sprintf('The order property can only contain items of type \dpd\StructType\ShipmentServiceData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($this->order) && count($this->order) >= 30) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 30', count($this->order)), __LINE__);
        }
        $this->order[] = $item;
        return $this;
    }
    /**
     * Get printOptions value
     * @return \dpd\StructType\PrintOptions|null
     */
    public function getPrintOptions()
    {
        return $this->printOptions;
    }
    /**
     * Set printOptions value
     * @param \dpd\StructType\PrintOptions $printOptions
     * @return \dpd\StructType\StoreOrders
     */
    public function setPrintOptions(\dpd\StructType\PrintOptions $printOptions = null)
    {
        $this->printOptions = $printOptions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dpd\StructType\StoreOrders
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
