<?php

namespace dpd\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for shipmentServiceData StructType
 * Meta information extracted from the WSDL
 * - documentation: Bundles shipment service data.
 * @subpackage Structs
 */
class ShipmentServiceData extends AbstractStructBase
{
    /**
     * The generalShipmentData
     * Meta information extracted from the WSDL
     * - documentation: Contains general data for a shipment.
     * - minOccurs: 1
     * @var \dpd\StructType\GeneralShipmentData
     */
    public $generalShipmentData;
    /**
     * The productAndServiceData
     * Meta information extracted from the WSDL
     * - documentation: Contains special data for a shipment.
     * - minOccurs: 1
     * @var \dpd\StructType\ProductAndServiceData
     */
    public $productAndServiceData;
    /**
     * The parcels
     * Meta information extracted from the WSDL
     * - documentation: Contains information for the parcels.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dpd\StructType\Parcel[]
     */
    public $parcels;
    /**
     * Constructor method for shipmentServiceData
     * @uses ShipmentServiceData::setGeneralShipmentData()
     * @uses ShipmentServiceData::setProductAndServiceData()
     * @uses ShipmentServiceData::setParcels()
     * @param \dpd\StructType\GeneralShipmentData $generalShipmentData
     * @param \dpd\StructType\ProductAndServiceData $productAndServiceData
     * @param \dpd\StructType\Parcel[] $parcels
     */
    public function __construct(\dpd\StructType\GeneralShipmentData $generalShipmentData = null, \dpd\StructType\ProductAndServiceData $productAndServiceData = null, array $parcels = array())
    {
        $this
            ->setGeneralShipmentData($generalShipmentData)
            ->setProductAndServiceData($productAndServiceData)
            ->setParcels($parcels);
    }
    /**
     * Get generalShipmentData value
     * @return \dpd\StructType\GeneralShipmentData
     */
    public function getGeneralShipmentData()
    {
        return $this->generalShipmentData;
    }
    /**
     * Set generalShipmentData value
     * @param \dpd\StructType\GeneralShipmentData $generalShipmentData
     * @return \dpd\StructType\ShipmentServiceData
     */
    public function setGeneralShipmentData(\dpd\StructType\GeneralShipmentData $generalShipmentData = null)
    {
        $this->generalShipmentData = $generalShipmentData;
        return $this;
    }
    /**
     * Get productAndServiceData value
     * @return \dpd\StructType\ProductAndServiceData
     */
    public function getProductAndServiceData()
    {
        return $this->productAndServiceData;
    }
    /**
     * Set productAndServiceData value
     * @param \dpd\StructType\ProductAndServiceData $productAndServiceData
     * @return \dpd\StructType\ShipmentServiceData
     */
    public function setProductAndServiceData(\dpd\StructType\ProductAndServiceData $productAndServiceData = null)
    {
        $this->productAndServiceData = $productAndServiceData;
        return $this;
    }
    /**
     * Get parcels value
     * @return \dpd\StructType\Parcel[]|null
     */
    public function getParcels()
    {
        return $this->parcels;
    }
    /**
     * This method is responsible for validating the values passed to the setParcels method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParcels method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParcelsForArrayConstraintsFromSetParcels(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentServiceDataParcelsItem) {
            // validation for constraint: itemType
            if (!$shipmentServiceDataParcelsItem instanceof \dpd\StructType\Parcel) {
                $invalidValues[] = is_object($shipmentServiceDataParcelsItem) ? get_class($shipmentServiceDataParcelsItem) : sprintf('%s(%s)', gettype($shipmentServiceDataParcelsItem), var_export($shipmentServiceDataParcelsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The parcels property can only contain items of type \dpd\StructType\Parcel, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set parcels value
     * @throws \InvalidArgumentException
     * @param \dpd\StructType\Parcel[] $parcels
     * @return \dpd\StructType\ShipmentServiceData
     */
    public function setParcels(array $parcels = array())
    {
        // validation for constraint: array
        if ('' !== ($parcelsArrayErrorMessage = self::validateParcelsForArrayConstraintsFromSetParcels($parcels))) {
            throw new \InvalidArgumentException($parcelsArrayErrorMessage, __LINE__);
        }
        $this->parcels = $parcels;
        return $this;
    }
    /**
     * Add item to parcels value
     * @throws \InvalidArgumentException
     * @param \dpd\StructType\Parcel $item
     * @return \dpd\StructType\ShipmentServiceData
     */
    public function addToParcels(\dpd\StructType\Parcel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dpd\StructType\Parcel) {
            throw new \InvalidArgumentException(sprintf('The parcels property can only contain items of type \dpd\StructType\Parcel, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->parcels[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dpd\StructType\ShipmentServiceData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
