<?php

namespace dpd\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cod StructType
 * Meta information extracted from the WSDL
 * - documentation: Bundles cash on delivery data.
 * @subpackage Structs
 */
class Cod extends AbstractStructBase
{
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - documentation: COD amount in the currency of the destination country. The amount is specified as integer value e.g. 300.00 becomes 30000.Please note the national ceilings for cod in the corresponding relations. | Increased insurance value with 2
     * decimal point positions without separators.
     * - base: xs:long
     * - maxInclusive: 9999999999
     * - minOccurs: 1
     * @var int
     */
    public $amount;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - documentation: ISO 4217 alpha-3 currency code (destination country). | Currency code for increased insurance in format ISO 4217 alpha 3.
     * - base: xs:string
     * - length: 3
     * - minOccurs: 1
     * @var string
     */
    public $currency;
    /**
     * The inkasso
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $inkasso;
    /**
     * The purpose
     * Meta information extracted from the WSDL
     * - documentation: Purpose of use.
     * - base: xs:string
     * - maxLength: 14
     * - minOccurs: 0
     * @var string
     */
    public $purpose;
    /**
     * The bankCode
     * Meta information extracted from the WSDL
     * - documentation: Bank code. If this value is filled, parameters for bankName, bankAccountNumber and bankAccountHolder must also be filled.
     * - base: xs:string
     * - maxLength: 25
     * - minOccurs: 0
     * @var string
     */
    public $bankCode;
    /**
     * The bankName
     * Meta information extracted from the WSDL
     * - documentation: Bank name. If this value is filled, parameters for bankCode, bankAccountNumber and bankAccountHolder must also be filled.
     * - base: xs:string
     * - maxLength: 27
     * - minOccurs: 0
     * @var string
     */
    public $bankName;
    /**
     * The bankAccountNumber
     * Meta information extracted from the WSDL
     * - documentation: Bank account number. If this value is filled, parameters for bankCode, bankName and bankAccountHolder must also be filled.
     * - base: xs:string
     * - maxLength: 25
     * - minOccurs: 0
     * @var string
     */
    public $bankAccountNumber;
    /**
     * The bankAccountHolder
     * Meta information extracted from the WSDL
     * - documentation: Account holder. If this value is filled, parameters for bankCode, bankName and bankAccountNumber must also be filled.
     * - base: xs:string
     * - maxLength: 30
     * - minOccurs: 0
     * @var string
     */
    public $bankAccountHolder;
    /**
     * The iban
     * Meta information extracted from the WSDL
     * - documentation: International account number.If this value is filled, parameters for bankCode, bankName, bankAccountNumber and bankAccountHolder must also be filled.
     * - base: xs:string
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $iban;
    /**
     * The bic
     * Meta information extracted from the WSDL
     * - documentation: Bank identifier code.If this value is filled, parameters for bankCode, bankName, bankAccountNumber and bankAccountHolder must also be filled.
     * - base: xs:string
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $bic;
    /**
     * Constructor method for cod
     * @uses Cod::setAmount()
     * @uses Cod::setCurrency()
     * @uses Cod::setInkasso()
     * @uses Cod::setPurpose()
     * @uses Cod::setBankCode()
     * @uses Cod::setBankName()
     * @uses Cod::setBankAccountNumber()
     * @uses Cod::setBankAccountHolder()
     * @uses Cod::setIban()
     * @uses Cod::setBic()
     * @param int $amount
     * @param string $currency
     * @param string $inkasso
     * @param string $purpose
     * @param string $bankCode
     * @param string $bankName
     * @param string $bankAccountNumber
     * @param string $bankAccountHolder
     * @param string $iban
     * @param string $bic
     */
    public function __construct($amount = null, $currency = null, $inkasso = null, $purpose = null, $bankCode = null, $bankName = null, $bankAccountNumber = null, $bankAccountHolder = null, $iban = null, $bic = null)
    {
        $this
            ->setAmount($amount)
            ->setCurrency($currency)
            ->setInkasso($inkasso)
            ->setPurpose($purpose)
            ->setBankCode($bankCode)
            ->setBankName($bankName)
            ->setBankAccountNumber($bankAccountNumber)
            ->setBankAccountHolder($bankAccountHolder)
            ->setIban($iban)
            ->setBic($bic);
    }
    /**
     * Get amount value
     * @return int
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param int $amount
     * @return \dpd\StructType\Cod
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !(is_int($amount) || ctype_digit($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        // validation for constraint: maxInclusive(9999999999)
        if (!is_null($amount) && $amount > 9999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999999999', var_export($amount, true)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get currency value
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \dpd\StructType\Cod
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        // validation for constraint: length(3)
        if (!is_null($currency) && mb_strlen($currency) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 3', mb_strlen($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get inkasso value
     * @return string
     */
    public function getInkasso()
    {
        return $this->inkasso;
    }
    /**
     * Set inkasso value
     * @uses \dpd\EnumType\Inkasso::valueIsValid()
     * @uses \dpd\EnumType\Inkasso::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $inkasso
     * @return \dpd\StructType\Cod
     */
    public function setInkasso($inkasso = null)
    {
        // validation for constraint: enumeration
        if (!\dpd\EnumType\Inkasso::valueIsValid($inkasso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \dpd\EnumType\Inkasso', is_array($inkasso) ? implode(', ', $inkasso) : var_export($inkasso, true), implode(', ', \dpd\EnumType\Inkasso::getValidValues())), __LINE__);
        }
        $this->inkasso = $inkasso;
        return $this;
    }
    /**
     * Get purpose value
     * @return string|null
     */
    public function getPurpose()
    {
        return $this->purpose;
    }
    /**
     * Set purpose value
     * @param string $purpose
     * @return \dpd\StructType\Cod
     */
    public function setPurpose($purpose = null)
    {
        // validation for constraint: string
        if (!is_null($purpose) && !is_string($purpose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purpose, true), gettype($purpose)), __LINE__);
        }
        // validation for constraint: maxLength(14)
        if (!is_null($purpose) && mb_strlen($purpose) > 14) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 14', mb_strlen($purpose)), __LINE__);
        }
        $this->purpose = $purpose;
        return $this;
    }
    /**
     * Get bankCode value
     * @return string|null
     */
    public function getBankCode()
    {
        return $this->bankCode;
    }
    /**
     * Set bankCode value
     * @param string $bankCode
     * @return \dpd\StructType\Cod
     */
    public function setBankCode($bankCode = null)
    {
        // validation for constraint: string
        if (!is_null($bankCode) && !is_string($bankCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankCode, true), gettype($bankCode)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($bankCode) && mb_strlen($bankCode) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($bankCode)), __LINE__);
        }
        $this->bankCode = $bankCode;
        return $this;
    }
    /**
     * Get bankName value
     * @return string|null
     */
    public function getBankName()
    {
        return $this->bankName;
    }
    /**
     * Set bankName value
     * @param string $bankName
     * @return \dpd\StructType\Cod
     */
    public function setBankName($bankName = null)
    {
        // validation for constraint: string
        if (!is_null($bankName) && !is_string($bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankName, true), gettype($bankName)), __LINE__);
        }
        // validation for constraint: maxLength(27)
        if (!is_null($bankName) && mb_strlen($bankName) > 27) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 27', mb_strlen($bankName)), __LINE__);
        }
        $this->bankName = $bankName;
        return $this;
    }
    /**
     * Get bankAccountNumber value
     * @return string|null
     */
    public function getBankAccountNumber()
    {
        return $this->bankAccountNumber;
    }
    /**
     * Set bankAccountNumber value
     * @param string $bankAccountNumber
     * @return \dpd\StructType\Cod
     */
    public function setBankAccountNumber($bankAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($bankAccountNumber) && !is_string($bankAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankAccountNumber, true), gettype($bankAccountNumber)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($bankAccountNumber) && mb_strlen($bankAccountNumber) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($bankAccountNumber)), __LINE__);
        }
        $this->bankAccountNumber = $bankAccountNumber;
        return $this;
    }
    /**
     * Get bankAccountHolder value
     * @return string|null
     */
    public function getBankAccountHolder()
    {
        return $this->bankAccountHolder;
    }
    /**
     * Set bankAccountHolder value
     * @param string $bankAccountHolder
     * @return \dpd\StructType\Cod
     */
    public function setBankAccountHolder($bankAccountHolder = null)
    {
        // validation for constraint: string
        if (!is_null($bankAccountHolder) && !is_string($bankAccountHolder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankAccountHolder, true), gettype($bankAccountHolder)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($bankAccountHolder) && mb_strlen($bankAccountHolder) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($bankAccountHolder)), __LINE__);
        }
        $this->bankAccountHolder = $bankAccountHolder;
        return $this;
    }
    /**
     * Get iban value
     * @return string|null
     */
    public function getIban()
    {
        return $this->iban;
    }
    /**
     * Set iban value
     * @param string $iban
     * @return \dpd\StructType\Cod
     */
    public function setIban($iban = null)
    {
        // validation for constraint: string
        if (!is_null($iban) && !is_string($iban)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iban, true), gettype($iban)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($iban) && mb_strlen($iban) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($iban)), __LINE__);
        }
        $this->iban = $iban;
        return $this;
    }
    /**
     * Get bic value
     * @return string|null
     */
    public function getBic()
    {
        return $this->bic;
    }
    /**
     * Set bic value
     * @param string $bic
     * @return \dpd\StructType\Cod
     */
    public function setBic($bic = null)
    {
        // validation for constraint: string
        if (!is_null($bic) && !is_string($bic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bic, true), gettype($bic)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($bic) && mb_strlen($bic) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($bic)), __LINE__);
        }
        $this->bic = $bic;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dpd\StructType\Cod
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
