<?php

namespace dpd\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for additionalInvoiceLine StructType
 * Meta information extracted from the WSDL
 * - documentation: Bundles information about an invoice position for international parcels.
 * @subpackage Structs
 */
class AdditionalInvoiceLine extends AbstractStructBase
{
    /**
     * The customsContent
     * Meta information extracted from the WSDL
     * - documentation: Declares the content of the parcel. | Content.
     * - base: xs:string
     * - maxLength: 200
     * - minOccurs: 1
     * @var string
     */
    public $customsContent;
    /**
     * The customsInvoicePosition
     * Meta information extracted from the WSDL
     * - documentation: Number of invoice position.
     * - base: xs:int
     * - maxInclusive: 999999
     * - minOccurs: 0
     * @var int
     */
    public $customsInvoicePosition;
    /**
     * The quantityItems
     * Meta information extracted from the WSDL
     * - documentation: Number of items.
     * - base: xs:int
     * - maxInclusive: 9999
     * - minOccurs: 0
     * @var int
     */
    public $quantityItems;
    /**
     * The customsTarif
     * Meta information extracted from the WSDL
     * - documentation: Declares the customs tarif number. | Customs tarif number.
     * - base: xs:string
     * - maxLength: 10
     * - minOccurs: 0
     * @var string
     */
    public $customsTarif;
    /**
     * The customsAmountLine
     * Meta information extracted from the WSDL
     * - documentation: Value of invoice position (in invoice currency) with two decimal digits without separator.
     * - base: xs:long
     * - maxInclusive: 999999999999999
     * - minOccurs: 0
     * @var int
     */
    public $customsAmountLine;
    /**
     * The customsOrigin
     * Meta information extracted from the WSDL
     * - documentation: Origin country in ISO 3166-1 alpha-2 format (e.g. DE, EN). | Country of invoice origin (ISO 3166).
     * - base: xs:int
     * - maxInclusive: 999
     * - minOccurs: 0
     * @var int
     */
    public $customsOrigin;
    /**
     * The customsNetWeight
     * Meta information extracted from the WSDL
     * - documentation: Parcel net weight in gramm rounded in 10 gramm units without decimal delimiter (e.g. 300 equals 3kg).
     * - base: xs:int
     * - maxInclusive: 99999999
     * - minOccurs: 0
     * @var int
     */
    public $customsNetWeight;
    /**
     * The customsGrossWeight
     * Meta information extracted from the WSDL
     * - documentation: Parcel gross weight in gramm rounded in 10 gramm units without decimal delimiter (e.g. 300 equals 3kg).
     * - base: xs:int
     * - maxInclusive: 99999999
     * - minOccurs: 0
     * @var int
     */
    public $customsGrossWeight;
    /**
     * Constructor method for additionalInvoiceLine
     * @uses AdditionalInvoiceLine::setCustomsContent()
     * @uses AdditionalInvoiceLine::setCustomsInvoicePosition()
     * @uses AdditionalInvoiceLine::setQuantityItems()
     * @uses AdditionalInvoiceLine::setCustomsTarif()
     * @uses AdditionalInvoiceLine::setCustomsAmountLine()
     * @uses AdditionalInvoiceLine::setCustomsOrigin()
     * @uses AdditionalInvoiceLine::setCustomsNetWeight()
     * @uses AdditionalInvoiceLine::setCustomsGrossWeight()
     * @param string $customsContent
     * @param int $customsInvoicePosition
     * @param int $quantityItems
     * @param string $customsTarif
     * @param int $customsAmountLine
     * @param int $customsOrigin
     * @param int $customsNetWeight
     * @param int $customsGrossWeight
     */
    public function __construct($customsContent = null, $customsInvoicePosition = null, $quantityItems = null, $customsTarif = null, $customsAmountLine = null, $customsOrigin = null, $customsNetWeight = null, $customsGrossWeight = null)
    {
        $this
            ->setCustomsContent($customsContent)
            ->setCustomsInvoicePosition($customsInvoicePosition)
            ->setQuantityItems($quantityItems)
            ->setCustomsTarif($customsTarif)
            ->setCustomsAmountLine($customsAmountLine)
            ->setCustomsOrigin($customsOrigin)
            ->setCustomsNetWeight($customsNetWeight)
            ->setCustomsGrossWeight($customsGrossWeight);
    }
    /**
     * Get customsContent value
     * @return string
     */
    public function getCustomsContent()
    {
        return $this->customsContent;
    }
    /**
     * Set customsContent value
     * @param string $customsContent
     * @return \dpd\StructType\AdditionalInvoiceLine
     */
    public function setCustomsContent($customsContent = null)
    {
        // validation for constraint: string
        if (!is_null($customsContent) && !is_string($customsContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customsContent, true), gettype($customsContent)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($customsContent) && mb_strlen($customsContent) > 200) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen($customsContent)), __LINE__);
        }
        $this->customsContent = $customsContent;
        return $this;
    }
    /**
     * Get customsInvoicePosition value
     * @return int|null
     */
    public function getCustomsInvoicePosition()
    {
        return $this->customsInvoicePosition;
    }
    /**
     * Set customsInvoicePosition value
     * @param int $customsInvoicePosition
     * @return \dpd\StructType\AdditionalInvoiceLine
     */
    public function setCustomsInvoicePosition($customsInvoicePosition = null)
    {
        // validation for constraint: int
        if (!is_null($customsInvoicePosition) && !(is_int($customsInvoicePosition) || ctype_digit($customsInvoicePosition))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customsInvoicePosition, true), gettype($customsInvoicePosition)), __LINE__);
        }
        // validation for constraint: maxInclusive(999999)
        if (!is_null($customsInvoicePosition) && $customsInvoicePosition > 999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999999', var_export($customsInvoicePosition, true)), __LINE__);
        }
        $this->customsInvoicePosition = $customsInvoicePosition;
        return $this;
    }
    /**
     * Get quantityItems value
     * @return int|null
     */
    public function getQuantityItems()
    {
        return $this->quantityItems;
    }
    /**
     * Set quantityItems value
     * @param int $quantityItems
     * @return \dpd\StructType\AdditionalInvoiceLine
     */
    public function setQuantityItems($quantityItems = null)
    {
        // validation for constraint: int
        if (!is_null($quantityItems) && !(is_int($quantityItems) || ctype_digit($quantityItems))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantityItems, true), gettype($quantityItems)), __LINE__);
        }
        // validation for constraint: maxInclusive(9999)
        if (!is_null($quantityItems) && $quantityItems > 9999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999', var_export($quantityItems, true)), __LINE__);
        }
        $this->quantityItems = $quantityItems;
        return $this;
    }
    /**
     * Get customsTarif value
     * @return string|null
     */
    public function getCustomsTarif()
    {
        return $this->customsTarif;
    }
    /**
     * Set customsTarif value
     * @param string $customsTarif
     * @return \dpd\StructType\AdditionalInvoiceLine
     */
    public function setCustomsTarif($customsTarif = null)
    {
        // validation for constraint: string
        if (!is_null($customsTarif) && !is_string($customsTarif)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customsTarif, true), gettype($customsTarif)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($customsTarif) && mb_strlen($customsTarif) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($customsTarif)), __LINE__);
        }
        $this->customsTarif = $customsTarif;
        return $this;
    }
    /**
     * Get customsAmountLine value
     * @return int|null
     */
    public function getCustomsAmountLine()
    {
        return $this->customsAmountLine;
    }
    /**
     * Set customsAmountLine value
     * @param int $customsAmountLine
     * @return \dpd\StructType\AdditionalInvoiceLine
     */
    public function setCustomsAmountLine($customsAmountLine = null)
    {
        // validation for constraint: int
        if (!is_null($customsAmountLine) && !(is_int($customsAmountLine) || ctype_digit($customsAmountLine))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customsAmountLine, true), gettype($customsAmountLine)), __LINE__);
        }
        // validation for constraint: maxInclusive(999999999999999)
        if (!is_null($customsAmountLine) && $customsAmountLine > 999999999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999999999999999', var_export($customsAmountLine, true)), __LINE__);
        }
        $this->customsAmountLine = $customsAmountLine;
        return $this;
    }
    /**
     * Get customsOrigin value
     * @return int|null
     */
    public function getCustomsOrigin()
    {
        return $this->customsOrigin;
    }
    /**
     * Set customsOrigin value
     * @param int $customsOrigin
     * @return \dpd\StructType\AdditionalInvoiceLine
     */
    public function setCustomsOrigin($customsOrigin = null)
    {
        // validation for constraint: int
        if (!is_null($customsOrigin) && !(is_int($customsOrigin) || ctype_digit($customsOrigin))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customsOrigin, true), gettype($customsOrigin)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($customsOrigin) && $customsOrigin > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($customsOrigin, true)), __LINE__);
        }
        $this->customsOrigin = $customsOrigin;
        return $this;
    }
    /**
     * Get customsNetWeight value
     * @return int|null
     */
    public function getCustomsNetWeight()
    {
        return $this->customsNetWeight;
    }
    /**
     * Set customsNetWeight value
     * @param int $customsNetWeight
     * @return \dpd\StructType\AdditionalInvoiceLine
     */
    public function setCustomsNetWeight($customsNetWeight = null)
    {
        // validation for constraint: int
        if (!is_null($customsNetWeight) && !(is_int($customsNetWeight) || ctype_digit($customsNetWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customsNetWeight, true), gettype($customsNetWeight)), __LINE__);
        }
        // validation for constraint: maxInclusive(99999999)
        if (!is_null($customsNetWeight) && $customsNetWeight > 99999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99999999', var_export($customsNetWeight, true)), __LINE__);
        }
        $this->customsNetWeight = $customsNetWeight;
        return $this;
    }
    /**
     * Get customsGrossWeight value
     * @return int|null
     */
    public function getCustomsGrossWeight()
    {
        return $this->customsGrossWeight;
    }
    /**
     * Set customsGrossWeight value
     * @param int $customsGrossWeight
     * @return \dpd\StructType\AdditionalInvoiceLine
     */
    public function setCustomsGrossWeight($customsGrossWeight = null)
    {
        // validation for constraint: int
        if (!is_null($customsGrossWeight) && !(is_int($customsGrossWeight) || ctype_digit($customsGrossWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customsGrossWeight, true), gettype($customsGrossWeight)), __LINE__);
        }
        // validation for constraint: maxInclusive(99999999)
        if (!is_null($customsGrossWeight) && $customsGrossWeight > 99999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99999999', var_export($customsGrossWeight, true)), __LINE__);
        }
        $this->customsGrossWeight = $customsGrossWeight;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dpd\StructType\AdditionalInvoiceLine
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
