<?php

namespace dpd\EnumType;

/**
 * This class stands for paperFormat EnumType
 * Meta information extracted from the WSDL
 * - documentation: Declares the paper format for parcel label print, either "A4", "A6" or "A7".For direct printing must be set to "A6". "A7" only prints return labels.
 * @subpackage Enumerations
 */
class PaperFormat
{
    /**
     * Constant for value 'A4'
     * @return string 'A4'
     */
    const VALUE_A_4 = 'A4';
    /**
     * Constant for value 'A6'
     * @return string 'A6'
     */
    const VALUE_A_6 = 'A6';
    /**
     * Constant for value 'A7'
     * Meta information extracted from the WSDL
     * - documentation: Only for return labels.
     * @return string 'A7'
     */
    const VALUE_A_7 = 'A7';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_A_4
     * @uses self::VALUE_A_6
     * @uses self::VALUE_A_7
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_A_4,
            self::VALUE_A_6,
            self::VALUE_A_7,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
