<?php

namespace dpd\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for storeOrdersResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Bundles storeOrders response data.
 * @subpackage Structs
 */
class StoreOrdersResponseType extends AbstractStructBase
{
    /**
     * The output
     * Meta information extracted from the WSDL
     * - documentation: Contains parcel label data in bytes.
     * - minOccurs: 0
     * @var \dpd\StructType\OutputType
     */
    public $output;
    /**
     * The shipmentResponses
     * Meta information extracted from the WSDL
     * - documentation: Contains response data for every shipment order.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dpd\StructType\ShipmentResponse[]
     */
    public $shipmentResponses;
    /**
     * Constructor method for storeOrdersResponseType
     * @uses StoreOrdersResponseType::setOutput()
     * @uses StoreOrdersResponseType::setShipmentResponses()
     * @param \dpd\StructType\OutputType $output
     * @param \dpd\StructType\ShipmentResponse[] $shipmentResponses
     */
    public function __construct(\dpd\StructType\OutputType $output = null, array $shipmentResponses = array())
    {
        $this
            ->setOutput($output)
            ->setShipmentResponses($shipmentResponses);
    }
    /**
     * Get output value
     * @return \dpd\StructType\OutputType|null
     */
    public function getOutput()
    {
        return $this->output;
    }
    /**
     * Set output value
     * @param \dpd\StructType\OutputType $output
     * @return \dpd\StructType\StoreOrdersResponseType
     */
    public function setOutput(\dpd\StructType\OutputType $output = null)
    {
        $this->output = $output;
        return $this;
    }
    /**
     * Get shipmentResponses value
     * @return \dpd\StructType\ShipmentResponse[]|null
     */
    public function getShipmentResponses()
    {
        return $this->shipmentResponses;
    }
    /**
     * This method is responsible for validating the values passed to the setShipmentResponses method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipmentResponses method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentResponsesForArrayConstraintsFromSetShipmentResponses(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $storeOrdersResponseTypeShipmentResponsesItem) {
            // validation for constraint: itemType
            if (!$storeOrdersResponseTypeShipmentResponsesItem instanceof \dpd\StructType\ShipmentResponse) {
                $invalidValues[] = is_object($storeOrdersResponseTypeShipmentResponsesItem) ? get_class($storeOrdersResponseTypeShipmentResponsesItem) : sprintf('%s(%s)', gettype($storeOrdersResponseTypeShipmentResponsesItem), var_export($storeOrdersResponseTypeShipmentResponsesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The shipmentResponses property can only contain items of type \dpd\StructType\ShipmentResponse, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set shipmentResponses value
     * @throws \InvalidArgumentException
     * @param \dpd\StructType\ShipmentResponse[] $shipmentResponses
     * @return \dpd\StructType\StoreOrdersResponseType
     */
    public function setShipmentResponses(array $shipmentResponses = array())
    {
        // validation for constraint: array
        if ('' !== ($shipmentResponsesArrayErrorMessage = self::validateShipmentResponsesForArrayConstraintsFromSetShipmentResponses($shipmentResponses))) {
            throw new \InvalidArgumentException($shipmentResponsesArrayErrorMessage, __LINE__);
        }
        $this->shipmentResponses = $shipmentResponses;
        return $this;
    }
    /**
     * Add item to shipmentResponses value
     * @throws \InvalidArgumentException
     * @param \dpd\StructType\ShipmentResponse $item
     * @return \dpd\StructType\StoreOrdersResponseType
     */
    public function addToShipmentResponses(\dpd\StructType\ShipmentResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dpd\StructType\ShipmentResponse) {
            throw new \InvalidArgumentException(sprintf('The shipmentResponses property can only contain items of type \dpd\StructType\ShipmentResponse, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->shipmentResponses[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dpd\StructType\StoreOrdersResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
