<?php

namespace dpd\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for parcel StructType
 * Meta information extracted from the WSDL
 * - documentation: Bundles parcel data.
 * @subpackage Structs
 */
class Parcel extends AbstractStructBase
{
    /**
     * The parcelLabelNumber
     * Meta information extracted from the WSDL
     * - documentation: Parcel label number. Number range and validity are checked.
     * - base: xs:string
     * - maxLength: 14
     * - minLength: 11
     * - minOccurs: 0
     * @var string
     */
    public $parcelLabelNumber;
    /**
     * The customerReferenceNumber1
     * Meta information extracted from the WSDL
     * - documentation: Parcel customer reference number 1.
     * - base: xs:string
     * - maxLength: 35
     * - minOccurs: 0
     * @var string
     */
    public $customerReferenceNumber1;
    /**
     * The customerReferenceNumber2
     * Meta information extracted from the WSDL
     * - documentation: Parcel customer reference number 2.
     * - base: xs:string
     * - maxLength: 35
     * - minOccurs: 0
     * @var string
     */
    public $customerReferenceNumber2;
    /**
     * The customerReferenceNumber3
     * Meta information extracted from the WSDL
     * - documentation: Parcel customer reference number 3.
     * - base: xs:string
     * - maxLength: 35
     * - minOccurs: 0
     * @var string
     */
    public $customerReferenceNumber3;
    /**
     * The customerReferenceNumber4
     * Meta information extracted from the WSDL
     * - documentation: Parcel customer reference number 4.
     * - base: xs:string
     * - maxLength: 35
     * - minOccurs: 0
     * @var string
     */
    public $customerReferenceNumber4;
    /**
     * The swap
     * Meta information extracted from the WSDL
     * - documentation: Specifies if this parcel is a consignment swap parcel. Default value is false.
     * - minOccurs: 0
     * @var bool
     */
    public $swap;
    /**
     * The volume
     * Meta information extracted from the WSDL
     * - documentation: Volume of the single parcel (length/width/height in format LLLWWWHHH) in cm without separators.
     * - base: xs:int
     * - maxInclusive: 999999999
     * - minOccurs: 0
     * @var int
     */
    public $volume;
    /**
     * The weight
     * Meta information extracted from the WSDL
     * - documentation: Parcel weight in grams rounded in 10 gram units without decimal point (e.g. 300 equals 3kg).Consignment allows 8-digit values, collection requests 7-digit and dangerous goods 6-digit.
     * - base: xs:int
     * - maxInclusive: 99999999
     * - minOccurs: 0
     * @var int
     */
    public $weight;
    /**
     * The hazardousLimitedQuantities
     * Meta information extracted from the WSDL
     * - documentation: Specifies if this parcel is a limited quantities hazardous goods parcel. Default value is false.
     * - minOccurs: 0
     * @var bool
     */
    public $hazardousLimitedQuantities;
    /**
     * The higherInsurance
     * Meta information extracted from the WSDL
     * - documentation: Specifies if this parcel has increased insurance value. Default value is false.
     * - minOccurs: 0
     * @var \dpd\StructType\HigherInsurance
     */
    public $higherInsurance;
    /**
     * The content
     * Meta information extracted from the WSDL
     * - documentation: Content of this parcel, mandatory for increased insurance.For collection requests maximum length is 50, for consignment it is 35.
     * - base: xs:string
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $content;
    /**
     * The addService
     * Meta information extracted from the WSDL
     * - documentation: Additional service.Possible values are:1 = Delivery information,2 = Documents return,3 = Written permission to deposit goods by sender.
     * - base: xs:int
     * - maxInclusive: 3
     * - minInclusive: 1
     * - minOccurs: 0
     * @var int
     */
    public $addService;
    /**
     * The messageNumber
     * Meta information extracted from the WSDL
     * - documentation: Message number for consignment shipper information. Default value is 1.
     * - base: xs:int
     * - maxInclusive: 99999
     * - minOccurs: 0
     * @var int
     */
    public $messageNumber;
    /**
     * The function
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $function;
    /**
     * The parameter
     * Meta information extracted from the WSDL
     * - documentation: Free text for blockable functions.
     * - base: xs:string
     * - maxLength: 300
     * - minOccurs: 0
     * @var string
     */
    public $parameter;
    /**
     * The cod
     * Meta information extracted from the WSDL
     * - documentation: Contains COD data for COD consignments.
     * - minOccurs: 0
     * @var \dpd\StructType\Cod
     */
    public $cod;
    /**
     * The international
     * Meta information extracted from the WSDL
     * - documentation: Contains data for consignments across customs borders.
     * - minOccurs: 0
     * @var \dpd\StructType\International
     */
    public $international;
    /**
     * The hazardous
     * Meta information extracted from the WSDL
     * - documentation: Contains packing and substance data for dangerous goods.
     * - maxOccurs: 4
     * - minOccurs: 0
     * @var \dpd\StructType\Hazardous[]
     */
    public $hazardous;
    /**
     * The printInfo1OnParcelLabel
     * Meta information extracted from the WSDL
     * - documentation: Flag for determining if content of parameter info1 will be added on the label of a collection request parcel. Default value is false.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $printInfo1OnParcelLabel;
    /**
     * The info1
     * Meta information extracted from the WSDL
     * - documentation: Information text 1. This will be printed on the parcel label if the flag printInfo1OnParcellabel is set to true.
     * - base: xs:string
     * - maxLength: 29
     * - minOccurs: 0
     * @var string
     */
    public $info1;
    /**
     * The info2
     * Meta information extracted from the WSDL
     * - documentation: Information text 2. This will not be printed on the parcel label.
     * - base: xs:string
     * - maxLength: 30
     * - minOccurs: 0
     * @var string
     */
    public $info2;
    /**
     * The returns
     * Meta information extracted from the WSDL
     * - documentation: Specifies if parcel is a return parcel.The return parcel must always be next in order to the corresponding outbound parcel. Default value is false.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $returns;
    /**
     * The parcelClass
     * Meta information extracted from the WSDL
     * - documentation: Parcel class. See Parcelclass in MPSEXPDATA specification for valid values.
     * - base: xs:string
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $parcelClass;
    /**
     * Constructor method for parcel
     * @uses Parcel::setParcelLabelNumber()
     * @uses Parcel::setCustomerReferenceNumber1()
     * @uses Parcel::setCustomerReferenceNumber2()
     * @uses Parcel::setCustomerReferenceNumber3()
     * @uses Parcel::setCustomerReferenceNumber4()
     * @uses Parcel::setSwap()
     * @uses Parcel::setVolume()
     * @uses Parcel::setWeight()
     * @uses Parcel::setHazardousLimitedQuantities()
     * @uses Parcel::setHigherInsurance()
     * @uses Parcel::setContent()
     * @uses Parcel::setAddService()
     * @uses Parcel::setMessageNumber()
     * @uses Parcel::setFunction()
     * @uses Parcel::setParameter()
     * @uses Parcel::setCod()
     * @uses Parcel::setInternational()
     * @uses Parcel::setHazardous()
     * @uses Parcel::setPrintInfo1OnParcelLabel()
     * @uses Parcel::setInfo1()
     * @uses Parcel::setInfo2()
     * @uses Parcel::setReturns()
     * @uses Parcel::setParcelClass()
     * @param string $parcelLabelNumber
     * @param string $customerReferenceNumber1
     * @param string $customerReferenceNumber2
     * @param string $customerReferenceNumber3
     * @param string $customerReferenceNumber4
     * @param bool $swap
     * @param int $volume
     * @param int $weight
     * @param bool $hazardousLimitedQuantities
     * @param \dpd\StructType\HigherInsurance $higherInsurance
     * @param string $content
     * @param int $addService
     * @param int $messageNumber
     * @param string $function
     * @param string $parameter
     * @param \dpd\StructType\Cod $cod
     * @param \dpd\StructType\International $international
     * @param \dpd\StructType\Hazardous[] $hazardous
     * @param bool $printInfo1OnParcelLabel
     * @param string $info1
     * @param string $info2
     * @param bool $returns
     * @param string $parcelClass
     */
    public function __construct($parcelLabelNumber = null, $customerReferenceNumber1 = null, $customerReferenceNumber2 = null, $customerReferenceNumber3 = null, $customerReferenceNumber4 = null, $swap = null, $volume = null, $weight = null, $hazardousLimitedQuantities = null, \dpd\StructType\HigherInsurance $higherInsurance = null, $content = null, $addService = null, $messageNumber = null, $function = null, $parameter = null, \dpd\StructType\Cod $cod = null, \dpd\StructType\International $international = null, array $hazardous = array(), $printInfo1OnParcelLabel = null, $info1 = null, $info2 = null, $returns = null, $parcelClass = null)
    {
        $this
            ->setParcelLabelNumber($parcelLabelNumber)
            ->setCustomerReferenceNumber1($customerReferenceNumber1)
            ->setCustomerReferenceNumber2($customerReferenceNumber2)
            ->setCustomerReferenceNumber3($customerReferenceNumber3)
            ->setCustomerReferenceNumber4($customerReferenceNumber4)
            ->setSwap($swap)
            ->setVolume($volume)
            ->setWeight($weight)
            ->setHazardousLimitedQuantities($hazardousLimitedQuantities)
            ->setHigherInsurance($higherInsurance)
            ->setContent($content)
            ->setAddService($addService)
            ->setMessageNumber($messageNumber)
            ->setFunction($function)
            ->setParameter($parameter)
            ->setCod($cod)
            ->setInternational($international)
            ->setHazardous($hazardous)
            ->setPrintInfo1OnParcelLabel($printInfo1OnParcelLabel)
            ->setInfo1($info1)
            ->setInfo2($info2)
            ->setReturns($returns)
            ->setParcelClass($parcelClass);
    }
    /**
     * Get parcelLabelNumber value
     * @return string|null
     */
    public function getParcelLabelNumber()
    {
        return $this->parcelLabelNumber;
    }
    /**
     * Set parcelLabelNumber value
     * @param string $parcelLabelNumber
     * @return \dpd\StructType\Parcel
     */
    public function setParcelLabelNumber($parcelLabelNumber = null)
    {
        // validation for constraint: string
        if (!is_null($parcelLabelNumber) && !is_string($parcelLabelNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parcelLabelNumber, true), gettype($parcelLabelNumber)), __LINE__);
        }
        // validation for constraint: maxLength(14)
        if (!is_null($parcelLabelNumber) && mb_strlen($parcelLabelNumber) > 14) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 14', mb_strlen($parcelLabelNumber)), __LINE__);
        }
        // validation for constraint: minLength(11)
        if (!is_null($parcelLabelNumber) && mb_strlen($parcelLabelNumber) < 11) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 11', mb_strlen($parcelLabelNumber)), __LINE__);
        }
        $this->parcelLabelNumber = $parcelLabelNumber;
        return $this;
    }
    /**
     * Get customerReferenceNumber1 value
     * @return string|null
     */
    public function getCustomerReferenceNumber1()
    {
        return $this->customerReferenceNumber1;
    }
    /**
     * Set customerReferenceNumber1 value
     * @param string $customerReferenceNumber1
     * @return \dpd\StructType\Parcel
     */
    public function setCustomerReferenceNumber1($customerReferenceNumber1 = null)
    {
        // validation for constraint: string
        if (!is_null($customerReferenceNumber1) && !is_string($customerReferenceNumber1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerReferenceNumber1, true), gettype($customerReferenceNumber1)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($customerReferenceNumber1) && mb_strlen($customerReferenceNumber1) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($customerReferenceNumber1)), __LINE__);
        }
        $this->customerReferenceNumber1 = $customerReferenceNumber1;
        return $this;
    }
    /**
     * Get customerReferenceNumber2 value
     * @return string|null
     */
    public function getCustomerReferenceNumber2()
    {
        return $this->customerReferenceNumber2;
    }
    /**
     * Set customerReferenceNumber2 value
     * @param string $customerReferenceNumber2
     * @return \dpd\StructType\Parcel
     */
    public function setCustomerReferenceNumber2($customerReferenceNumber2 = null)
    {
        // validation for constraint: string
        if (!is_null($customerReferenceNumber2) && !is_string($customerReferenceNumber2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerReferenceNumber2, true), gettype($customerReferenceNumber2)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($customerReferenceNumber2) && mb_strlen($customerReferenceNumber2) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($customerReferenceNumber2)), __LINE__);
        }
        $this->customerReferenceNumber2 = $customerReferenceNumber2;
        return $this;
    }
    /**
     * Get customerReferenceNumber3 value
     * @return string|null
     */
    public function getCustomerReferenceNumber3()
    {
        return $this->customerReferenceNumber3;
    }
    /**
     * Set customerReferenceNumber3 value
     * @param string $customerReferenceNumber3
     * @return \dpd\StructType\Parcel
     */
    public function setCustomerReferenceNumber3($customerReferenceNumber3 = null)
    {
        // validation for constraint: string
        if (!is_null($customerReferenceNumber3) && !is_string($customerReferenceNumber3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerReferenceNumber3, true), gettype($customerReferenceNumber3)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($customerReferenceNumber3) && mb_strlen($customerReferenceNumber3) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($customerReferenceNumber3)), __LINE__);
        }
        $this->customerReferenceNumber3 = $customerReferenceNumber3;
        return $this;
    }
    /**
     * Get customerReferenceNumber4 value
     * @return string|null
     */
    public function getCustomerReferenceNumber4()
    {
        return $this->customerReferenceNumber4;
    }
    /**
     * Set customerReferenceNumber4 value
     * @param string $customerReferenceNumber4
     * @return \dpd\StructType\Parcel
     */
    public function setCustomerReferenceNumber4($customerReferenceNumber4 = null)
    {
        // validation for constraint: string
        if (!is_null($customerReferenceNumber4) && !is_string($customerReferenceNumber4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerReferenceNumber4, true), gettype($customerReferenceNumber4)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($customerReferenceNumber4) && mb_strlen($customerReferenceNumber4) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($customerReferenceNumber4)), __LINE__);
        }
        $this->customerReferenceNumber4 = $customerReferenceNumber4;
        return $this;
    }
    /**
     * Get swap value
     * @return bool|null
     */
    public function getSwap()
    {
        return $this->swap;
    }
    /**
     * Set swap value
     * @param bool $swap
     * @return \dpd\StructType\Parcel
     */
    public function setSwap($swap = null)
    {
        // validation for constraint: boolean
        if (!is_null($swap) && !is_bool($swap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($swap, true), gettype($swap)), __LINE__);
        }
        $this->swap = $swap;
        return $this;
    }
    /**
     * Get volume value
     * @return int|null
     */
    public function getVolume()
    {
        return $this->volume;
    }
    /**
     * Set volume value
     * @param int $volume
     * @return \dpd\StructType\Parcel
     */
    public function setVolume($volume = null)
    {
        // validation for constraint: int
        if (!is_null($volume) && !(is_int($volume) || ctype_digit($volume))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($volume, true), gettype($volume)), __LINE__);
        }
        // validation for constraint: maxInclusive(999999999)
        if (!is_null($volume) && $volume > 999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999999999', var_export($volume, true)), __LINE__);
        }
        $this->volume = $volume;
        return $this;
    }
    /**
     * Get weight value
     * @return int|null
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param int $weight
     * @return \dpd\StructType\Parcel
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: int
        if (!is_null($weight) && !(is_int($weight) || ctype_digit($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        // validation for constraint: maxInclusive(99999999)
        if (!is_null($weight) && $weight > 99999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99999999', var_export($weight, true)), __LINE__);
        }
        $this->weight = $weight;
        return $this;
    }
    /**
     * Get hazardousLimitedQuantities value
     * @return bool|null
     */
    public function getHazardousLimitedQuantities()
    {
        return $this->hazardousLimitedQuantities;
    }
    /**
     * Set hazardousLimitedQuantities value
     * @param bool $hazardousLimitedQuantities
     * @return \dpd\StructType\Parcel
     */
    public function setHazardousLimitedQuantities($hazardousLimitedQuantities = null)
    {
        // validation for constraint: boolean
        if (!is_null($hazardousLimitedQuantities) && !is_bool($hazardousLimitedQuantities)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hazardousLimitedQuantities, true), gettype($hazardousLimitedQuantities)), __LINE__);
        }
        $this->hazardousLimitedQuantities = $hazardousLimitedQuantities;
        return $this;
    }
    /**
     * Get higherInsurance value
     * @return \dpd\StructType\HigherInsurance|null
     */
    public function getHigherInsurance()
    {
        return $this->higherInsurance;
    }
    /**
     * Set higherInsurance value
     * @param \dpd\StructType\HigherInsurance $higherInsurance
     * @return \dpd\StructType\Parcel
     */
    public function setHigherInsurance(\dpd\StructType\HigherInsurance $higherInsurance = null)
    {
        $this->higherInsurance = $higherInsurance;
        return $this;
    }
    /**
     * Get content value
     * @return string|null
     */
    public function getContent()
    {
        return $this->content;
    }
    /**
     * Set content value
     * @param string $content
     * @return \dpd\StructType\Parcel
     */
    public function setContent($content = null)
    {
        // validation for constraint: string
        if (!is_null($content) && !is_string($content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($content, true), gettype($content)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($content) && mb_strlen($content) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($content)), __LINE__);
        }
        $this->content = $content;
        return $this;
    }
    /**
     * Get addService value
     * @return int|null
     */
    public function getAddService()
    {
        return $this->addService;
    }
    /**
     * Set addService value
     * @param int $addService
     * @return \dpd\StructType\Parcel
     */
    public function setAddService($addService = null)
    {
        // validation for constraint: int
        if (!is_null($addService) && !(is_int($addService) || ctype_digit($addService))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($addService, true), gettype($addService)), __LINE__);
        }
        // validation for constraint: maxInclusive(3)
        if (!is_null($addService) && $addService > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 3', var_export($addService, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($addService) && $addService < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($addService, true)), __LINE__);
        }
        $this->addService = $addService;
        return $this;
    }
    /**
     * Get messageNumber value
     * @return int|null
     */
    public function getMessageNumber()
    {
        return $this->messageNumber;
    }
    /**
     * Set messageNumber value
     * @param int $messageNumber
     * @return \dpd\StructType\Parcel
     */
    public function setMessageNumber($messageNumber = null)
    {
        // validation for constraint: int
        if (!is_null($messageNumber) && !(is_int($messageNumber) || ctype_digit($messageNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($messageNumber, true), gettype($messageNumber)), __LINE__);
        }
        // validation for constraint: maxInclusive(99999)
        if (!is_null($messageNumber) && $messageNumber > 99999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99999', var_export($messageNumber, true)), __LINE__);
        }
        $this->messageNumber = $messageNumber;
        return $this;
    }
    /**
     * Get function value
     * @return string|null
     */
    public function getFunction()
    {
        return $this->function;
    }
    /**
     * Set function value
     * @uses \dpd\EnumType\_function::valueIsValid()
     * @uses \dpd\EnumType\_function::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $function
     * @return \dpd\StructType\Parcel
     */
    public function setFunction($function = null)
    {
        // validation for constraint: enumeration
        if (!\dpd\EnumType\_function::valueIsValid($function)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \dpd\EnumType\_function', is_array($function) ? implode(', ', $function) : var_export($function, true), implode(', ', \dpd\EnumType\_function::getValidValues())), __LINE__);
        }
        $this->function = $function;
        return $this;
    }
    /**
     * Get parameter value
     * @return string|null
     */
    public function getParameter()
    {
        return $this->parameter;
    }
    /**
     * Set parameter value
     * @param string $parameter
     * @return \dpd\StructType\Parcel
     */
    public function setParameter($parameter = null)
    {
        // validation for constraint: string
        if (!is_null($parameter) && !is_string($parameter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parameter, true), gettype($parameter)), __LINE__);
        }
        // validation for constraint: maxLength(300)
        if (!is_null($parameter) && mb_strlen($parameter) > 300) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 300', mb_strlen($parameter)), __LINE__);
        }
        $this->parameter = $parameter;
        return $this;
    }
    /**
     * Get cod value
     * @return \dpd\StructType\Cod|null
     */
    public function getCod()
    {
        return $this->cod;
    }
    /**
     * Set cod value
     * @param \dpd\StructType\Cod $cod
     * @return \dpd\StructType\Parcel
     */
    public function setCod(\dpd\StructType\Cod $cod = null)
    {
        $this->cod = $cod;
        return $this;
    }
    /**
     * Get international value
     * @return \dpd\StructType\International|null
     */
    public function getInternational()
    {
        return $this->international;
    }
    /**
     * Set international value
     * @param \dpd\StructType\International $international
     * @return \dpd\StructType\Parcel
     */
    public function setInternational(\dpd\StructType\International $international = null)
    {
        $this->international = $international;
        return $this;
    }
    /**
     * Get hazardous value
     * @return \dpd\StructType\Hazardous[]|null
     */
    public function getHazardous()
    {
        return $this->hazardous;
    }
    /**
     * This method is responsible for validating the values passed to the setHazardous method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHazardous method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHazardousForArrayConstraintsFromSetHazardous(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $parcelHazardousItem) {
            // validation for constraint: itemType
            if (!$parcelHazardousItem instanceof \dpd\StructType\Hazardous) {
                $invalidValues[] = is_object($parcelHazardousItem) ? get_class($parcelHazardousItem) : sprintf('%s(%s)', gettype($parcelHazardousItem), var_export($parcelHazardousItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The hazardous property can only contain items of type \dpd\StructType\Hazardous, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set hazardous value
     * @throws \InvalidArgumentException
     * @param \dpd\StructType\Hazardous[] $hazardous
     * @return \dpd\StructType\Parcel
     */
    public function setHazardous(array $hazardous = array())
    {
        // validation for constraint: array
        if ('' !== ($hazardousArrayErrorMessage = self::validateHazardousForArrayConstraintsFromSetHazardous($hazardous))) {
            throw new \InvalidArgumentException($hazardousArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($hazardous) && count($hazardous) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 4', count($hazardous)), __LINE__);
        }
        $this->hazardous = $hazardous;
        return $this;
    }
    /**
     * Add item to hazardous value
     * @throws \InvalidArgumentException
     * @param \dpd\StructType\Hazardous $item
     * @return \dpd\StructType\Parcel
     */
    public function addToHazardous(\dpd\StructType\Hazardous $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dpd\StructType\Hazardous) {
            throw new \InvalidArgumentException(sprintf('The hazardous property can only contain items of type \dpd\StructType\Hazardous, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($this->hazardous) && count($this->hazardous) >= 4) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 4', count($this->hazardous)), __LINE__);
        }
        $this->hazardous[] = $item;
        return $this;
    }
    /**
     * Get printInfo1OnParcelLabel value
     * @return bool|null
     */
    public function getPrintInfo1OnParcelLabel()
    {
        return $this->printInfo1OnParcelLabel;
    }
    /**
     * Set printInfo1OnParcelLabel value
     * @param bool $printInfo1OnParcelLabel
     * @return \dpd\StructType\Parcel
     */
    public function setPrintInfo1OnParcelLabel($printInfo1OnParcelLabel = null)
    {
        // validation for constraint: boolean
        if (!is_null($printInfo1OnParcelLabel) && !is_bool($printInfo1OnParcelLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($printInfo1OnParcelLabel, true), gettype($printInfo1OnParcelLabel)), __LINE__);
        }
        $this->printInfo1OnParcelLabel = $printInfo1OnParcelLabel;
        return $this;
    }
    /**
     * Get info1 value
     * @return string|null
     */
    public function getInfo1()
    {
        return $this->info1;
    }
    /**
     * Set info1 value
     * @param string $info1
     * @return \dpd\StructType\Parcel
     */
    public function setInfo1($info1 = null)
    {
        // validation for constraint: string
        if (!is_null($info1) && !is_string($info1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($info1, true), gettype($info1)), __LINE__);
        }
        // validation for constraint: maxLength(29)
        if (!is_null($info1) && mb_strlen($info1) > 29) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 29', mb_strlen($info1)), __LINE__);
        }
        $this->info1 = $info1;
        return $this;
    }
    /**
     * Get info2 value
     * @return string|null
     */
    public function getInfo2()
    {
        return $this->info2;
    }
    /**
     * Set info2 value
     * @param string $info2
     * @return \dpd\StructType\Parcel
     */
    public function setInfo2($info2 = null)
    {
        // validation for constraint: string
        if (!is_null($info2) && !is_string($info2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($info2, true), gettype($info2)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($info2) && mb_strlen($info2) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($info2)), __LINE__);
        }
        $this->info2 = $info2;
        return $this;
    }
    /**
     * Get returns value
     * @return bool|null
     */
    public function getReturns()
    {
        return $this->returns;
    }
    /**
     * Set returns value
     * @param bool $returns
     * @return \dpd\StructType\Parcel
     */
    public function setReturns($returns = null)
    {
        // validation for constraint: boolean
        if (!is_null($returns) && !is_bool($returns)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($returns, true), gettype($returns)), __LINE__);
        }
        $this->returns = $returns;
        return $this;
    }
    /**
     * Get parcelClass value
     * @return string|null
     */
    public function getParcelClass()
    {
        return $this->parcelClass;
    }
    /**
     * Set parcelClass value
     * @param string $parcelClass
     * @return \dpd\StructType\Parcel
     */
    public function setParcelClass($parcelClass = null)
    {
        // validation for constraint: string
        if (!is_null($parcelClass) && !is_string($parcelClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parcelClass, true), gettype($parcelClass)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($parcelClass) && mb_strlen($parcelClass) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($parcelClass)), __LINE__);
        }
        $this->parcelClass = $parcelClass;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dpd\StructType\Parcel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
