<?php

namespace dpd\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OutputType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains the output data, e.g. parcel labels.
 * @subpackage Structs
 */
class OutputType extends AbstractStructBase
{
    /**
     * The format
     * Meta information extracted from the WSDL
     * - documentation: The type of the output data.
     * - minOccurs: 1
     * @var string
     */
    public $format;
    /**
     * The content
     * Meta information extracted from the WSDL
     * - documentation: The output data
     * - minOccurs: 1
     * @var string
     */
    public $content;
    /**
     * Constructor method for OutputType
     * @uses OutputType::setFormat()
     * @uses OutputType::setContent()
     * @param string $format
     * @param string $content
     */
    public function __construct($format = null, $content = null)
    {
        $this
            ->setFormat($format)
            ->setContent($content);
    }
    /**
     * Get format value
     * @return string
     */
    public function getFormat()
    {
        return $this->format;
    }
    /**
     * Set format value
     * @uses \dpd\EnumType\OutputFormatType::valueIsValid()
     * @uses \dpd\EnumType\OutputFormatType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $format
     * @return \dpd\StructType\OutputType
     */
    public function setFormat($format = null)
    {
        // validation for constraint: enumeration
        if (!\dpd\EnumType\OutputFormatType::valueIsValid($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \dpd\EnumType\OutputFormatType', is_array($format) ? implode(', ', $format) : var_export($format, true), implode(', ', \dpd\EnumType\OutputFormatType::getValidValues())), __LINE__);
        }
        $this->format = $format;
        return $this;
    }
    /**
     * Get content value
     * @return string
     */
    public function getContent()
    {
        return $this->content;
    }
    /**
     * Set content value
     * @param string $content
     * @return \dpd\StructType\OutputType
     */
    public function setContent($content = null)
    {
        // validation for constraint: string
        if (!is_null($content) && !is_string($content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($content, true), gettype($content)), __LINE__);
        }
        $this->content = $content;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dpd\StructType\OutputType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
