<?php

namespace dpd\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for higherInsurance StructType
 * Meta information extracted from the WSDL
 * - documentation: Bundles data for higher insurance.
 * @subpackage Structs
 */
class HigherInsurance extends AbstractStructBase
{
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - documentation: COD amount in the currency of the destination country. The amount is specified as integer value e.g. 300.00 becomes 30000.Please note the national ceilings for cod in the corresponding relations. | Increased insurance value with 2
     * decimal point positions without separators.
     * - base: xs:long
     * - maxInclusive: 9999999999
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $amount;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - documentation: ISO 4217 alpha-3 currency code (destination country). | Currency code for increased insurance in format ISO 4217 alpha 3.
     * - base: xs:string
     * - length: 3
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $currency;
    /**
     * Constructor method for higherInsurance
     * @uses HigherInsurance::setAmount()
     * @uses HigherInsurance::setCurrency()
     * @param int $amount
     * @param string $currency
     */
    public function __construct($amount = null, $currency = null)
    {
        $this
            ->setAmount($amount)
            ->setCurrency($currency);
    }
    /**
     * Get amount value
     * @return int
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param int $amount
     * @return \dpd\StructType\HigherInsurance
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !(is_int($amount) || ctype_digit($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        // validation for constraint: maxInclusive(9999999999)
        if (!is_null($amount) && $amount > 9999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999999999', var_export($amount, true)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get currency value
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \dpd\StructType\HigherInsurance
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        // validation for constraint: length(3)
        if (!is_null($currency) && mb_strlen($currency) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 3', mb_strlen($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dpd\StructType\HigherInsurance
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
