<?php

namespace dpd\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for delivery StructType
 * Meta information extracted from the WSDL
 * - documentation: Bundles delivery data.
 * @subpackage Structs
 */
class Delivery extends AbstractStructBase
{
    /**
     * The day
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 20
     * - minOccurs: 0
     * @var string
     */
    public $day;
    /**
     * The dateFrom
     * Meta information extracted from the WSDL
     * - documentation: Fixed delivery from date - format YYYYMMDD, e.g. 20080213.
     * - base: xs:int
     * - maxInclusive: 99999999
     * - minOccurs: 0
     * @var int
     */
    public $dateFrom;
    /**
     * The dateTo
     * Meta information extracted from the WSDL
     * - documentation: Fixed delivery to date - format YYYYMMDD, e.g. 20080213.
     * - base: xs:int
     * - maxInclusive: 99999999
     * - minOccurs: 0
     * @var int
     */
    public $dateTo;
    /**
     * The timeFrom
     * Meta information extracted from the WSDL
     * - documentation: Time from which the consignee is available - format hhmm (local time receipient country), e.g. 1400 or 0830.
     * - base: xs:int
     * - maxInclusive: 2400
     * - minOccurs: 0
     * @var int
     */
    public $timeFrom;
    /**
     * The timeTo
     * Meta information extracted from the WSDL
     * - documentation: Time until the consignee is available - format hhmm (local time receipient country), e.g. 1600 or 0930.
     * - base: xs:int
     * - maxInclusive: 2400
     * - minOccurs: 0
     * @var int
     */
    public $timeTo;
    /**
     * Constructor method for delivery
     * @uses Delivery::setDay()
     * @uses Delivery::setDateFrom()
     * @uses Delivery::setDateTo()
     * @uses Delivery::setTimeFrom()
     * @uses Delivery::setTimeTo()
     * @param string $day
     * @param int $dateFrom
     * @param int $dateTo
     * @param int $timeFrom
     * @param int $timeTo
     */
    public function __construct($day = null, $dateFrom = null, $dateTo = null, $timeFrom = null, $timeTo = null)
    {
        $this
            ->setDay($day)
            ->setDateFrom($dateFrom)
            ->setDateTo($dateTo)
            ->setTimeFrom($timeFrom)
            ->setTimeTo($timeTo);
    }
    /**
     * Get day value
     * @return string|null
     */
    public function getDay()
    {
        return $this->day;
    }
    /**
     * Set day value
     * @param string $day
     * @return \dpd\StructType\Delivery
     */
    public function setDay($day = null)
    {
        // validation for constraint: string
        if (!is_null($day) && !is_string($day)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($day, true), gettype($day)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($day) && mb_strlen($day) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($day)), __LINE__);
        }
        $this->day = $day;
        return $this;
    }
    /**
     * Get dateFrom value
     * @return int|null
     */
    public function getDateFrom()
    {
        return $this->dateFrom;
    }
    /**
     * Set dateFrom value
     * @param int $dateFrom
     * @return \dpd\StructType\Delivery
     */
    public function setDateFrom($dateFrom = null)
    {
        // validation for constraint: int
        if (!is_null($dateFrom) && !(is_int($dateFrom) || ctype_digit($dateFrom))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dateFrom, true), gettype($dateFrom)), __LINE__);
        }
        // validation for constraint: maxInclusive(99999999)
        if (!is_null($dateFrom) && $dateFrom > 99999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99999999', var_export($dateFrom, true)), __LINE__);
        }
        $this->dateFrom = $dateFrom;
        return $this;
    }
    /**
     * Get dateTo value
     * @return int|null
     */
    public function getDateTo()
    {
        return $this->dateTo;
    }
    /**
     * Set dateTo value
     * @param int $dateTo
     * @return \dpd\StructType\Delivery
     */
    public function setDateTo($dateTo = null)
    {
        // validation for constraint: int
        if (!is_null($dateTo) && !(is_int($dateTo) || ctype_digit($dateTo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dateTo, true), gettype($dateTo)), __LINE__);
        }
        // validation for constraint: maxInclusive(99999999)
        if (!is_null($dateTo) && $dateTo > 99999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99999999', var_export($dateTo, true)), __LINE__);
        }
        $this->dateTo = $dateTo;
        return $this;
    }
    /**
     * Get timeFrom value
     * @return int|null
     */
    public function getTimeFrom()
    {
        return $this->timeFrom;
    }
    /**
     * Set timeFrom value
     * @param int $timeFrom
     * @return \dpd\StructType\Delivery
     */
    public function setTimeFrom($timeFrom = null)
    {
        // validation for constraint: int
        if (!is_null($timeFrom) && !(is_int($timeFrom) || ctype_digit($timeFrom))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($timeFrom, true), gettype($timeFrom)), __LINE__);
        }
        // validation for constraint: maxInclusive(2400)
        if (!is_null($timeFrom) && $timeFrom > 2400) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2400', var_export($timeFrom, true)), __LINE__);
        }
        $this->timeFrom = $timeFrom;
        return $this;
    }
    /**
     * Get timeTo value
     * @return int|null
     */
    public function getTimeTo()
    {
        return $this->timeTo;
    }
    /**
     * Set timeTo value
     * @param int $timeTo
     * @return \dpd\StructType\Delivery
     */
    public function setTimeTo($timeTo = null)
    {
        // validation for constraint: int
        if (!is_null($timeTo) && !(is_int($timeTo) || ctype_digit($timeTo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($timeTo, true), gettype($timeTo)), __LINE__);
        }
        // validation for constraint: maxInclusive(2400)
        if (!is_null($timeTo) && $timeTo > 2400) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 2400', var_export($timeTo, true)), __LINE__);
        }
        $this->timeTo = $timeTo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dpd\StructType\Delivery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
