<?php

namespace dpd;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'storeOrders' => '\\dpd\\StructType\\StoreOrders',
            'storeOrdersResponse' => '\\dpd\\StructType\\StoreOrdersResponse',
            'storeOrdersResponseType' => '\\dpd\\StructType\\StoreOrdersResponseType',
            'shipmentResponse' => '\\dpd\\StructType\\ShipmentResponse',
            'shipmentServiceData' => '\\dpd\\StructType\\ShipmentServiceData',
            'generalShipmentData' => '\\dpd\\StructType\\GeneralShipmentData',
            'address' => '\\dpd\\StructType\\Address',
            'parcel' => '\\dpd\\StructType\\Parcel',
            'productAndServiceData' => '\\dpd\\StructType\\ProductAndServiceData',
            'international' => '\\dpd\\StructType\\International',
            'delivery' => '\\dpd\\StructType\\Delivery',
            'proactiveNotification' => '\\dpd\\StructType\\ProactiveNotification',
            'notification' => '\\dpd\\StructType\\Notification',
            'cod' => '\\dpd\\StructType\\Cod',
            'hazardous' => '\\dpd\\StructType\\Hazardous',
            'personalDelivery' => '\\dpd\\StructType\\PersonalDelivery',
            'pickup' => '\\dpd\\StructType\\Pickup',
            'parcelInformationType' => '\\dpd\\StructType\\ParcelInformationType',
            'faultCodeType' => '\\dpd\\StructType\\FaultCodeType',
            'higherInsurance' => '\\dpd\\StructType\\HigherInsurance',
            'parcelShopDelivery' => '\\dpd\\StructType\\ParcelShopDelivery',
            'printOptions' => '\\dpd\\StructType\\PrintOptions',
            'printOption' => '\\dpd\\StructType\\PrintOption',
            'printer' => '\\dpd\\StructType\\Printer',
            'additionalInvoiceLine' => '\\dpd\\StructType\\AdditionalInvoiceLine',
            'OutputType' => '\\dpd\\StructType\\OutputType',
            'authentication' => '\\dpd\\StructType\\Authentication',
            'authenticationFault' => '\\dpd\\StructType\\AuthenticationFault',
        );
    }
}
