<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Info StructType
 * @subpackage Structs
 */
class Info extends AbstractStructBase
{
    /**
     * The Weight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Weight;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The Sku
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Sku;
    /**
     * The Barcode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Barcode;
    /**
     * The Presence
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfQuantityInfo
     */
    public $Presence;
    /**
     * The Properties
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPropInfo
     */
    public $Properties;
    /**
     * The BasePrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PriceInfo
     */
    public $BasePrice;
    /**
     * The PromoPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PriceInfo
     */
    public $PromoPrice;
    /**
     * Constructor method for Info
     * @uses Info::setWeight()
     * @uses Info::setID()
     * @uses Info::setSku()
     * @uses Info::setBarcode()
     * @uses Info::setPresence()
     * @uses Info::setProperties()
     * @uses Info::setBasePrice()
     * @uses Info::setPromoPrice()
     * @param float $weight
     * @param string $iD
     * @param string $sku
     * @param string $barcode
     * @param \ArrayType\ArrayOfQuantityInfo $presence
     * @param \ArrayType\ArrayOfPropInfo $properties
     * @param \StructType\PriceInfo $basePrice
     * @param \StructType\PriceInfo $promoPrice
     */
    public function __construct($weight = null, $iD = null, $sku = null, $barcode = null, \ArrayType\ArrayOfQuantityInfo $presence = null, \ArrayType\ArrayOfPropInfo $properties = null, \StructType\PriceInfo $basePrice = null, \StructType\PriceInfo $promoPrice = null)
    {
        $this
            ->setWeight($weight)
            ->setID($iD)
            ->setSku($sku)
            ->setBarcode($barcode)
            ->setPresence($presence)
            ->setProperties($properties)
            ->setBasePrice($basePrice)
            ->setPromoPrice($promoPrice);
    }
    /**
     * Get Weight value
     * @return float
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param float $weight
     * @return \StructType\Info
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: float
        if (!is_null($weight) && !(is_float($weight) || is_numeric($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\Info
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Sku value
     * @return string|null
     */
    public function getSku()
    {
        return $this->Sku;
    }
    /**
     * Set Sku value
     * @param string $sku
     * @return \StructType\Info
     */
    public function setSku($sku = null)
    {
        // validation for constraint: string
        if (!is_null($sku) && !is_string($sku)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sku, true), gettype($sku)), __LINE__);
        }
        $this->Sku = $sku;
        return $this;
    }
    /**
     * Get Barcode value
     * @return string|null
     */
    public function getBarcode()
    {
        return $this->Barcode;
    }
    /**
     * Set Barcode value
     * @param string $barcode
     * @return \StructType\Info
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        $this->Barcode = $barcode;
        return $this;
    }
    /**
     * Get Presence value
     * @return \ArrayType\ArrayOfQuantityInfo|null
     */
    public function getPresence()
    {
        return $this->Presence;
    }
    /**
     * Set Presence value
     * @param \ArrayType\ArrayOfQuantityInfo $presence
     * @return \StructType\Info
     */
    public function setPresence(\ArrayType\ArrayOfQuantityInfo $presence = null)
    {
        $this->Presence = $presence;
        return $this;
    }
    /**
     * Get Properties value
     * @return \ArrayType\ArrayOfPropInfo|null
     */
    public function getProperties()
    {
        return $this->Properties;
    }
    /**
     * Set Properties value
     * @param \ArrayType\ArrayOfPropInfo $properties
     * @return \StructType\Info
     */
    public function setProperties(\ArrayType\ArrayOfPropInfo $properties = null)
    {
        $this->Properties = $properties;
        return $this;
    }
    /**
     * Get BasePrice value
     * @return \StructType\PriceInfo|null
     */
    public function getBasePrice()
    {
        return $this->BasePrice;
    }
    /**
     * Set BasePrice value
     * @param \StructType\PriceInfo $basePrice
     * @return \StructType\Info
     */
    public function setBasePrice(\StructType\PriceInfo $basePrice = null)
    {
        $this->BasePrice = $basePrice;
        return $this;
    }
    /**
     * Get PromoPrice value
     * @return \StructType\PriceInfo|null
     */
    public function getPromoPrice()
    {
        return $this->PromoPrice;
    }
    /**
     * Set PromoPrice value
     * @param \StructType\PriceInfo $promoPrice
     * @return \StructType\Info
     */
    public function setPromoPrice(\StructType\PriceInfo $promoPrice = null)
    {
        $this->PromoPrice = $promoPrice;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Info
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
