<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CategoryInfo StructType
 * @subpackage Structs
 */
class CategoryInfo extends AbstractStructBase
{
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Position;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The NameEN
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NameEN;
    /**
     * The ParentID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ParentID;
    /**
     * The PictureUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PictureUrl;
    /**
     * The ThumbnailUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ThumbnailUrl;
    /**
     * Constructor method for CategoryInfo
     * @uses CategoryInfo::setPosition()
     * @uses CategoryInfo::setID()
     * @uses CategoryInfo::setName()
     * @uses CategoryInfo::setNameEN()
     * @uses CategoryInfo::setParentID()
     * @uses CategoryInfo::setPictureUrl()
     * @uses CategoryInfo::setThumbnailUrl()
     * @param int $position
     * @param string $iD
     * @param string $name
     * @param string $nameEN
     * @param string $parentID
     * @param string $pictureUrl
     * @param string $thumbnailUrl
     */
    public function __construct($position = null, $iD = null, $name = null, $nameEN = null, $parentID = null, $pictureUrl = null, $thumbnailUrl = null)
    {
        $this
            ->setPosition($position)
            ->setID($iD)
            ->setName($name)
            ->setNameEN($nameEN)
            ->setParentID($parentID)
            ->setPictureUrl($pictureUrl)
            ->setThumbnailUrl($thumbnailUrl);
    }
    /**
     * Get Position value
     * @return int
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param int $position
     * @return \StructType\CategoryInfo
     */
    public function setPosition($position = null)
    {
        // validation for constraint: int
        if (!is_null($position) && !(is_int($position) || ctype_digit($position))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($position, true), gettype($position)), __LINE__);
        }
        $this->Position = $position;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\CategoryInfo
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\CategoryInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get NameEN value
     * @return string|null
     */
    public function getNameEN()
    {
        return $this->NameEN;
    }
    /**
     * Set NameEN value
     * @param string $nameEN
     * @return \StructType\CategoryInfo
     */
    public function setNameEN($nameEN = null)
    {
        // validation for constraint: string
        if (!is_null($nameEN) && !is_string($nameEN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameEN, true), gettype($nameEN)), __LINE__);
        }
        $this->NameEN = $nameEN;
        return $this;
    }
    /**
     * Get ParentID value
     * @return string|null
     */
    public function getParentID()
    {
        return $this->ParentID;
    }
    /**
     * Set ParentID value
     * @param string $parentID
     * @return \StructType\CategoryInfo
     */
    public function setParentID($parentID = null)
    {
        // validation for constraint: string
        if (!is_null($parentID) && !is_string($parentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentID, true), gettype($parentID)), __LINE__);
        }
        $this->ParentID = $parentID;
        return $this;
    }
    /**
     * Get PictureUrl value
     * @return string|null
     */
    public function getPictureUrl()
    {
        return $this->PictureUrl;
    }
    /**
     * Set PictureUrl value
     * @param string $pictureUrl
     * @return \StructType\CategoryInfo
     */
    public function setPictureUrl($pictureUrl = null)
    {
        // validation for constraint: string
        if (!is_null($pictureUrl) && !is_string($pictureUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pictureUrl, true), gettype($pictureUrl)), __LINE__);
        }
        $this->PictureUrl = $pictureUrl;
        return $this;
    }
    /**
     * Get ThumbnailUrl value
     * @return string|null
     */
    public function getThumbnailUrl()
    {
        return $this->ThumbnailUrl;
    }
    /**
     * Set ThumbnailUrl value
     * @param string $thumbnailUrl
     * @return \StructType\CategoryInfo
     */
    public function setThumbnailUrl($thumbnailUrl = null)
    {
        // validation for constraint: string
        if (!is_null($thumbnailUrl) && !is_string($thumbnailUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thumbnailUrl, true), gettype($thumbnailUrl)), __LINE__);
        }
        $this->ThumbnailUrl = $thumbnailUrl;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CategoryInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
