<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfQuantityInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfQuantityInfo extends AbstractStructArrayBase
{
    /**
     * The QuantityInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\QuantityInfo[]
     */
    public $QuantityInfo;
    /**
     * Constructor method for ArrayOfQuantityInfo
     * @uses ArrayOfQuantityInfo::setQuantityInfo()
     * @param \StructType\QuantityInfo[] $quantityInfo
     */
    public function __construct(array $quantityInfo = array())
    {
        $this
            ->setQuantityInfo($quantityInfo);
    }
    /**
     * Get QuantityInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\QuantityInfo[]|null
     */
    public function getQuantityInfo()
    {
        return isset($this->QuantityInfo) ? $this->QuantityInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setQuantityInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setQuantityInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateQuantityInfoForArrayConstraintsFromSetQuantityInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfQuantityInfoQuantityInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfQuantityInfoQuantityInfoItem instanceof \StructType\QuantityInfo) {
                $invalidValues[] = is_object($arrayOfQuantityInfoQuantityInfoItem) ? get_class($arrayOfQuantityInfoQuantityInfoItem) : sprintf('%s(%s)', gettype($arrayOfQuantityInfoQuantityInfoItem), var_export($arrayOfQuantityInfoQuantityInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The QuantityInfo property can only contain items of type \StructType\QuantityInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set QuantityInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\QuantityInfo[] $quantityInfo
     * @return \ArrayType\ArrayOfQuantityInfo
     */
    public function setQuantityInfo(array $quantityInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($quantityInfoArrayErrorMessage = self::validateQuantityInfoForArrayConstraintsFromSetQuantityInfo($quantityInfo))) {
            throw new \InvalidArgumentException($quantityInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($quantityInfo) || (is_array($quantityInfo) && empty($quantityInfo))) {
            unset($this->QuantityInfo);
        } else {
            $this->QuantityInfo = $quantityInfo;
        }
        return $this;
    }
    /**
     * Add item to QuantityInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\QuantityInfo $item
     * @return \ArrayType\ArrayOfQuantityInfo
     */
    public function addToQuantityInfo(\StructType\QuantityInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\QuantityInfo) {
            throw new \InvalidArgumentException(sprintf('The QuantityInfo property can only contain items of type \StructType\QuantityInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->QuantityInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\QuantityInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\QuantityInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\QuantityInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\QuantityInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\QuantityInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string QuantityInfo
     */
    public function getAttributeName()
    {
        return 'QuantityInfo';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfQuantityInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
