<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://195.34.100.202:1945/MW/Services/CloudCartService.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://195.34.100.202:1945/MW/Services/CloudCartService.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
$get->setSoapHeaderAuthenticationHeader(new \StructType\AuthenticationHeader());
/**
 * Sample call for GetCategories operation/method
 */
if ($get->GetCategories(new \StructType\GetCategories()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetArticlesByID operation/method
 */
if ($get->GetArticlesByID(new \StructType\GetArticlesByID()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetArticlesByDate operation/method
 */
if ($get->GetArticlesByDate(new \StructType\GetArticlesByDate()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
$create->setSoapHeaderAuthenticationHeader(new \StructType\AuthenticationHeader());
/**
 * Sample call for CreateContragent operation/method
 */
if ($create->CreateContragent(new \StructType\CreateContragent()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateOrder operation/method
 */
if ($create->CreateOrder(new \StructType\CreateOrder()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateReturn operation/method
 */
if ($create->CreateReturn(new \StructType\CreateReturn()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Edit ServiceType
 */
$edit = new \ServiceType\Edit($options);
$edit->setSoapHeaderAuthenticationHeader(new \StructType\AuthenticationHeader());
/**
 * Sample call for EditOrder operation/method
 */
if ($edit->EditOrder(new \StructType\EditOrder()) !== false) {
    print_r($edit->getResult());
} else {
    print_r($edit->getLastError());
}
