<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PropInfo StructType
 * @subpackage Structs
 */
class PropInfo extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ID;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Value;
    /**
     * The NameEN
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NameEN;
    /**
     * The ValueEN
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ValueEN;
    /**
     * Constructor method for PropInfo
     * @uses PropInfo::setID()
     * @uses PropInfo::setName()
     * @uses PropInfo::setValue()
     * @uses PropInfo::setNameEN()
     * @uses PropInfo::setValueEN()
     * @param int $iD
     * @param string $name
     * @param string $value
     * @param string $nameEN
     * @param string $valueEN
     */
    public function __construct($iD = null, $name = null, $value = null, $nameEN = null, $valueEN = null)
    {
        $this
            ->setID($iD)
            ->setName($name)
            ->setValue($value)
            ->setNameEN($nameEN)
            ->setValueEN($valueEN);
    }
    /**
     * Get ID value
     * @return int
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\PropInfo
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\PropInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \StructType\PropInfo
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get NameEN value
     * @return string|null
     */
    public function getNameEN()
    {
        return $this->NameEN;
    }
    /**
     * Set NameEN value
     * @param string $nameEN
     * @return \StructType\PropInfo
     */
    public function setNameEN($nameEN = null)
    {
        // validation for constraint: string
        if (!is_null($nameEN) && !is_string($nameEN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameEN, true), gettype($nameEN)), __LINE__);
        }
        $this->NameEN = $nameEN;
        return $this;
    }
    /**
     * Get ValueEN value
     * @return string|null
     */
    public function getValueEN()
    {
        return $this->ValueEN;
    }
    /**
     * Set ValueEN value
     * @param string $valueEN
     * @return \StructType\PropInfo
     */
    public function setValueEN($valueEN = null)
    {
        // validation for constraint: string
        if (!is_null($valueEN) && !is_string($valueEN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valueEN, true), gettype($valueEN)), __LINE__);
        }
        $this->ValueEN = $valueEN;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PropInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
