<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBatchInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfBatchInfo extends AbstractStructArrayBase
{
    /**
     * The BatchInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BatchInfo[]
     */
    public $BatchInfo;
    /**
     * Constructor method for ArrayOfBatchInfo
     * @uses ArrayOfBatchInfo::setBatchInfo()
     * @param \StructType\BatchInfo[] $batchInfo
     */
    public function __construct(array $batchInfo = array())
    {
        $this
            ->setBatchInfo($batchInfo);
    }
    /**
     * Get BatchInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BatchInfo[]|null
     */
    public function getBatchInfo()
    {
        return isset($this->BatchInfo) ? $this->BatchInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBatchInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBatchInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBatchInfoForArrayConstraintsFromSetBatchInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfBatchInfoBatchInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfBatchInfoBatchInfoItem instanceof \StructType\BatchInfo) {
                $invalidValues[] = is_object($arrayOfBatchInfoBatchInfoItem) ? get_class($arrayOfBatchInfoBatchInfoItem) : sprintf('%s(%s)', gettype($arrayOfBatchInfoBatchInfoItem), var_export($arrayOfBatchInfoBatchInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BatchInfo property can only contain items of type \StructType\BatchInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BatchInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BatchInfo[] $batchInfo
     * @return \ArrayType\ArrayOfBatchInfo
     */
    public function setBatchInfo(array $batchInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($batchInfoArrayErrorMessage = self::validateBatchInfoForArrayConstraintsFromSetBatchInfo($batchInfo))) {
            throw new \InvalidArgumentException($batchInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($batchInfo) || (is_array($batchInfo) && empty($batchInfo))) {
            unset($this->BatchInfo);
        } else {
            $this->BatchInfo = $batchInfo;
        }
        return $this;
    }
    /**
     * Add item to BatchInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\BatchInfo $item
     * @return \ArrayType\ArrayOfBatchInfo
     */
    public function addToBatchInfo(\StructType\BatchInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BatchInfo) {
            throw new \InvalidArgumentException(sprintf('The BatchInfo property can only contain items of type \StructType\BatchInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BatchInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\BatchInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\BatchInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\BatchInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\BatchInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\BatchInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BatchInfo
     */
    public function getAttributeName()
    {
        return 'BatchInfo';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfBatchInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
