<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfArticleInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfArticleInfo extends AbstractStructArrayBase
{
    /**
     * The ArticleInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ArticleInfo[]
     */
    public $ArticleInfo;
    /**
     * Constructor method for ArrayOfArticleInfo
     * @uses ArrayOfArticleInfo::setArticleInfo()
     * @param \StructType\ArticleInfo[] $articleInfo
     */
    public function __construct(array $articleInfo = array())
    {
        $this
            ->setArticleInfo($articleInfo);
    }
    /**
     * Get ArticleInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ArticleInfo[]|null
     */
    public function getArticleInfo()
    {
        return isset($this->ArticleInfo) ? $this->ArticleInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setArticleInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setArticleInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateArticleInfoForArrayConstraintsFromSetArticleInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfArticleInfoArticleInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfArticleInfoArticleInfoItem instanceof \StructType\ArticleInfo) {
                $invalidValues[] = is_object($arrayOfArticleInfoArticleInfoItem) ? get_class($arrayOfArticleInfoArticleInfoItem) : sprintf('%s(%s)', gettype($arrayOfArticleInfoArticleInfoItem), var_export($arrayOfArticleInfoArticleInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ArticleInfo property can only contain items of type \StructType\ArticleInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ArticleInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ArticleInfo[] $articleInfo
     * @return \ArrayType\ArrayOfArticleInfo
     */
    public function setArticleInfo(array $articleInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($articleInfoArrayErrorMessage = self::validateArticleInfoForArrayConstraintsFromSetArticleInfo($articleInfo))) {
            throw new \InvalidArgumentException($articleInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($articleInfo) || (is_array($articleInfo) && empty($articleInfo))) {
            unset($this->ArticleInfo);
        } else {
            $this->ArticleInfo = $articleInfo;
        }
        return $this;
    }
    /**
     * Add item to ArticleInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ArticleInfo $item
     * @return \ArrayType\ArrayOfArticleInfo
     */
    public function addToArticleInfo(\StructType\ArticleInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ArticleInfo) {
            throw new \InvalidArgumentException(sprintf('The ArticleInfo property can only contain items of type \StructType\ArticleInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ArticleInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ArticleInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ArticleInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ArticleInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ArticleInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ArticleInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ArticleInfo
     */
    public function getAttributeName()
    {
        return 'ArticleInfo';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfArticleInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
