<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderResponse StructType
 * @subpackage Structs
 */
class OrderResponse extends MethodResponse
{
    /**
     * The OrderID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrderID;
    /**
     * The Errs
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfErrorServiceOrderItem
     */
    public $Errs;
    /**
     * The Unp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Unp;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * Constructor method for OrderResponse
     * @uses OrderResponse::setOrderID()
     * @uses OrderResponse::setErrs()
     * @uses OrderResponse::setUnp()
     * @uses OrderResponse::setMessage()
     * @param int $orderID
     * @param \ArrayType\ArrayOfErrorServiceOrderItem $errs
     * @param string $unp
     * @param string $message
     */
    public function __construct($orderID = null, \ArrayType\ArrayOfErrorServiceOrderItem $errs = null, $unp = null, $message = null)
    {
        $this
            ->setOrderID($orderID)
            ->setErrs($errs)
            ->setUnp($unp)
            ->setMessage($message);
    }
    /**
     * Get OrderID value
     * @return int
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param int $orderID
     * @return \StructType\OrderResponse
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: int
        if (!is_null($orderID) && !(is_int($orderID) || ctype_digit($orderID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderID, true), gettype($orderID)), __LINE__);
        }
        $this->OrderID = $orderID;
        return $this;
    }
    /**
     * Get Errs value
     * @return \ArrayType\ArrayOfErrorServiceOrderItem|null
     */
    public function getErrs()
    {
        return $this->Errs;
    }
    /**
     * Set Errs value
     * @param \ArrayType\ArrayOfErrorServiceOrderItem $errs
     * @return \StructType\OrderResponse
     */
    public function setErrs(\ArrayType\ArrayOfErrorServiceOrderItem $errs = null)
    {
        $this->Errs = $errs;
        return $this;
    }
    /**
     * Get Unp value
     * @return string|null
     */
    public function getUnp()
    {
        return $this->Unp;
    }
    /**
     * Set Unp value
     * @param string $unp
     * @return \StructType\OrderResponse
     */
    public function setUnp($unp = null)
    {
        // validation for constraint: string
        if (!is_null($unp) && !is_string($unp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unp, true), gettype($unp)), __LINE__);
        }
        $this->Unp = $unp;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \StructType\OrderResponse
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
