<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EditOrder StructType
 * @subpackage Structs
 */
class EditOrder extends AbstractStructBase
{
    /**
     * The paymentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $paymentType;
    /**
     * The orderID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $orderID;
    /**
     * The articles
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfOrderItem
     */
    public $articles;
    /**
     * Constructor method for EditOrder
     * @uses EditOrder::setPaymentType()
     * @uses EditOrder::setOrderID()
     * @uses EditOrder::setArticles()
     * @param int $paymentType
     * @param int $orderID
     * @param \ArrayType\ArrayOfOrderItem $articles
     */
    public function __construct($paymentType = null, $orderID = null, \ArrayType\ArrayOfOrderItem $articles = null)
    {
        $this
            ->setPaymentType($paymentType)
            ->setOrderID($orderID)
            ->setArticles($articles);
    }
    /**
     * Get paymentType value
     * @return int
     */
    public function getPaymentType()
    {
        return $this->paymentType;
    }
    /**
     * Set paymentType value
     * @param int $paymentType
     * @return \StructType\EditOrder
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: int
        if (!is_null($paymentType) && !(is_int($paymentType) || ctype_digit($paymentType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paymentType, true), gettype($paymentType)), __LINE__);
        }
        $this->paymentType = $paymentType;
        return $this;
    }
    /**
     * Get orderID value
     * @return int
     */
    public function getOrderID()
    {
        return $this->orderID;
    }
    /**
     * Set orderID value
     * @param int $orderID
     * @return \StructType\EditOrder
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: int
        if (!is_null($orderID) && !(is_int($orderID) || ctype_digit($orderID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderID, true), gettype($orderID)), __LINE__);
        }
        $this->orderID = $orderID;
        return $this;
    }
    /**
     * Get articles value
     * @return \ArrayType\ArrayOfOrderItem|null
     */
    public function getArticles()
    {
        return $this->articles;
    }
    /**
     * Set articles value
     * @param \ArrayType\ArrayOfOrderItem $articles
     * @return \StructType\EditOrder
     */
    public function setArticles(\ArrayType\ArrayOfOrderItem $articles = null)
    {
        $this->articles = $articles;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EditOrder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
