<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateReturn StructType
 * @subpackage Structs
 */
class CreateReturn extends AbstractStructBase
{
    /**
     * The orderID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $orderID;
    /**
     * The isFullReturn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $isFullReturn;
    /**
     * The articles
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfReturnItem
     */
    public $articles;
    /**
     * Constructor method for CreateReturn
     * @uses CreateReturn::setOrderID()
     * @uses CreateReturn::setIsFullReturn()
     * @uses CreateReturn::setArticles()
     * @param int $orderID
     * @param bool $isFullReturn
     * @param \ArrayType\ArrayOfReturnItem $articles
     */
    public function __construct($orderID = null, $isFullReturn = null, \ArrayType\ArrayOfReturnItem $articles = null)
    {
        $this
            ->setOrderID($orderID)
            ->setIsFullReturn($isFullReturn)
            ->setArticles($articles);
    }
    /**
     * Get orderID value
     * @return int
     */
    public function getOrderID()
    {
        return $this->orderID;
    }
    /**
     * Set orderID value
     * @param int $orderID
     * @return \StructType\CreateReturn
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: int
        if (!is_null($orderID) && !(is_int($orderID) || ctype_digit($orderID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderID, true), gettype($orderID)), __LINE__);
        }
        $this->orderID = $orderID;
        return $this;
    }
    /**
     * Get isFullReturn value
     * @return bool
     */
    public function getIsFullReturn()
    {
        return $this->isFullReturn;
    }
    /**
     * Set isFullReturn value
     * @param bool $isFullReturn
     * @return \StructType\CreateReturn
     */
    public function setIsFullReturn($isFullReturn = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFullReturn) && !is_bool($isFullReturn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFullReturn, true), gettype($isFullReturn)), __LINE__);
        }
        $this->isFullReturn = $isFullReturn;
        return $this;
    }
    /**
     * Get articles value
     * @return \ArrayType\ArrayOfReturnItem|null
     */
    public function getArticles()
    {
        return $this->articles;
    }
    /**
     * Set articles value
     * @param \ArrayType\ArrayOfReturnItem $articles
     * @return \StructType\CreateReturn
     */
    public function setArticles(\ArrayType\ArrayOfReturnItem $articles = null)
    {
        $this->articles = $articles;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateReturn
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
