<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateOrder StructType
 * @subpackage Structs
 */
class CreateOrder extends AbstractStructBase
{
    /**
     * The paymentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $paymentType;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The bulstat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $bulstat;
    /**
     * The orderNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $orderNumber;
    /**
     * The orderDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $orderDate;
    /**
     * The webShopUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $webShopUrl;
    /**
     * The deliveryInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DeliveryInfo
     */
    public $deliveryInfo;
    /**
     * The articles
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfOrderItem
     */
    public $articles;
    /**
     * Constructor method for CreateOrder
     * @uses CreateOrder::setPaymentType()
     * @uses CreateOrder::setEmail()
     * @uses CreateOrder::setBulstat()
     * @uses CreateOrder::setOrderNumber()
     * @uses CreateOrder::setOrderDate()
     * @uses CreateOrder::setWebShopUrl()
     * @uses CreateOrder::setDeliveryInfo()
     * @uses CreateOrder::setArticles()
     * @param int $paymentType
     * @param string $email
     * @param string $bulstat
     * @param string $orderNumber
     * @param string $orderDate
     * @param string $webShopUrl
     * @param \StructType\DeliveryInfo $deliveryInfo
     * @param \ArrayType\ArrayOfOrderItem $articles
     */
    public function __construct($paymentType = null, $email = null, $bulstat = null, $orderNumber = null, $orderDate = null, $webShopUrl = null, \StructType\DeliveryInfo $deliveryInfo = null, \ArrayType\ArrayOfOrderItem $articles = null)
    {
        $this
            ->setPaymentType($paymentType)
            ->setEmail($email)
            ->setBulstat($bulstat)
            ->setOrderNumber($orderNumber)
            ->setOrderDate($orderDate)
            ->setWebShopUrl($webShopUrl)
            ->setDeliveryInfo($deliveryInfo)
            ->setArticles($articles);
    }
    /**
     * Get paymentType value
     * @return int
     */
    public function getPaymentType()
    {
        return $this->paymentType;
    }
    /**
     * Set paymentType value
     * @param int $paymentType
     * @return \StructType\CreateOrder
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: int
        if (!is_null($paymentType) && !(is_int($paymentType) || ctype_digit($paymentType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paymentType, true), gettype($paymentType)), __LINE__);
        }
        $this->paymentType = $paymentType;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\CreateOrder
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get bulstat value
     * @return string|null
     */
    public function getBulstat()
    {
        return $this->bulstat;
    }
    /**
     * Set bulstat value
     * @param string $bulstat
     * @return \StructType\CreateOrder
     */
    public function setBulstat($bulstat = null)
    {
        // validation for constraint: string
        if (!is_null($bulstat) && !is_string($bulstat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bulstat, true), gettype($bulstat)), __LINE__);
        }
        $this->bulstat = $bulstat;
        return $this;
    }
    /**
     * Get orderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->orderNumber;
    }
    /**
     * Set orderNumber value
     * @param string $orderNumber
     * @return \StructType\CreateOrder
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderNumber, true), gettype($orderNumber)), __LINE__);
        }
        $this->orderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get orderDate value
     * @return string|null
     */
    public function getOrderDate()
    {
        return $this->orderDate;
    }
    /**
     * Set orderDate value
     * @param string $orderDate
     * @return \StructType\CreateOrder
     */
    public function setOrderDate($orderDate = null)
    {
        // validation for constraint: string
        if (!is_null($orderDate) && !is_string($orderDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderDate, true), gettype($orderDate)), __LINE__);
        }
        $this->orderDate = $orderDate;
        return $this;
    }
    /**
     * Get webShopUrl value
     * @return string|null
     */
    public function getWebShopUrl()
    {
        return $this->webShopUrl;
    }
    /**
     * Set webShopUrl value
     * @param string $webShopUrl
     * @return \StructType\CreateOrder
     */
    public function setWebShopUrl($webShopUrl = null)
    {
        // validation for constraint: string
        if (!is_null($webShopUrl) && !is_string($webShopUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webShopUrl, true), gettype($webShopUrl)), __LINE__);
        }
        $this->webShopUrl = $webShopUrl;
        return $this;
    }
    /**
     * Get deliveryInfo value
     * @return \StructType\DeliveryInfo|null
     */
    public function getDeliveryInfo()
    {
        return $this->deliveryInfo;
    }
    /**
     * Set deliveryInfo value
     * @param \StructType\DeliveryInfo $deliveryInfo
     * @return \StructType\CreateOrder
     */
    public function setDeliveryInfo(\StructType\DeliveryInfo $deliveryInfo = null)
    {
        $this->deliveryInfo = $deliveryInfo;
        return $this;
    }
    /**
     * Get articles value
     * @return \ArrayType\ArrayOfOrderItem|null
     */
    public function getArticles()
    {
        return $this->articles;
    }
    /**
     * Set articles value
     * @param \ArrayType\ArrayOfOrderItem $articles
     * @return \StructType\CreateOrder
     */
    public function setArticles(\ArrayType\ArrayOfOrderItem $articles = null)
    {
        $this->articles = $articles;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateOrder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
