<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPropInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfPropInfo extends AbstractStructArrayBase
{
    /**
     * The PropInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PropInfo[]
     */
    public $PropInfo;
    /**
     * Constructor method for ArrayOfPropInfo
     * @uses ArrayOfPropInfo::setPropInfo()
     * @param \StructType\PropInfo[] $propInfo
     */
    public function __construct(array $propInfo = array())
    {
        $this
            ->setPropInfo($propInfo);
    }
    /**
     * Get PropInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PropInfo[]|null
     */
    public function getPropInfo()
    {
        return isset($this->PropInfo) ? $this->PropInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPropInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPropInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePropInfoForArrayConstraintsFromSetPropInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPropInfoPropInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfPropInfoPropInfoItem instanceof \StructType\PropInfo) {
                $invalidValues[] = is_object($arrayOfPropInfoPropInfoItem) ? get_class($arrayOfPropInfoPropInfoItem) : sprintf('%s(%s)', gettype($arrayOfPropInfoPropInfoItem), var_export($arrayOfPropInfoPropInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PropInfo property can only contain items of type \StructType\PropInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PropInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PropInfo[] $propInfo
     * @return \ArrayType\ArrayOfPropInfo
     */
    public function setPropInfo(array $propInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($propInfoArrayErrorMessage = self::validatePropInfoForArrayConstraintsFromSetPropInfo($propInfo))) {
            throw new \InvalidArgumentException($propInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($propInfo) || (is_array($propInfo) && empty($propInfo))) {
            unset($this->PropInfo);
        } else {
            $this->PropInfo = $propInfo;
        }
        return $this;
    }
    /**
     * Add item to PropInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\PropInfo $item
     * @return \ArrayType\ArrayOfPropInfo
     */
    public function addToPropInfo(\StructType\PropInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PropInfo) {
            throw new \InvalidArgumentException(sprintf('The PropInfo property can only contain items of type \StructType\PropInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PropInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PropInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PropInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PropInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PropInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PropInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PropInfo
     */
    public function getAttributeName()
    {
        return 'PropInfo';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfPropInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
