<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCategoryInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfCategoryInfo extends AbstractStructArrayBase
{
    /**
     * The CategoryInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CategoryInfo[]
     */
    public $CategoryInfo;
    /**
     * Constructor method for ArrayOfCategoryInfo
     * @uses ArrayOfCategoryInfo::setCategoryInfo()
     * @param \StructType\CategoryInfo[] $categoryInfo
     */
    public function __construct(array $categoryInfo = array())
    {
        $this
            ->setCategoryInfo($categoryInfo);
    }
    /**
     * Get CategoryInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CategoryInfo[]|null
     */
    public function getCategoryInfo()
    {
        return isset($this->CategoryInfo) ? $this->CategoryInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCategoryInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCategoryInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCategoryInfoForArrayConstraintsFromSetCategoryInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCategoryInfoCategoryInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfCategoryInfoCategoryInfoItem instanceof \StructType\CategoryInfo) {
                $invalidValues[] = is_object($arrayOfCategoryInfoCategoryInfoItem) ? get_class($arrayOfCategoryInfoCategoryInfoItem) : sprintf('%s(%s)', gettype($arrayOfCategoryInfoCategoryInfoItem), var_export($arrayOfCategoryInfoCategoryInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CategoryInfo property can only contain items of type \StructType\CategoryInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CategoryInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CategoryInfo[] $categoryInfo
     * @return \ArrayType\ArrayOfCategoryInfo
     */
    public function setCategoryInfo(array $categoryInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($categoryInfoArrayErrorMessage = self::validateCategoryInfoForArrayConstraintsFromSetCategoryInfo($categoryInfo))) {
            throw new \InvalidArgumentException($categoryInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($categoryInfo) || (is_array($categoryInfo) && empty($categoryInfo))) {
            unset($this->CategoryInfo);
        } else {
            $this->CategoryInfo = $categoryInfo;
        }
        return $this;
    }
    /**
     * Add item to CategoryInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\CategoryInfo $item
     * @return \ArrayType\ArrayOfCategoryInfo
     */
    public function addToCategoryInfo(\StructType\CategoryInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CategoryInfo) {
            throw new \InvalidArgumentException(sprintf('The CategoryInfo property can only contain items of type \StructType\CategoryInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CategoryInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CategoryInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CategoryInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CategoryInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CategoryInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CategoryInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CategoryInfo
     */
    public function getAttributeName()
    {
        return 'CategoryInfo';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCategoryInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
