<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WeatherInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides detailed information regarding weather.
 * @subpackage Structs
 */
class WeatherInfoType extends AbstractStructBase
{
    /**
     * The Precipitation
     * Meta information extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \StructType\Precipitation[]
     */
    public $Precipitation;
    /**
     * The Temperature
     * Meta information extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \StructType\Temperature[]
     */
    public $Temperature;
    /**
     * The Period
     * Meta information extracted from the WSDL
     * - documentation: This may be used to define a time period for which a certain type of weather occurs (e.g. January or Spring).
     * - use: optional
     * @var string
     */
    public $Period;
    /**
     * Constructor method for WeatherInfoType
     * @uses WeatherInfoType::setPrecipitation()
     * @uses WeatherInfoType::setTemperature()
     * @uses WeatherInfoType::setPeriod()
     * @param \StructType\Precipitation[] $precipitation
     * @param \StructType\Temperature[] $temperature
     * @param string $period
     */
    public function __construct(array $precipitation = array(), array $temperature = array(), $period = null)
    {
        $this
            ->setPrecipitation($precipitation)
            ->setTemperature($temperature)
            ->setPeriod($period);
    }
    /**
     * Get Precipitation value
     * @return \StructType\Precipitation[]|null
     */
    public function getPrecipitation()
    {
        return $this->Precipitation;
    }
    /**
     * This method is responsible for validating the values passed to the setPrecipitation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrecipitation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePrecipitationForArrayConstraintsFromSetPrecipitation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $weatherInfoTypePrecipitationItem) {
            // validation for constraint: itemType
            if (!$weatherInfoTypePrecipitationItem instanceof \StructType\Precipitation) {
                $invalidValues[] = is_object($weatherInfoTypePrecipitationItem) ? get_class($weatherInfoTypePrecipitationItem) : sprintf('%s(%s)', gettype($weatherInfoTypePrecipitationItem), var_export($weatherInfoTypePrecipitationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Precipitation property can only contain items of type \StructType\Precipitation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Precipitation value
     * @throws \InvalidArgumentException
     * @param \StructType\Precipitation[] $precipitation
     * @return \StructType\WeatherInfoType
     */
    public function setPrecipitation(array $precipitation = array())
    {
        // validation for constraint: array
        if ('' !== ($precipitationArrayErrorMessage = self::validatePrecipitationForArrayConstraintsFromSetPrecipitation($precipitation))) {
            throw new \InvalidArgumentException($precipitationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($precipitation) && count($precipitation) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($precipitation)), __LINE__);
        }
        $this->Precipitation = $precipitation;
        return $this;
    }
    /**
     * Add item to Precipitation value
     * @throws \InvalidArgumentException
     * @param \StructType\Precipitation $item
     * @return \StructType\WeatherInfoType
     */
    public function addToPrecipitation(\StructType\Precipitation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Precipitation) {
            throw new \InvalidArgumentException(sprintf('The Precipitation property can only contain items of type \StructType\Precipitation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->Precipitation) && count($this->Precipitation) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->Precipitation)), __LINE__);
        }
        $this->Precipitation[] = $item;
        return $this;
    }
    /**
     * Get Temperature value
     * @return \StructType\Temperature[]|null
     */
    public function getTemperature()
    {
        return $this->Temperature;
    }
    /**
     * This method is responsible for validating the values passed to the setTemperature method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTemperature method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTemperatureForArrayConstraintsFromSetTemperature(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $weatherInfoTypeTemperatureItem) {
            // validation for constraint: itemType
            if (!$weatherInfoTypeTemperatureItem instanceof \StructType\Temperature) {
                $invalidValues[] = is_object($weatherInfoTypeTemperatureItem) ? get_class($weatherInfoTypeTemperatureItem) : sprintf('%s(%s)', gettype($weatherInfoTypeTemperatureItem), var_export($weatherInfoTypeTemperatureItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Temperature property can only contain items of type \StructType\Temperature, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Temperature value
     * @throws \InvalidArgumentException
     * @param \StructType\Temperature[] $temperature
     * @return \StructType\WeatherInfoType
     */
    public function setTemperature(array $temperature = array())
    {
        // validation for constraint: array
        if ('' !== ($temperatureArrayErrorMessage = self::validateTemperatureForArrayConstraintsFromSetTemperature($temperature))) {
            throw new \InvalidArgumentException($temperatureArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($temperature) && count($temperature) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($temperature)), __LINE__);
        }
        $this->Temperature = $temperature;
        return $this;
    }
    /**
     * Add item to Temperature value
     * @throws \InvalidArgumentException
     * @param \StructType\Temperature $item
     * @return \StructType\WeatherInfoType
     */
    public function addToTemperature(\StructType\Temperature $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Temperature) {
            throw new \InvalidArgumentException(sprintf('The Temperature property can only contain items of type \StructType\Temperature, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->Temperature) && count($this->Temperature) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->Temperature)), __LINE__);
        }
        $this->Temperature[] = $item;
        return $this;
    }
    /**
     * Get Period value
     * @return string|null
     */
    public function getPeriod()
    {
        return $this->Period;
    }
    /**
     * Set Period value
     * @param string $period
     * @return \StructType\WeatherInfoType
     */
    public function setPeriod($period = null)
    {
        // validation for constraint: string
        if (!is_null($period) && !is_string($period)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($period, true), gettype($period)), __LINE__);
        }
        $this->Period = $period;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WeatherInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
