<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VideoItem StructType
 * Meta information extracted from the WSDL
 * - documentation: Creation and modification information for this video item. | If true, this item is obsolete and should be removed from the receiving system. | Each video item represents a specific category.
 * @subpackage Structs
 */
class VideoItem extends VideoDescriptionType
{
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - documentation: The language associated with the caption for the video.
     * - use: optional
     * @var string
     */
    public $Language;
    /**
     * The Caption
     * Meta information extracted from the WSDL
     * - documentation: The caption associated to a specific video category which can be provided in different languages. | Used for Character Strings, length 1 to 128.
     * - base: xs:string
     * - maxLength: 128
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $Caption;
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - documentation: The version of the video item.
     * - use: optional
     * @var string
     */
    public $Version;
    /**
     * The Removal
     * Meta information extracted from the WSDL
     * - documentation: false | If true, this item is obsolete and should be removed from the receiving system.
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $Removal;
    /**
     * The CreateDateTime
     * Meta information extracted from the WSDL
     * - documentation: Time stamp of the creation.
     * - type: xs:dateTime
     * - use: optional
     * @var string
     */
    public $CreateDateTime;
    /**
     * The CreatorID
     * Meta information extracted from the WSDL
     * - documentation: ID of creator. The creator could be a software system identifier or an identifier of an employee resposible for the creation. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - type: StringLength1to32
     * - use: optional
     * @var string
     */
    public $CreatorID;
    /**
     * The LastModifyDateTime
     * Meta information extracted from the WSDL
     * - documentation: Time stamp of last modification.
     * - type: xs:dateTime
     * - use: optional
     * @var string
     */
    public $LastModifyDateTime;
    /**
     * The LastModifierID
     * Meta information extracted from the WSDL
     * - documentation: Identifies the last software system or person to modify a record. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - type: StringLength1to32
     * - use: optional
     * @var string
     */
    public $LastModifierID;
    /**
     * The PurgeDate
     * Meta information extracted from the WSDL
     * - documentation: Date an item will be purged from a database (e.g., from a live database to an archive).
     * - type: xs:date
     * - use: optional
     * @var string
     */
    public $PurgeDate;
    /**
     * Constructor method for VideoItem
     * @uses VideoItem::setLanguage()
     * @uses VideoItem::setCaption()
     * @uses VideoItem::setVersion()
     * @uses VideoItem::setRemoval()
     * @uses VideoItem::setCreateDateTime()
     * @uses VideoItem::setCreatorID()
     * @uses VideoItem::setLastModifyDateTime()
     * @uses VideoItem::setLastModifierID()
     * @uses VideoItem::setPurgeDate()
     * @param string $language
     * @param string $caption
     * @param string $version
     * @param bool $removal
     * @param string $createDateTime
     * @param string $creatorID
     * @param string $lastModifyDateTime
     * @param string $lastModifierID
     * @param string $purgeDate
     */
    public function __construct($language = null, $caption = null, $version = null, $removal = null, $createDateTime = null, $creatorID = null, $lastModifyDateTime = null, $lastModifierID = null, $purgeDate = null)
    {
        $this
            ->setLanguage($language)
            ->setCaption($caption)
            ->setVersion($version)
            ->setRemoval($removal)
            ->setCreateDateTime($createDateTime)
            ->setCreatorID($creatorID)
            ->setLastModifyDateTime($lastModifyDateTime)
            ->setLastModifierID($lastModifierID)
            ->setPurgeDate($purgeDate);
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\VideoItem
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get Caption value
     * @return string|null
     */
    public function getCaption()
    {
        return $this->Caption;
    }
    /**
     * Set Caption value
     * @param string $caption
     * @return \StructType\VideoItem
     */
    public function setCaption($caption = null)
    {
        // validation for constraint: string
        if (!is_null($caption) && !is_string($caption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($caption, true), gettype($caption)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($caption) && mb_strlen($caption) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($caption)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($caption) && mb_strlen($caption) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($caption)), __LINE__);
        }
        $this->Caption = $caption;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\VideoItem
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Removal value
     * @return bool|null
     */
    public function getRemoval()
    {
        return $this->Removal;
    }
    /**
     * Set Removal value
     * @param bool $removal
     * @return \StructType\VideoItem
     */
    public function setRemoval($removal = null)
    {
        // validation for constraint: boolean
        if (!is_null($removal) && !is_bool($removal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($removal, true), gettype($removal)), __LINE__);
        }
        $this->Removal = $removal;
        return $this;
    }
    /**
     * Get CreateDateTime value
     * @return string|null
     */
    public function getCreateDateTime()
    {
        return $this->CreateDateTime;
    }
    /**
     * Set CreateDateTime value
     * @param string $createDateTime
     * @return \StructType\VideoItem
     */
    public function setCreateDateTime($createDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($createDateTime) && !is_string($createDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDateTime, true), gettype($createDateTime)), __LINE__);
        }
        $this->CreateDateTime = $createDateTime;
        return $this;
    }
    /**
     * Get CreatorID value
     * @return string|null
     */
    public function getCreatorID()
    {
        return $this->CreatorID;
    }
    /**
     * Set CreatorID value
     * @param string $creatorID
     * @return \StructType\VideoItem
     */
    public function setCreatorID($creatorID = null)
    {
        // validation for constraint: string
        if (!is_null($creatorID) && !is_string($creatorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creatorID, true), gettype($creatorID)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($creatorID) && mb_strlen($creatorID) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($creatorID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($creatorID) && mb_strlen($creatorID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($creatorID)), __LINE__);
        }
        $this->CreatorID = $creatorID;
        return $this;
    }
    /**
     * Get LastModifyDateTime value
     * @return string|null
     */
    public function getLastModifyDateTime()
    {
        return $this->LastModifyDateTime;
    }
    /**
     * Set LastModifyDateTime value
     * @param string $lastModifyDateTime
     * @return \StructType\VideoItem
     */
    public function setLastModifyDateTime($lastModifyDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifyDateTime) && !is_string($lastModifyDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifyDateTime, true), gettype($lastModifyDateTime)), __LINE__);
        }
        $this->LastModifyDateTime = $lastModifyDateTime;
        return $this;
    }
    /**
     * Get LastModifierID value
     * @return string|null
     */
    public function getLastModifierID()
    {
        return $this->LastModifierID;
    }
    /**
     * Set LastModifierID value
     * @param string $lastModifierID
     * @return \StructType\VideoItem
     */
    public function setLastModifierID($lastModifierID = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifierID) && !is_string($lastModifierID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifierID, true), gettype($lastModifierID)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($lastModifierID) && mb_strlen($lastModifierID) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($lastModifierID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($lastModifierID) && mb_strlen($lastModifierID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($lastModifierID)), __LINE__);
        }
        $this->LastModifierID = $lastModifierID;
        return $this;
    }
    /**
     * Get PurgeDate value
     * @return string|null
     */
    public function getPurgeDate()
    {
        return $this->PurgeDate;
    }
    /**
     * Set PurgeDate value
     * @param string $purgeDate
     * @return \StructType\VideoItem
     */
    public function setPurgeDate($purgeDate = null)
    {
        // validation for constraint: string
        if (!is_null($purgeDate) && !is_string($purgeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purgeDate, true), gettype($purgeDate)), __LINE__);
        }
        $this->PurgeDate = $purgeDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VideoItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
