<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VideoFormat StructType
 * Meta information extracted from the WSDL
 * - documentation: A unique identifying value assigned by the creating system. The ID attribute may be used to reference a primary-key value within a database or in a particular implementation. | Multimedia information for the video file. | A set of
 * video of a given category can be provided in different Format, each format will be described in this element.
 * @subpackage Structs
 */
class VideoFormat extends VideoItemType
{
    /**
     * The ContentID
     * Meta information extracted from the WSDL
     * - documentation: The content ID of a file attachment with the prefix 'cid:'. The value of this can be used to retrieve the corresponding attachment by the receiving system. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - type: StringLength1to64
     * - use: optional
     * @var string
     */
    public $ContentID;
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - documentation: The title of the multimedia object. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - type: StringLength1to64
     * - use: optional
     * @var string
     */
    public $Title;
    /**
     * The Author
     * Meta information extracted from the WSDL
     * - documentation: The author of the multimedia object. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - type: StringLength1to64
     * - use: optional
     * @var string
     */
    public $Author;
    /**
     * The CopyrightNotice
     * Meta information extracted from the WSDL
     * - documentation: A copyright notice for the multimedia object. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - type: StringLength1to64
     * - use: optional
     * @var string
     */
    public $CopyrightNotice;
    /**
     * The CopyrightOwner
     * Meta information extracted from the WSDL
     * - documentation: Owner of the copyright for the multimedia content. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - type: StringLength1to64
     * - use: optional
     * @var string
     */
    public $CopyrightOwner;
    /**
     * The CopyrightStart
     * Meta information extracted from the WSDL
     * - documentation: The start date for which the multimedia content rights are claimed. | A construct to validate either a date or a dateTime value.
     * - type: DateOrDateTimeType
     * - union: date | dateTime
     * - use: optional
     * @var string
     */
    public $CopyrightStart;
    /**
     * The CopyrightEnd
     * Meta information extracted from the WSDL
     * - documentation: The end date for which the multimedia content rights are claimed. | A construct to validate either a date or a dateTime value.
     * - type: DateOrDateTimeType
     * - union: date | dateTime
     * - use: optional
     * @var string
     */
    public $CopyrightEnd;
    /**
     * The EffectiveStart
     * Meta information extracted from the WSDL
     * - documentation: The start date for which the content is considered valid. | A construct to validate either a date or a dateTime value.
     * - type: DateOrDateTimeType
     * - union: date | dateTime
     * - use: optional
     * @var string
     */
    public $EffectiveStart;
    /**
     * The EffectiveEnd
     * Meta information extracted from the WSDL
     * - documentation: The end date for which the content is considered valid. | A construct to validate either a date or a dateTime value.
     * - type: DateOrDateTimeType
     * - union: date | dateTime
     * - use: optional
     * @var string
     */
    public $EffectiveEnd;
    /**
     * The ApplicableStart
     * Meta information extracted from the WSDL
     * - documentation: Start month and day or date for which the multimedia content is relevent (e.g. the start of a season or the start of an event). When a year is not used (i.e. only the month and day) it signifies a recurring event. | A construct to
     * validate either a date or a month and day value.
     * - type: DateOrMonthDay
     * - union: date | gMonthDay
     * - use: optional
     * @var string
     */
    public $ApplicableStart;
    /**
     * The ApplicableEnd
     * Meta information extracted from the WSDL
     * - documentation: End month and day or date for which the multimedia content is relevent (e.g. the end of a season or the start of an event). When a year is not used (i.e. only the month and day) it signifies a recurring event. | A construct to
     * validate either a date or a month and day value.
     * - type: DateOrMonthDay
     * - union: date | gMonthDay
     * - use: optional
     * @var string
     */
    public $ApplicableEnd;
    /**
     * The RecordID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely identifies this file in the message. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - type: StringLength1to32
     * - use: optional
     * @var string
     */
    public $RecordID;
    /**
     * The SourceID
     * Meta information extracted from the WSDL
     * - documentation: Unique identifier for the source of the multimedia object (e.g., the original image file). | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - type: StringLength1to32
     * - use: optional
     * @var string
     */
    public $SourceID;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: A unique identifying value assigned by the creating system. The ID attribute may be used to reference a primary-key value within a database or in a particular implementation. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - type: StringLength1to32
     * - use: optional
     * @var string
     */
    public $ID;
    /**
     * Constructor method for VideoFormat
     * @uses VideoFormat::setContentID()
     * @uses VideoFormat::setTitle()
     * @uses VideoFormat::setAuthor()
     * @uses VideoFormat::setCopyrightNotice()
     * @uses VideoFormat::setCopyrightOwner()
     * @uses VideoFormat::setCopyrightStart()
     * @uses VideoFormat::setCopyrightEnd()
     * @uses VideoFormat::setEffectiveStart()
     * @uses VideoFormat::setEffectiveEnd()
     * @uses VideoFormat::setApplicableStart()
     * @uses VideoFormat::setApplicableEnd()
     * @uses VideoFormat::setRecordID()
     * @uses VideoFormat::setSourceID()
     * @uses VideoFormat::setID()
     * @param string $contentID
     * @param string $title
     * @param string $author
     * @param string $copyrightNotice
     * @param string $copyrightOwner
     * @param string $copyrightStart
     * @param string $copyrightEnd
     * @param string $effectiveStart
     * @param string $effectiveEnd
     * @param string $applicableStart
     * @param string $applicableEnd
     * @param string $recordID
     * @param string $sourceID
     * @param string $iD
     */
    public function __construct($contentID = null, $title = null, $author = null, $copyrightNotice = null, $copyrightOwner = null, $copyrightStart = null, $copyrightEnd = null, $effectiveStart = null, $effectiveEnd = null, $applicableStart = null, $applicableEnd = null, $recordID = null, $sourceID = null, $iD = null)
    {
        $this
            ->setContentID($contentID)
            ->setTitle($title)
            ->setAuthor($author)
            ->setCopyrightNotice($copyrightNotice)
            ->setCopyrightOwner($copyrightOwner)
            ->setCopyrightStart($copyrightStart)
            ->setCopyrightEnd($copyrightEnd)
            ->setEffectiveStart($effectiveStart)
            ->setEffectiveEnd($effectiveEnd)
            ->setApplicableStart($applicableStart)
            ->setApplicableEnd($applicableEnd)
            ->setRecordID($recordID)
            ->setSourceID($sourceID)
            ->setID($iD);
    }
    /**
     * Get ContentID value
     * @return string|null
     */
    public function getContentID()
    {
        return $this->ContentID;
    }
    /**
     * Set ContentID value
     * @param string $contentID
     * @return \StructType\VideoFormat
     */
    public function setContentID($contentID = null)
    {
        // validation for constraint: string
        if (!is_null($contentID) && !is_string($contentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contentID, true), gettype($contentID)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($contentID) && mb_strlen($contentID) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($contentID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($contentID) && mb_strlen($contentID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($contentID)), __LINE__);
        }
        $this->ContentID = $contentID;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\VideoFormat
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($title) && mb_strlen($title) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($title)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($title) && mb_strlen($title) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get Author value
     * @return string|null
     */
    public function getAuthor()
    {
        return $this->Author;
    }
    /**
     * Set Author value
     * @param string $author
     * @return \StructType\VideoFormat
     */
    public function setAuthor($author = null)
    {
        // validation for constraint: string
        if (!is_null($author) && !is_string($author)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($author, true), gettype($author)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($author) && mb_strlen($author) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($author)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($author) && mb_strlen($author) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($author)), __LINE__);
        }
        $this->Author = $author;
        return $this;
    }
    /**
     * Get CopyrightNotice value
     * @return string|null
     */
    public function getCopyrightNotice()
    {
        return $this->CopyrightNotice;
    }
    /**
     * Set CopyrightNotice value
     * @param string $copyrightNotice
     * @return \StructType\VideoFormat
     */
    public function setCopyrightNotice($copyrightNotice = null)
    {
        // validation for constraint: string
        if (!is_null($copyrightNotice) && !is_string($copyrightNotice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($copyrightNotice, true), gettype($copyrightNotice)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($copyrightNotice) && mb_strlen($copyrightNotice) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($copyrightNotice)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($copyrightNotice) && mb_strlen($copyrightNotice) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($copyrightNotice)), __LINE__);
        }
        $this->CopyrightNotice = $copyrightNotice;
        return $this;
    }
    /**
     * Get CopyrightOwner value
     * @return string|null
     */
    public function getCopyrightOwner()
    {
        return $this->CopyrightOwner;
    }
    /**
     * Set CopyrightOwner value
     * @param string $copyrightOwner
     * @return \StructType\VideoFormat
     */
    public function setCopyrightOwner($copyrightOwner = null)
    {
        // validation for constraint: string
        if (!is_null($copyrightOwner) && !is_string($copyrightOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($copyrightOwner, true), gettype($copyrightOwner)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($copyrightOwner) && mb_strlen($copyrightOwner) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($copyrightOwner)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($copyrightOwner) && mb_strlen($copyrightOwner) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($copyrightOwner)), __LINE__);
        }
        $this->CopyrightOwner = $copyrightOwner;
        return $this;
    }
    /**
     * Get CopyrightStart value
     * @return string|null
     */
    public function getCopyrightStart()
    {
        return $this->CopyrightStart;
    }
    /**
     * This method is responsible for validating the value passed to the setCopyrightStart method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCopyrightStart method
     * This is a set of validation rules based on the union types associated to the property being set by the setCopyrightStart method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCopyrightStartForUnionConstraintsFromSetCopyrightStart($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set CopyrightStart value
     * @param string $copyrightStart
     * @return \StructType\VideoFormat
     */
    public function setCopyrightStart($copyrightStart = null)
    {
        // validation for constraint: string
        if (!is_null($copyrightStart) && !is_string($copyrightStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($copyrightStart, true), gettype($copyrightStart)), __LINE__);
        }
        // validation for constraint: union(date, dateTime)
        if ('' !== ($copyrightStartUnionErrorMessage = self::validateCopyrightStartForUnionConstraintsFromSetCopyrightStart($copyrightStart))) {
            throw new \InvalidArgumentException($copyrightStartUnionErrorMessage, __LINE__);
        }
        $this->CopyrightStart = $copyrightStart;
        return $this;
    }
    /**
     * Get CopyrightEnd value
     * @return string|null
     */
    public function getCopyrightEnd()
    {
        return $this->CopyrightEnd;
    }
    /**
     * This method is responsible for validating the value passed to the setCopyrightEnd method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCopyrightEnd method
     * This is a set of validation rules based on the union types associated to the property being set by the setCopyrightEnd method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCopyrightEndForUnionConstraintsFromSetCopyrightEnd($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set CopyrightEnd value
     * @param string $copyrightEnd
     * @return \StructType\VideoFormat
     */
    public function setCopyrightEnd($copyrightEnd = null)
    {
        // validation for constraint: string
        if (!is_null($copyrightEnd) && !is_string($copyrightEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($copyrightEnd, true), gettype($copyrightEnd)), __LINE__);
        }
        // validation for constraint: union(date, dateTime)
        if ('' !== ($copyrightEndUnionErrorMessage = self::validateCopyrightEndForUnionConstraintsFromSetCopyrightEnd($copyrightEnd))) {
            throw new \InvalidArgumentException($copyrightEndUnionErrorMessage, __LINE__);
        }
        $this->CopyrightEnd = $copyrightEnd;
        return $this;
    }
    /**
     * Get EffectiveStart value
     * @return string|null
     */
    public function getEffectiveStart()
    {
        return $this->EffectiveStart;
    }
    /**
     * This method is responsible for validating the value passed to the setEffectiveStart method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEffectiveStart method
     * This is a set of validation rules based on the union types associated to the property being set by the setEffectiveStart method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEffectiveStartForUnionConstraintsFromSetEffectiveStart($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set EffectiveStart value
     * @param string $effectiveStart
     * @return \StructType\VideoFormat
     */
    public function setEffectiveStart($effectiveStart = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveStart) && !is_string($effectiveStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveStart, true), gettype($effectiveStart)), __LINE__);
        }
        // validation for constraint: union(date, dateTime)
        if ('' !== ($effectiveStartUnionErrorMessage = self::validateEffectiveStartForUnionConstraintsFromSetEffectiveStart($effectiveStart))) {
            throw new \InvalidArgumentException($effectiveStartUnionErrorMessage, __LINE__);
        }
        $this->EffectiveStart = $effectiveStart;
        return $this;
    }
    /**
     * Get EffectiveEnd value
     * @return string|null
     */
    public function getEffectiveEnd()
    {
        return $this->EffectiveEnd;
    }
    /**
     * This method is responsible for validating the value passed to the setEffectiveEnd method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEffectiveEnd method
     * This is a set of validation rules based on the union types associated to the property being set by the setEffectiveEnd method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEffectiveEndForUnionConstraintsFromSetEffectiveEnd($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set EffectiveEnd value
     * @param string $effectiveEnd
     * @return \StructType\VideoFormat
     */
    public function setEffectiveEnd($effectiveEnd = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveEnd) && !is_string($effectiveEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveEnd, true), gettype($effectiveEnd)), __LINE__);
        }
        // validation for constraint: union(date, dateTime)
        if ('' !== ($effectiveEndUnionErrorMessage = self::validateEffectiveEndForUnionConstraintsFromSetEffectiveEnd($effectiveEnd))) {
            throw new \InvalidArgumentException($effectiveEndUnionErrorMessage, __LINE__);
        }
        $this->EffectiveEnd = $effectiveEnd;
        return $this;
    }
    /**
     * Get ApplicableStart value
     * @return string|null
     */
    public function getApplicableStart()
    {
        return $this->ApplicableStart;
    }
    /**
     * This method is responsible for validating the value passed to the setApplicableStart method
     * This method is willingly generated in order to preserve the one-line inline validation within the setApplicableStart method
     * This is a set of validation rules based on the union types associated to the property being set by the setApplicableStart method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateApplicableStartForUnionConstraintsFromSetApplicableStart($value)
    {
        $message = '';
        // validation for constraint: int
        if (!is_null($value) && !(is_int($value) || ctype_digit($value))) {
            $exception0 = new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        if (isset($exception0)) {
            $message = sprintf("The value %s does not match any of the union rules: date, gMonthDay. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [$exception0])));
        }
        unset($exception0);
        return $message;
    }
    /**
     * Set ApplicableStart value
     * @param string $applicableStart
     * @return \StructType\VideoFormat
     */
    public function setApplicableStart($applicableStart = null)
    {
        // validation for constraint: string
        if (!is_null($applicableStart) && !is_string($applicableStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicableStart, true), gettype($applicableStart)), __LINE__);
        }
        // validation for constraint: union(date, gMonthDay)
        if ('' !== ($applicableStartUnionErrorMessage = self::validateApplicableStartForUnionConstraintsFromSetApplicableStart($applicableStart))) {
            throw new \InvalidArgumentException($applicableStartUnionErrorMessage, __LINE__);
        }
        $this->ApplicableStart = $applicableStart;
        return $this;
    }
    /**
     * Get ApplicableEnd value
     * @return string|null
     */
    public function getApplicableEnd()
    {
        return $this->ApplicableEnd;
    }
    /**
     * This method is responsible for validating the value passed to the setApplicableEnd method
     * This method is willingly generated in order to preserve the one-line inline validation within the setApplicableEnd method
     * This is a set of validation rules based on the union types associated to the property being set by the setApplicableEnd method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateApplicableEndForUnionConstraintsFromSetApplicableEnd($value)
    {
        $message = '';
        // validation for constraint: int
        if (!is_null($value) && !(is_int($value) || ctype_digit($value))) {
            $exception0 = new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        if (isset($exception0)) {
            $message = sprintf("The value %s does not match any of the union rules: date, gMonthDay. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [$exception0])));
        }
        unset($exception0);
        return $message;
    }
    /**
     * Set ApplicableEnd value
     * @param string $applicableEnd
     * @return \StructType\VideoFormat
     */
    public function setApplicableEnd($applicableEnd = null)
    {
        // validation for constraint: string
        if (!is_null($applicableEnd) && !is_string($applicableEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicableEnd, true), gettype($applicableEnd)), __LINE__);
        }
        // validation for constraint: union(date, gMonthDay)
        if ('' !== ($applicableEndUnionErrorMessage = self::validateApplicableEndForUnionConstraintsFromSetApplicableEnd($applicableEnd))) {
            throw new \InvalidArgumentException($applicableEndUnionErrorMessage, __LINE__);
        }
        $this->ApplicableEnd = $applicableEnd;
        return $this;
    }
    /**
     * Get RecordID value
     * @return string|null
     */
    public function getRecordID()
    {
        return $this->RecordID;
    }
    /**
     * Set RecordID value
     * @param string $recordID
     * @return \StructType\VideoFormat
     */
    public function setRecordID($recordID = null)
    {
        // validation for constraint: string
        if (!is_null($recordID) && !is_string($recordID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recordID, true), gettype($recordID)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($recordID) && mb_strlen($recordID) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($recordID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($recordID) && mb_strlen($recordID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($recordID)), __LINE__);
        }
        $this->RecordID = $recordID;
        return $this;
    }
    /**
     * Get SourceID value
     * @return string|null
     */
    public function getSourceID()
    {
        return $this->SourceID;
    }
    /**
     * Set SourceID value
     * @param string $sourceID
     * @return \StructType\VideoFormat
     */
    public function setSourceID($sourceID = null)
    {
        // validation for constraint: string
        if (!is_null($sourceID) && !is_string($sourceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceID, true), gettype($sourceID)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($sourceID) && mb_strlen($sourceID) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($sourceID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($sourceID) && mb_strlen($sourceID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($sourceID)), __LINE__);
        }
        $this->SourceID = $sourceID;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\VideoFormat
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($iD) && mb_strlen($iD) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($iD)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($iD) && mb_strlen($iD) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VideoFormat
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
