<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VendorPrefs StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of vendor preferences.
 * @subpackage Structs
 */
class VendorPrefs extends AbstractStructBase
{
    /**
     * The VendorPref
     * Meta information extracted from the WSDL
     * - maxOccurs: 20
     * @var \StructType\VendorPref[]
     */
    public $VendorPref;
    /**
     * The ParticipationLevelCode
     * Meta information extracted from the WSDL
     * - documentation: To specify vendors with a certain level of participation in a system. Refer to OpenTravel Code List Participation Level (PLC). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or
     * 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $ParticipationLevelCode;
    /**
     * The LocationCategory
     * Meta information extracted from the WSDL
     * - documentation: The type of location being requested. Refer to OpenTravel Code List Vehicle Where at Facility (VWF). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $LocationCategory;
    /**
     * Constructor method for VendorPrefs
     * @uses VendorPrefs::setVendorPref()
     * @uses VendorPrefs::setParticipationLevelCode()
     * @uses VendorPrefs::setLocationCategory()
     * @param \StructType\VendorPref[] $vendorPref
     * @param string $participationLevelCode
     * @param string $locationCategory
     */
    public function __construct(array $vendorPref = array(), $participationLevelCode = null, $locationCategory = null)
    {
        $this
            ->setVendorPref($vendorPref)
            ->setParticipationLevelCode($participationLevelCode)
            ->setLocationCategory($locationCategory);
    }
    /**
     * Get VendorPref value
     * @return \StructType\VendorPref[]|null
     */
    public function getVendorPref()
    {
        return $this->VendorPref;
    }
    /**
     * This method is responsible for validating the values passed to the setVendorPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVendorPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVendorPrefForArrayConstraintsFromSetVendorPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vendorPrefsVendorPrefItem) {
            // validation for constraint: itemType
            if (!$vendorPrefsVendorPrefItem instanceof \StructType\VendorPref) {
                $invalidValues[] = is_object($vendorPrefsVendorPrefItem) ? get_class($vendorPrefsVendorPrefItem) : sprintf('%s(%s)', gettype($vendorPrefsVendorPrefItem), var_export($vendorPrefsVendorPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VendorPref property can only contain items of type \StructType\VendorPref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VendorPref value
     * @throws \InvalidArgumentException
     * @param \StructType\VendorPref[] $vendorPref
     * @return \StructType\VendorPrefs
     */
    public function setVendorPref(array $vendorPref = array())
    {
        // validation for constraint: array
        if ('' !== ($vendorPrefArrayErrorMessage = self::validateVendorPrefForArrayConstraintsFromSetVendorPref($vendorPref))) {
            throw new \InvalidArgumentException($vendorPrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(20)
        if (is_array($vendorPref) && count($vendorPref) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 20', count($vendorPref)), __LINE__);
        }
        $this->VendorPref = $vendorPref;
        return $this;
    }
    /**
     * Add item to VendorPref value
     * @throws \InvalidArgumentException
     * @param \StructType\VendorPref $item
     * @return \StructType\VendorPrefs
     */
    public function addToVendorPref(\StructType\VendorPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VendorPref) {
            throw new \InvalidArgumentException(sprintf('The VendorPref property can only contain items of type \StructType\VendorPref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(20)
        if (is_array($this->VendorPref) && count($this->VendorPref) >= 20) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 20', count($this->VendorPref)), __LINE__);
        }
        $this->VendorPref[] = $item;
        return $this;
    }
    /**
     * Get ParticipationLevelCode value
     * @return string|null
     */
    public function getParticipationLevelCode()
    {
        return $this->ParticipationLevelCode;
    }
    /**
     * Set ParticipationLevelCode value
     * @param string $participationLevelCode
     * @return \StructType\VendorPrefs
     */
    public function setParticipationLevelCode($participationLevelCode = null)
    {
        // validation for constraint: string
        if (!is_null($participationLevelCode) && !is_string($participationLevelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($participationLevelCode, true), gettype($participationLevelCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($participationLevelCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $participationLevelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($participationLevelCode, true)), __LINE__);
        }
        $this->ParticipationLevelCode = $participationLevelCode;
        return $this;
    }
    /**
     * Get LocationCategory value
     * @return string|null
     */
    public function getLocationCategory()
    {
        return $this->LocationCategory;
    }
    /**
     * Set LocationCategory value
     * @param string $locationCategory
     * @return \StructType\VendorPrefs
     */
    public function setLocationCategory($locationCategory = null)
    {
        // validation for constraint: string
        if (!is_null($locationCategory) && !is_string($locationCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locationCategory, true), gettype($locationCategory)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($locationCategory) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $locationCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($locationCategory, true)), __LINE__);
        }
        $this->LocationCategory = $locationCategory;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VendorPrefs
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
