<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VendorPref StructType
 * Meta information extracted from the WSDL
 * - documentation: Indicates the preferred Vendor Company for the vehicle rental. If a company name is supplied, the rates will be supplied for the specific Vendor Company. The company name is unique amongst the vendors. | Specify vendors to include
 * and exclude from the response. | Identifies the preferred airline carrier(s) by name.
 * @subpackage Structs
 */
class VendorPref extends CompanyNamePrefType
{
    /**
     * The _
     * @var \StructType\CompanyNamePrefType
     */
    public $_;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: A reference pointer used to identify an airline vendor. | The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign individual passengers or clients to
     * particular itinerary items).
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The AllianceAllowedInd
     * Meta information extracted from the WSDL
     * - documentation: When true, flights for other airlines in an alliance with the specified carrier code may be returned.
     * - use: optional
     * @var bool
     */
    public $AllianceAllowedInd;
    /**
     * The LoyaltyAllowedInd
     * Meta information extracted from the WSDL
     * - documentation: When true, flights for other airlines in a loyalty program with the specified carrier code may be returned.
     * - use: optional
     * @var bool
     */
    public $LoyaltyAllowedInd;
    /**
     * The CorpDiscountNmbr
     * Meta information extracted from the WSDL
     * - documentation: This is the vendor specific code used to identify a special rate associated with a specific organization. Used when multiple vendors have been requested and there is a different code for each. | Used for Character Strings, length 1
     * to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $CorpDiscountNmbr;
    /**
     * Constructor method for VendorPref
     * @uses VendorPref::set_()
     * @uses VendorPref::setRPH()
     * @uses VendorPref::setAllianceAllowedInd()
     * @uses VendorPref::setLoyaltyAllowedInd()
     * @uses VendorPref::setCorpDiscountNmbr()
     * @param \StructType\CompanyNamePrefType $_
     * @param string $rPH
     * @param bool $allianceAllowedInd
     * @param bool $loyaltyAllowedInd
     * @param string $corpDiscountNmbr
     */
    public function __construct(\StructType\CompanyNamePrefType $_ = null, $rPH = null, $allianceAllowedInd = null, $loyaltyAllowedInd = null, $corpDiscountNmbr = null)
    {
        $this
            ->set_($_)
            ->setRPH($rPH)
            ->setAllianceAllowedInd($allianceAllowedInd)
            ->setLoyaltyAllowedInd($loyaltyAllowedInd)
            ->setCorpDiscountNmbr($corpDiscountNmbr);
    }
    /**
     * Get _ value
     * @return \StructType\CompanyNamePrefType|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param \StructType\CompanyNamePrefType $_
     * @return \StructType\VendorPref
     */
    public function set_(\StructType\CompanyNamePrefType $_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\VendorPref
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($rPH) && !preg_match('/[0-9]{1,8}/', $rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($rPH, true)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get AllianceAllowedInd value
     * @return bool|null
     */
    public function getAllianceAllowedInd()
    {
        return $this->AllianceAllowedInd;
    }
    /**
     * Set AllianceAllowedInd value
     * @param bool $allianceAllowedInd
     * @return \StructType\VendorPref
     */
    public function setAllianceAllowedInd($allianceAllowedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($allianceAllowedInd) && !is_bool($allianceAllowedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allianceAllowedInd, true), gettype($allianceAllowedInd)), __LINE__);
        }
        $this->AllianceAllowedInd = $allianceAllowedInd;
        return $this;
    }
    /**
     * Get LoyaltyAllowedInd value
     * @return bool|null
     */
    public function getLoyaltyAllowedInd()
    {
        return $this->LoyaltyAllowedInd;
    }
    /**
     * Set LoyaltyAllowedInd value
     * @param bool $loyaltyAllowedInd
     * @return \StructType\VendorPref
     */
    public function setLoyaltyAllowedInd($loyaltyAllowedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($loyaltyAllowedInd) && !is_bool($loyaltyAllowedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($loyaltyAllowedInd, true), gettype($loyaltyAllowedInd)), __LINE__);
        }
        $this->LoyaltyAllowedInd = $loyaltyAllowedInd;
        return $this;
    }
    /**
     * Get CorpDiscountNmbr value
     * @return string|null
     */
    public function getCorpDiscountNmbr()
    {
        return $this->CorpDiscountNmbr;
    }
    /**
     * Set CorpDiscountNmbr value
     * @param string $corpDiscountNmbr
     * @return \StructType\VendorPref
     */
    public function setCorpDiscountNmbr($corpDiscountNmbr = null)
    {
        // validation for constraint: string
        if (!is_null($corpDiscountNmbr) && !is_string($corpDiscountNmbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($corpDiscountNmbr, true), gettype($corpDiscountNmbr)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($corpDiscountNmbr) && mb_strlen($corpDiscountNmbr) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($corpDiscountNmbr)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($corpDiscountNmbr) && mb_strlen($corpDiscountNmbr) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($corpDiscountNmbr)), __LINE__);
        }
        $this->CorpDiscountNmbr = $corpDiscountNmbr;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VendorPref
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
