<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VendorMessages StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of free-format messages associated with this reservation.
 * @subpackage Structs
 */
class VendorMessages extends AbstractStructBase
{
    /**
     * The VendorMessage
     * Meta information extracted from the WSDL
     * - documentation: A specific vendor message associated with this reservation.
     * - maxOccurs: 99
     * @var \StructType\FormattedTextType[]
     */
    public $VendorMessage;
    /**
     * Constructor method for VendorMessages
     * @uses VendorMessages::setVendorMessage()
     * @param \StructType\FormattedTextType[] $vendorMessage
     */
    public function __construct(array $vendorMessage = array())
    {
        $this
            ->setVendorMessage($vendorMessage);
    }
    /**
     * Get VendorMessage value
     * @return \StructType\FormattedTextType[]|null
     */
    public function getVendorMessage()
    {
        return $this->VendorMessage;
    }
    /**
     * This method is responsible for validating the values passed to the setVendorMessage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVendorMessage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVendorMessageForArrayConstraintsFromSetVendorMessage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vendorMessagesVendorMessageItem) {
            // validation for constraint: itemType
            if (!$vendorMessagesVendorMessageItem instanceof \StructType\FormattedTextType) {
                $invalidValues[] = is_object($vendorMessagesVendorMessageItem) ? get_class($vendorMessagesVendorMessageItem) : sprintf('%s(%s)', gettype($vendorMessagesVendorMessageItem), var_export($vendorMessagesVendorMessageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VendorMessage property can only contain items of type \StructType\FormattedTextType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VendorMessage value
     * @throws \InvalidArgumentException
     * @param \StructType\FormattedTextType[] $vendorMessage
     * @return \StructType\VendorMessages
     */
    public function setVendorMessage(array $vendorMessage = array())
    {
        // validation for constraint: array
        if ('' !== ($vendorMessageArrayErrorMessage = self::validateVendorMessageForArrayConstraintsFromSetVendorMessage($vendorMessage))) {
            throw new \InvalidArgumentException($vendorMessageArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($vendorMessage) && count($vendorMessage) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($vendorMessage)), __LINE__);
        }
        $this->VendorMessage = $vendorMessage;
        return $this;
    }
    /**
     * Add item to VendorMessage value
     * @throws \InvalidArgumentException
     * @param \StructType\FormattedTextType $item
     * @return \StructType\VendorMessages
     */
    public function addToVendorMessage(\StructType\FormattedTextType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FormattedTextType) {
            throw new \InvalidArgumentException(sprintf('The VendorMessage property can only contain items of type \StructType\FormattedTextType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->VendorMessage) && count($this->VendorMessage) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->VendorMessage)), __LINE__);
        }
        $this->VendorMessage[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VendorMessages
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
