<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Vehicles StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of vehicles for which this charge applies. This is to be used when the charge is not the same charge for all vehicle types. | A collection of vehicle information associated to the age requirements. | A collection of
 * vehicles associated with additional driver information.
 * @subpackage Structs
 */
class Vehicles extends AbstractStructBase
{
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\Vehicle[]
     */
    public $Vehicle;
    /**
     * Constructor method for Vehicles
     * @uses Vehicles::setVehicle()
     * @param \StructType\Vehicle[] $vehicle
     */
    public function __construct(array $vehicle = array())
    {
        $this
            ->setVehicle($vehicle);
    }
    /**
     * Get Vehicle value
     * @return \StructType\Vehicle[]|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * This method is responsible for validating the values passed to the setVehicle method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVehicle method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVehicleForArrayConstraintsFromSetVehicle(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehiclesVehicleItem) {
            // validation for constraint: itemType
            if (!$vehiclesVehicleItem instanceof \StructType\Vehicle) {
                $invalidValues[] = is_object($vehiclesVehicleItem) ? get_class($vehiclesVehicleItem) : sprintf('%s(%s)', gettype($vehiclesVehicleItem), var_export($vehiclesVehicleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Vehicle property can only contain items of type \StructType\Vehicle, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Vehicle value
     * @throws \InvalidArgumentException
     * @param \StructType\Vehicle[] $vehicle
     * @return \StructType\Vehicles
     */
    public function setVehicle(array $vehicle = array())
    {
        // validation for constraint: array
        if ('' !== ($vehicleArrayErrorMessage = self::validateVehicleForArrayConstraintsFromSetVehicle($vehicle))) {
            throw new \InvalidArgumentException($vehicleArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($vehicle) && count($vehicle) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($vehicle)), __LINE__);
        }
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Add item to Vehicle value
     * @throws \InvalidArgumentException
     * @param \StructType\Vehicle $item
     * @return \StructType\Vehicles
     */
    public function addToVehicle(\StructType\Vehicle $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Vehicle) {
            throw new \InvalidArgumentException(sprintf('The Vehicle property can only contain items of type \StructType\Vehicle, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->Vehicle) && count($this->Vehicle) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->Vehicle)), __LINE__);
        }
        $this->Vehicle[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Vehicles
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
