<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleWhereAtFacilityType StructType
 * Meta information extracted from the WSDL
 * - documentation: The VehicleWhereAtFacilityType complex type defines the information needed to describe the location of the associated item at a rental facility. Example of the items that may make use of this type include Rental Counter, Vehicle
 * Parking Locations, etc. | Used for Character Strings, length 0 to 255.
 * - base: xs:string
 * - maxLength: 255
 * - minLength: 0
 * @subpackage Structs
 */
class VehicleWhereAtFacilityType extends AbstractStructBase
{
    /**
     * The Location
     * Meta information extracted from the WSDL
     * - documentation: The Location attribute identifies the location of an item at an airport. Refer to OpenTravel Code List Vehicle Where At Facility (VWF) (e.g., shuttle on airport). | Used for codes in the OpenTravel Code tables. Possible values of
     * this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: required
     * @var string
     */
    public $Location;
    /**
     * The _
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 0 to 255.
     * - base: xs:string
     * - maxLength: 255
     * - minLength: 0
     * @var string
     */
    public $_;
    /**
     * Constructor method for VehicleWhereAtFacilityType
     * @uses VehicleWhereAtFacilityType::setLocation()
     * @uses VehicleWhereAtFacilityType::set_()
     * @param string $location
     * @param string $_
     */
    public function __construct($location = null, $_ = null)
    {
        $this
            ->setLocation($location)
            ->set_($_);
    }
    /**
     * Get Location value
     * @return string
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param string $location
     * @return \StructType\VehicleWhereAtFacilityType
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($location, true), gettype($location)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($location) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($location, true)), __LINE__);
        }
        $this->Location = $location;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\VehicleWhereAtFacilityType
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($_) && mb_strlen($_) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($_)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($_) && mb_strlen($_) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleWhereAtFacilityType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
