<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleVendorAvailabilityType StructType
 * Meta information extracted from the WSDL
 * - documentation: The VehicleVendorAvailabilityType complex type identifies the data that describes the availability of one or more vehicles for a specific vendor, along with supplemental information about the vendor and the facilities of that vendor.
 * @subpackage Structs
 */
class VehicleVendorAvailabilityType extends AbstractStructBase
{
    /**
     * The Vendor
     * Meta information extracted from the WSDL
     * - documentation: Information on the vendor associated with this availability of vehicles
     * - minOccurs: 0
     * @var \StructType\CompanyNameType
     */
    public $Vendor;
    /**
     * The VehAvails
     * @var \StructType\VehAvails
     */
    public $VehAvails;
    /**
     * The Info
     * Meta information extracted from the WSDL
     * - documentation: Supplemental information associated with the vendor and the availability of the vehicles.
     * - minOccurs: 0
     * @var \StructType\VehicleAvailVendorInfoType
     */
    public $Info;
    /**
     * Constructor method for VehicleVendorAvailabilityType
     * @uses VehicleVendorAvailabilityType::setVendor()
     * @uses VehicleVendorAvailabilityType::setVehAvails()
     * @uses VehicleVendorAvailabilityType::setInfo()
     * @param \StructType\CompanyNameType $vendor
     * @param \StructType\VehAvails $vehAvails
     * @param \StructType\VehicleAvailVendorInfoType $info
     */
    public function __construct(\StructType\CompanyNameType $vendor = null, \StructType\VehAvails $vehAvails = null, \StructType\VehicleAvailVendorInfoType $info = null)
    {
        $this
            ->setVendor($vendor)
            ->setVehAvails($vehAvails)
            ->setInfo($info);
    }
    /**
     * Get Vendor value
     * @return \StructType\CompanyNameType|null
     */
    public function getVendor()
    {
        return $this->Vendor;
    }
    /**
     * Set Vendor value
     * @param \StructType\CompanyNameType $vendor
     * @return \StructType\VehicleVendorAvailabilityType
     */
    public function setVendor(\StructType\CompanyNameType $vendor = null)
    {
        $this->Vendor = $vendor;
        return $this;
    }
    /**
     * Get VehAvails value
     * @return \StructType\VehAvails|null
     */
    public function getVehAvails()
    {
        return $this->VehAvails;
    }
    /**
     * Set VehAvails value
     * @param \StructType\VehAvails $vehAvails
     * @return \StructType\VehicleVendorAvailabilityType
     */
    public function setVehAvails(\StructType\VehAvails $vehAvails = null)
    {
        $this->VehAvails = $vehAvails;
        return $this;
    }
    /**
     * Get Info value
     * @return \StructType\VehicleAvailVendorInfoType|null
     */
    public function getInfo()
    {
        return $this->Info;
    }
    /**
     * Set Info value
     * @param \StructType\VehicleAvailVendorInfoType $info
     * @return \StructType\VehicleVendorAvailabilityType
     */
    public function setInfo(\StructType\VehicleAvailVendorInfoType $info = null)
    {
        $this->Info = $info;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleVendorAvailabilityType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
