<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleType StructType
 * Meta information extracted from the WSDL
 * - documentation: The effective date range for the vehicle information. | The volume (i.e., unit of measure and quantity) of the boot/trunk. | Code used to identify the vehicle. May be used in place of VehicleCoreType. Typically a SIPP code would be
 * passed here. Identifies the source authority for the code (e.g., SIPP). | The VehicleType complex type identifie sthe data that fully describes a vehicle. This includes the core information along with supplemental information such as make and model,
 * and a link to a picture.
 * @subpackage Structs
 */
class VehicleType extends VehicleCoreType
{
    /**
     * The VehMakeModel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VehMakeModel
     */
    public $VehMakeModel;
    /**
     * The PictureURL
     * Meta information extracted from the WSDL
     * - documentation: URL that identifies the location of a picture to describe this vehicle.
     * - minOccurs: 0
     * @var string
     */
    public $PictureURL;
    /**
     * The VehIdentity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VehIdentity
     */
    public $VehIdentity;
    /**
     * The PassengerQuantity
     * Meta information extracted from the WSDL
     * - documentation: Number of passengers that can be accommodated by this vehicle. This may be an exact number or may be a range, i.e., 4-5, 5-6. | Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $PassengerQuantity;
    /**
     * The BaggageQuantity
     * Meta information extracted from the WSDL
     * - documentation: Number of bags/suitcases that can be accommodated by this vehicle.
     * - use: optional
     * @var int
     */
    public $BaggageQuantity;
    /**
     * The VendorCarType
     * Meta information extracted from the WSDL
     * - documentation: An internal car type assigned by the vendor. This is not the SIPP code. | Used for Alpha-Numeric Strings, length 1 to 8.
     * - base: xs:string
     * - pattern: [0-9a-zA-Z]{1,8}
     * - use: optional
     * @var string
     */
    public $VendorCarType;
    /**
     * The OdometerUnitOfMeasure
     * Meta information extracted from the WSDL
     * - documentation: Provides the units in which distance is measured, when applied to a vehicle (i.e., miles or kilometers)
     * - use: optional
     * @var string
     */
    public $OdometerUnitOfMeasure;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $Code;
    /**
     * The CodeContext
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $CodeContext;
    /**
     * The UnitOfMeasureQuantity
     * @var float
     */
    public $UnitOfMeasureQuantity;
    /**
     * The UnitOfMeasure
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * @var string
     */
    public $UnitOfMeasure;
    /**
     * The UnitOfMeasureCode
     * Meta information extracted from the WSDL
     * - documentation: Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * @var string
     */
    public $UnitOfMeasureCode;
    /**
     * The Start
     * Meta information extracted from the WSDL
     * - documentation: A construct to validate either a date or a time or a dateTime value.
     * - union: date | dateTime | time
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - documentation: Allows for the specification of a night duration.
     * - union: duration | NightDurationType
     * @var string
     */
    public $Duration;
    /**
     * The End
     * Meta information extracted from the WSDL
     * - documentation: A construct to validate either a date or a time or a dateTime value.
     * - union: date | dateTime | time
     * @var string
     */
    public $End;
    /**
     * Constructor method for VehicleType
     * @uses VehicleType::setVehMakeModel()
     * @uses VehicleType::setPictureURL()
     * @uses VehicleType::setVehIdentity()
     * @uses VehicleType::setPassengerQuantity()
     * @uses VehicleType::setBaggageQuantity()
     * @uses VehicleType::setVendorCarType()
     * @uses VehicleType::setOdometerUnitOfMeasure()
     * @uses VehicleType::setCode()
     * @uses VehicleType::setCodeContext()
     * @uses VehicleType::setUnitOfMeasureQuantity()
     * @uses VehicleType::setUnitOfMeasure()
     * @uses VehicleType::setUnitOfMeasureCode()
     * @uses VehicleType::setStart()
     * @uses VehicleType::setDuration()
     * @uses VehicleType::setEnd()
     * @param \StructType\VehMakeModel $vehMakeModel
     * @param string $pictureURL
     * @param \StructType\VehIdentity $vehIdentity
     * @param string $passengerQuantity
     * @param int $baggageQuantity
     * @param string $vendorCarType
     * @param string $odometerUnitOfMeasure
     * @param string $code
     * @param string $codeContext
     * @param float $unitOfMeasureQuantity
     * @param string $unitOfMeasure
     * @param string $unitOfMeasureCode
     * @param string $start
     * @param string $duration
     * @param string $end
     */
    public function __construct(\StructType\VehMakeModel $vehMakeModel = null, $pictureURL = null, \StructType\VehIdentity $vehIdentity = null, $passengerQuantity = null, $baggageQuantity = null, $vendorCarType = null, $odometerUnitOfMeasure = null, $code = null, $codeContext = null, $unitOfMeasureQuantity = null, $unitOfMeasure = null, $unitOfMeasureCode = null, $start = null, $duration = null, $end = null)
    {
        $this
            ->setVehMakeModel($vehMakeModel)
            ->setPictureURL($pictureURL)
            ->setVehIdentity($vehIdentity)
            ->setPassengerQuantity($passengerQuantity)
            ->setBaggageQuantity($baggageQuantity)
            ->setVendorCarType($vendorCarType)
            ->setOdometerUnitOfMeasure($odometerUnitOfMeasure)
            ->setCode($code)
            ->setCodeContext($codeContext)
            ->setUnitOfMeasureQuantity($unitOfMeasureQuantity)
            ->setUnitOfMeasure($unitOfMeasure)
            ->setUnitOfMeasureCode($unitOfMeasureCode)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end);
    }
    /**
     * Get VehMakeModel value
     * @return \StructType\VehMakeModel|null
     */
    public function getVehMakeModel()
    {
        return $this->VehMakeModel;
    }
    /**
     * Set VehMakeModel value
     * @param \StructType\VehMakeModel $vehMakeModel
     * @return \StructType\VehicleType
     */
    public function setVehMakeModel(\StructType\VehMakeModel $vehMakeModel = null)
    {
        $this->VehMakeModel = $vehMakeModel;
        return $this;
    }
    /**
     * Get PictureURL value
     * @return string|null
     */
    public function getPictureURL()
    {
        return $this->PictureURL;
    }
    /**
     * Set PictureURL value
     * @param string $pictureURL
     * @return \StructType\VehicleType
     */
    public function setPictureURL($pictureURL = null)
    {
        // validation for constraint: string
        if (!is_null($pictureURL) && !is_string($pictureURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pictureURL, true), gettype($pictureURL)), __LINE__);
        }
        $this->PictureURL = $pictureURL;
        return $this;
    }
    /**
     * Get VehIdentity value
     * @return \StructType\VehIdentity|null
     */
    public function getVehIdentity()
    {
        return $this->VehIdentity;
    }
    /**
     * Set VehIdentity value
     * @param \StructType\VehIdentity $vehIdentity
     * @return \StructType\VehicleType
     */
    public function setVehIdentity(\StructType\VehIdentity $vehIdentity = null)
    {
        $this->VehIdentity = $vehIdentity;
        return $this;
    }
    /**
     * Get PassengerQuantity value
     * @return string|null
     */
    public function getPassengerQuantity()
    {
        return $this->PassengerQuantity;
    }
    /**
     * Set PassengerQuantity value
     * @param string $passengerQuantity
     * @return \StructType\VehicleType
     */
    public function setPassengerQuantity($passengerQuantity = null)
    {
        // validation for constraint: string
        if (!is_null($passengerQuantity) && !is_string($passengerQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passengerQuantity, true), gettype($passengerQuantity)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($passengerQuantity) && mb_strlen($passengerQuantity) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($passengerQuantity)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($passengerQuantity) && mb_strlen($passengerQuantity) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($passengerQuantity)), __LINE__);
        }
        $this->PassengerQuantity = $passengerQuantity;
        return $this;
    }
    /**
     * Get BaggageQuantity value
     * @return int|null
     */
    public function getBaggageQuantity()
    {
        return $this->BaggageQuantity;
    }
    /**
     * Set BaggageQuantity value
     * @param int $baggageQuantity
     * @return \StructType\VehicleType
     */
    public function setBaggageQuantity($baggageQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($baggageQuantity) && !(is_int($baggageQuantity) || ctype_digit($baggageQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($baggageQuantity, true), gettype($baggageQuantity)), __LINE__);
        }
        $this->BaggageQuantity = $baggageQuantity;
        return $this;
    }
    /**
     * Get VendorCarType value
     * @return string|null
     */
    public function getVendorCarType()
    {
        return $this->VendorCarType;
    }
    /**
     * Set VendorCarType value
     * @param string $vendorCarType
     * @return \StructType\VehicleType
     */
    public function setVendorCarType($vendorCarType = null)
    {
        // validation for constraint: string
        if (!is_null($vendorCarType) && !is_string($vendorCarType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorCarType, true), gettype($vendorCarType)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-zA-Z]{1,8})
        if (!is_null($vendorCarType) && !preg_match('/[0-9a-zA-Z]{1,8}/', $vendorCarType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-zA-Z]{1,8}', var_export($vendorCarType, true)), __LINE__);
        }
        $this->VendorCarType = $vendorCarType;
        return $this;
    }
    /**
     * Get OdometerUnitOfMeasure value
     * @return string|null
     */
    public function getOdometerUnitOfMeasure()
    {
        return $this->OdometerUnitOfMeasure;
    }
    /**
     * Set OdometerUnitOfMeasure value
     * @uses \EnumType\DistanceUnitNameType::valueIsValid()
     * @uses \EnumType\DistanceUnitNameType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $odometerUnitOfMeasure
     * @return \StructType\VehicleType
     */
    public function setOdometerUnitOfMeasure($odometerUnitOfMeasure = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DistanceUnitNameType::valueIsValid($odometerUnitOfMeasure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DistanceUnitNameType', is_array($odometerUnitOfMeasure) ? implode(', ', $odometerUnitOfMeasure) : var_export($odometerUnitOfMeasure, true), implode(', ', \EnumType\DistanceUnitNameType::getValidValues())), __LINE__);
        }
        $this->OdometerUnitOfMeasure = $odometerUnitOfMeasure;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\VehicleType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($code) && mb_strlen($code) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($code)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($code) && mb_strlen($code) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get CodeContext value
     * @return string|null
     */
    public function getCodeContext()
    {
        return $this->CodeContext;
    }
    /**
     * Set CodeContext value
     * @param string $codeContext
     * @return \StructType\VehicleType
     */
    public function setCodeContext($codeContext = null)
    {
        // validation for constraint: string
        if (!is_null($codeContext) && !is_string($codeContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeContext, true), gettype($codeContext)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($codeContext) && mb_strlen($codeContext) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($codeContext)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($codeContext) && mb_strlen($codeContext) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($codeContext)), __LINE__);
        }
        $this->CodeContext = $codeContext;
        return $this;
    }
    /**
     * Get UnitOfMeasureQuantity value
     * @return float|null
     */
    public function getUnitOfMeasureQuantity()
    {
        return $this->UnitOfMeasureQuantity;
    }
    /**
     * Set UnitOfMeasureQuantity value
     * @param float $unitOfMeasureQuantity
     * @return \StructType\VehicleType
     */
    public function setUnitOfMeasureQuantity($unitOfMeasureQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($unitOfMeasureQuantity) && !(is_float($unitOfMeasureQuantity) || is_numeric($unitOfMeasureQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unitOfMeasureQuantity, true), gettype($unitOfMeasureQuantity)), __LINE__);
        }
        $this->UnitOfMeasureQuantity = $unitOfMeasureQuantity;
        return $this;
    }
    /**
     * Get UnitOfMeasure value
     * @return string|null
     */
    public function getUnitOfMeasure()
    {
        return $this->UnitOfMeasure;
    }
    /**
     * Set UnitOfMeasure value
     * @param string $unitOfMeasure
     * @return \StructType\VehicleType
     */
    public function setUnitOfMeasure($unitOfMeasure = null)
    {
        // validation for constraint: string
        if (!is_null($unitOfMeasure) && !is_string($unitOfMeasure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitOfMeasure, true), gettype($unitOfMeasure)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($unitOfMeasure) && mb_strlen($unitOfMeasure) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($unitOfMeasure)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($unitOfMeasure) && mb_strlen($unitOfMeasure) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($unitOfMeasure)), __LINE__);
        }
        $this->UnitOfMeasure = $unitOfMeasure;
        return $this;
    }
    /**
     * Get UnitOfMeasureCode value
     * @return string|null
     */
    public function getUnitOfMeasureCode()
    {
        return $this->UnitOfMeasureCode;
    }
    /**
     * Set UnitOfMeasureCode value
     * @param string $unitOfMeasureCode
     * @return \StructType\VehicleType
     */
    public function setUnitOfMeasureCode($unitOfMeasureCode = null)
    {
        // validation for constraint: string
        if (!is_null($unitOfMeasureCode) && !is_string($unitOfMeasureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitOfMeasureCode, true), gettype($unitOfMeasureCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($unitOfMeasureCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $unitOfMeasureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($unitOfMeasureCode, true)), __LINE__);
        }
        $this->UnitOfMeasureCode = $unitOfMeasureCode;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * This method is responsible for validating the value passed to the setStart method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStart method
     * This is a set of validation rules based on the union types associated to the property being set by the setStart method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStartForUnionConstraintsFromSetStart($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime, time. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\VehicleType
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        // validation for constraint: union(date, dateTime, time)
        if ('' !== ($startUnionErrorMessage = self::validateStartForUnionConstraintsFromSetStart($start))) {
            throw new \InvalidArgumentException($startUnionErrorMessage, __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * This method is responsible for validating the value passed to the setDuration method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDuration method
     * This is a set of validation rules based on the union types associated to the property being set by the setDuration method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDurationForUnionConstraintsFromSetDuration($value)
    {
        $message = '';
        // validation for constraint: pattern(P[0-9]{1,3}N)
        if (!is_null($value) && !preg_match('/P[0-9]{1,3}N/', $value)) {
            $exception0 = new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression P[0-9]{1,3}N', var_export($value, true)), __LINE__);
        }
        if (isset($exception0)) {
            $message = sprintf("The value %s does not match any of the union rules: duration, NightDurationType. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [$exception0])));
        }
        unset($exception0);
        return $message;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\VehicleType
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        // validation for constraint: union(duration, NightDurationType)
        if ('' !== ($durationUnionErrorMessage = self::validateDurationForUnionConstraintsFromSetDuration($duration))) {
            throw new \InvalidArgumentException($durationUnionErrorMessage, __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * This method is responsible for validating the value passed to the setEnd method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEnd method
     * This is a set of validation rules based on the union types associated to the property being set by the setEnd method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEndForUnionConstraintsFromSetEnd($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime, time. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\VehicleType
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        // validation for constraint: union(date, dateTime, time)
        if ('' !== ($endUnionErrorMessage = self::validateEndForUnionConstraintsFromSetEnd($end))) {
            throw new \InvalidArgumentException($endUnionErrorMessage, __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
