<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleTourInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: The VehicleTourInfoType provides information about a tour that includes a vehicle rental.
 * @subpackage Structs
 */
class VehicleTourInfoType extends AbstractStructBase
{
    /**
     * The TourOperator
     * Meta information extracted from the WSDL
     * - documentation: This identifies the tour operator.
     * - minOccurs: 0
     * @var \StructType\CompanyNameType
     */
    public $TourOperator;
    /**
     * The TourNumber
     * Meta information extracted from the WSDL
     * - documentation: This is the identifying code assigned by the tour operating company to the tour that includes the vehicle rental. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $TourNumber;
    /**
     * Constructor method for VehicleTourInfoType
     * @uses VehicleTourInfoType::setTourOperator()
     * @uses VehicleTourInfoType::setTourNumber()
     * @param \StructType\CompanyNameType $tourOperator
     * @param string $tourNumber
     */
    public function __construct(\StructType\CompanyNameType $tourOperator = null, $tourNumber = null)
    {
        $this
            ->setTourOperator($tourOperator)
            ->setTourNumber($tourNumber);
    }
    /**
     * Get TourOperator value
     * @return \StructType\CompanyNameType|null
     */
    public function getTourOperator()
    {
        return $this->TourOperator;
    }
    /**
     * Set TourOperator value
     * @param \StructType\CompanyNameType $tourOperator
     * @return \StructType\VehicleTourInfoType
     */
    public function setTourOperator(\StructType\CompanyNameType $tourOperator = null)
    {
        $this->TourOperator = $tourOperator;
        return $this;
    }
    /**
     * Get TourNumber value
     * @return string|null
     */
    public function getTourNumber()
    {
        return $this->TourNumber;
    }
    /**
     * Set TourNumber value
     * @param string $tourNumber
     * @return \StructType\VehicleTourInfoType
     */
    public function setTourNumber($tourNumber = null)
    {
        // validation for constraint: string
        if (!is_null($tourNumber) && !is_string($tourNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tourNumber, true), gettype($tourNumber)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($tourNumber) && mb_strlen($tourNumber) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($tourNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($tourNumber) && mb_strlen($tourNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($tourNumber)), __LINE__);
        }
        $this->TourNumber = $tourNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleTourInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
