<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleReservationSummaryType StructType
 * Meta information extracted from the WSDL
 * - documentation: Information about the creation and last modification of the reservation. | The VehicleReservationSummaryType complextype identifies the summary data that identifies a reservation. Use of one or more of the elements will help in
 * identifying a specific reservation.
 * @subpackage Structs
 */
class VehicleReservationSummaryType extends AbstractStructBase
{
    /**
     * The ConfID
     * Meta information extracted from the WSDL
     * - maxOccurs: 4
     * @var \StructType\ConfID[]
     */
    public $ConfID;
    /**
     * The PickUpLocation
     * Meta information extracted from the WSDL
     * - documentation: A code to identify the pick up location, along with an optional code context.
     * - minOccurs: 0
     * @var \StructType\LocationType
     */
    public $PickUpLocation;
    /**
     * The ReturnLocation
     * Meta information extracted from the WSDL
     * - documentation: A code to identify the return location, along with an optional code context.
     * - minOccurs: 0
     * @var \StructType\LocationType
     */
    public $ReturnLocation;
    /**
     * The PersonName
     * Meta information extracted from the WSDL
     * - documentation: Name of the person associated with the reservation
     * - minOccurs: 0
     * @var \StructType\PersonNameType
     */
    public $PersonName;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - documentation: Information about a vehicle that has been reserved, such as the class and type.
     * - minOccurs: 0
     * @var \StructType\VehicleType
     */
    public $Vehicle;
    /**
     * The Vendor
     * Meta information extracted from the WSDL
     * - documentation: Identifies the vendor associated with this information.
     * - minOccurs: 0
     * @var \StructType\CompanyNameType
     */
    public $Vendor;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var \StructType\TPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The PickUpDateTime
     * Meta information extracted from the WSDL
     * - documentation: The PickUpDateTime attribute provides information on the pickup date and time.
     * - use: optional
     * @var string
     */
    public $PickUpDateTime;
    /**
     * The ReturnDateTime
     * Meta information extracted from the WSDL
     * - documentation: The ReturnDateTime attribute provides information on the return date and time.
     * - use: optional
     * @var string
     */
    public $ReturnDateTime;
    /**
     * The ReservationStatus
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ReservationStatus;
    /**
     * The CreateDateTime
     * @var string
     */
    public $CreateDateTime;
    /**
     * The CreatorID
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $CreatorID;
    /**
     * The LastModifyDateTime
     * @var string
     */
    public $LastModifyDateTime;
    /**
     * The LastModifierID
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $LastModifierID;
    /**
     * The PurgeDate
     * @var string
     */
    public $PurgeDate;
    /**
     * Constructor method for VehicleReservationSummaryType
     * @uses VehicleReservationSummaryType::setConfID()
     * @uses VehicleReservationSummaryType::setPickUpLocation()
     * @uses VehicleReservationSummaryType::setReturnLocation()
     * @uses VehicleReservationSummaryType::setPersonName()
     * @uses VehicleReservationSummaryType::setVehicle()
     * @uses VehicleReservationSummaryType::setVendor()
     * @uses VehicleReservationSummaryType::setTPA_Extensions()
     * @uses VehicleReservationSummaryType::setPickUpDateTime()
     * @uses VehicleReservationSummaryType::setReturnDateTime()
     * @uses VehicleReservationSummaryType::setReservationStatus()
     * @uses VehicleReservationSummaryType::setCreateDateTime()
     * @uses VehicleReservationSummaryType::setCreatorID()
     * @uses VehicleReservationSummaryType::setLastModifyDateTime()
     * @uses VehicleReservationSummaryType::setLastModifierID()
     * @uses VehicleReservationSummaryType::setPurgeDate()
     * @param \StructType\ConfID[] $confID
     * @param \StructType\LocationType $pickUpLocation
     * @param \StructType\LocationType $returnLocation
     * @param \StructType\PersonNameType $personName
     * @param \StructType\VehicleType $vehicle
     * @param \StructType\CompanyNameType $vendor
     * @param \StructType\TPA_ExtensionsType $tPA_Extensions
     * @param string $pickUpDateTime
     * @param string $returnDateTime
     * @param string $reservationStatus
     * @param string $createDateTime
     * @param string $creatorID
     * @param string $lastModifyDateTime
     * @param string $lastModifierID
     * @param string $purgeDate
     */
    public function __construct(array $confID = array(), \StructType\LocationType $pickUpLocation = null, \StructType\LocationType $returnLocation = null, \StructType\PersonNameType $personName = null, \StructType\VehicleType $vehicle = null, \StructType\CompanyNameType $vendor = null, \StructType\TPA_ExtensionsType $tPA_Extensions = null, $pickUpDateTime = null, $returnDateTime = null, $reservationStatus = null, $createDateTime = null, $creatorID = null, $lastModifyDateTime = null, $lastModifierID = null, $purgeDate = null)
    {
        $this
            ->setConfID($confID)
            ->setPickUpLocation($pickUpLocation)
            ->setReturnLocation($returnLocation)
            ->setPersonName($personName)
            ->setVehicle($vehicle)
            ->setVendor($vendor)
            ->setTPA_Extensions($tPA_Extensions)
            ->setPickUpDateTime($pickUpDateTime)
            ->setReturnDateTime($returnDateTime)
            ->setReservationStatus($reservationStatus)
            ->setCreateDateTime($createDateTime)
            ->setCreatorID($creatorID)
            ->setLastModifyDateTime($lastModifyDateTime)
            ->setLastModifierID($lastModifierID)
            ->setPurgeDate($purgeDate);
    }
    /**
     * Get ConfID value
     * @return \StructType\ConfID[]|null
     */
    public function getConfID()
    {
        return $this->ConfID;
    }
    /**
     * This method is responsible for validating the values passed to the setConfID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConfID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConfIDForArrayConstraintsFromSetConfID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleReservationSummaryTypeConfIDItem) {
            // validation for constraint: itemType
            if (!$vehicleReservationSummaryTypeConfIDItem instanceof \StructType\ConfID) {
                $invalidValues[] = is_object($vehicleReservationSummaryTypeConfIDItem) ? get_class($vehicleReservationSummaryTypeConfIDItem) : sprintf('%s(%s)', gettype($vehicleReservationSummaryTypeConfIDItem), var_export($vehicleReservationSummaryTypeConfIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ConfID property can only contain items of type \StructType\ConfID, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ConfID value
     * @throws \InvalidArgumentException
     * @param \StructType\ConfID[] $confID
     * @return \StructType\VehicleReservationSummaryType
     */
    public function setConfID(array $confID = array())
    {
        // validation for constraint: array
        if ('' !== ($confIDArrayErrorMessage = self::validateConfIDForArrayConstraintsFromSetConfID($confID))) {
            throw new \InvalidArgumentException($confIDArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($confID) && count($confID) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 4', count($confID)), __LINE__);
        }
        $this->ConfID = $confID;
        return $this;
    }
    /**
     * Add item to ConfID value
     * @throws \InvalidArgumentException
     * @param \StructType\ConfID $item
     * @return \StructType\VehicleReservationSummaryType
     */
    public function addToConfID(\StructType\ConfID $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ConfID) {
            throw new \InvalidArgumentException(sprintf('The ConfID property can only contain items of type \StructType\ConfID, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($this->ConfID) && count($this->ConfID) >= 4) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 4', count($this->ConfID)), __LINE__);
        }
        $this->ConfID[] = $item;
        return $this;
    }
    /**
     * Get PickUpLocation value
     * @return \StructType\LocationType|null
     */
    public function getPickUpLocation()
    {
        return $this->PickUpLocation;
    }
    /**
     * Set PickUpLocation value
     * @param \StructType\LocationType $pickUpLocation
     * @return \StructType\VehicleReservationSummaryType
     */
    public function setPickUpLocation(\StructType\LocationType $pickUpLocation = null)
    {
        $this->PickUpLocation = $pickUpLocation;
        return $this;
    }
    /**
     * Get ReturnLocation value
     * @return \StructType\LocationType|null
     */
    public function getReturnLocation()
    {
        return $this->ReturnLocation;
    }
    /**
     * Set ReturnLocation value
     * @param \StructType\LocationType $returnLocation
     * @return \StructType\VehicleReservationSummaryType
     */
    public function setReturnLocation(\StructType\LocationType $returnLocation = null)
    {
        $this->ReturnLocation = $returnLocation;
        return $this;
    }
    /**
     * Get PersonName value
     * @return \StructType\PersonNameType|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \StructType\PersonNameType $personName
     * @return \StructType\VehicleReservationSummaryType
     */
    public function setPersonName(\StructType\PersonNameType $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\VehicleType|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\VehicleType $vehicle
     * @return \StructType\VehicleReservationSummaryType
     */
    public function setVehicle(\StructType\VehicleType $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Vendor value
     * @return \StructType\CompanyNameType|null
     */
    public function getVendor()
    {
        return $this->Vendor;
    }
    /**
     * Set Vendor value
     * @param \StructType\CompanyNameType $vendor
     * @return \StructType\VehicleReservationSummaryType
     */
    public function setVendor(\StructType\CompanyNameType $vendor = null)
    {
        $this->Vendor = $vendor;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \StructType\TPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \StructType\TPA_ExtensionsType $tPA_Extensions
     * @return \StructType\VehicleReservationSummaryType
     */
    public function setTPA_Extensions(\StructType\TPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get PickUpDateTime value
     * @return string|null
     */
    public function getPickUpDateTime()
    {
        return $this->PickUpDateTime;
    }
    /**
     * Set PickUpDateTime value
     * @param string $pickUpDateTime
     * @return \StructType\VehicleReservationSummaryType
     */
    public function setPickUpDateTime($pickUpDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($pickUpDateTime) && !is_string($pickUpDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickUpDateTime, true), gettype($pickUpDateTime)), __LINE__);
        }
        $this->PickUpDateTime = $pickUpDateTime;
        return $this;
    }
    /**
     * Get ReturnDateTime value
     * @return string|null
     */
    public function getReturnDateTime()
    {
        return $this->ReturnDateTime;
    }
    /**
     * Set ReturnDateTime value
     * @param string $returnDateTime
     * @return \StructType\VehicleReservationSummaryType
     */
    public function setReturnDateTime($returnDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($returnDateTime) && !is_string($returnDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnDateTime, true), gettype($returnDateTime)), __LINE__);
        }
        $this->ReturnDateTime = $returnDateTime;
        return $this;
    }
    /**
     * Get ReservationStatus value
     * @return string|null
     */
    public function getReservationStatus()
    {
        return $this->ReservationStatus;
    }
    /**
     * Set ReservationStatus value
     * @param string $reservationStatus
     * @return \StructType\VehicleReservationSummaryType
     */
    public function setReservationStatus($reservationStatus = null)
    {
        // validation for constraint: string
        if (!is_null($reservationStatus) && !is_string($reservationStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationStatus, true), gettype($reservationStatus)), __LINE__);
        }
        $this->ReservationStatus = $reservationStatus;
        return $this;
    }
    /**
     * Get CreateDateTime value
     * @return string|null
     */
    public function getCreateDateTime()
    {
        return $this->CreateDateTime;
    }
    /**
     * Set CreateDateTime value
     * @param string $createDateTime
     * @return \StructType\VehicleReservationSummaryType
     */
    public function setCreateDateTime($createDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($createDateTime) && !is_string($createDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDateTime, true), gettype($createDateTime)), __LINE__);
        }
        $this->CreateDateTime = $createDateTime;
        return $this;
    }
    /**
     * Get CreatorID value
     * @return string|null
     */
    public function getCreatorID()
    {
        return $this->CreatorID;
    }
    /**
     * Set CreatorID value
     * @param string $creatorID
     * @return \StructType\VehicleReservationSummaryType
     */
    public function setCreatorID($creatorID = null)
    {
        // validation for constraint: string
        if (!is_null($creatorID) && !is_string($creatorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creatorID, true), gettype($creatorID)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($creatorID) && mb_strlen($creatorID) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($creatorID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($creatorID) && mb_strlen($creatorID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($creatorID)), __LINE__);
        }
        $this->CreatorID = $creatorID;
        return $this;
    }
    /**
     * Get LastModifyDateTime value
     * @return string|null
     */
    public function getLastModifyDateTime()
    {
        return $this->LastModifyDateTime;
    }
    /**
     * Set LastModifyDateTime value
     * @param string $lastModifyDateTime
     * @return \StructType\VehicleReservationSummaryType
     */
    public function setLastModifyDateTime($lastModifyDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifyDateTime) && !is_string($lastModifyDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifyDateTime, true), gettype($lastModifyDateTime)), __LINE__);
        }
        $this->LastModifyDateTime = $lastModifyDateTime;
        return $this;
    }
    /**
     * Get LastModifierID value
     * @return string|null
     */
    public function getLastModifierID()
    {
        return $this->LastModifierID;
    }
    /**
     * Set LastModifierID value
     * @param string $lastModifierID
     * @return \StructType\VehicleReservationSummaryType
     */
    public function setLastModifierID($lastModifierID = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifierID) && !is_string($lastModifierID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifierID, true), gettype($lastModifierID)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($lastModifierID) && mb_strlen($lastModifierID) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($lastModifierID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($lastModifierID) && mb_strlen($lastModifierID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($lastModifierID)), __LINE__);
        }
        $this->LastModifierID = $lastModifierID;
        return $this;
    }
    /**
     * Get PurgeDate value
     * @return string|null
     */
    public function getPurgeDate()
    {
        return $this->PurgeDate;
    }
    /**
     * Set PurgeDate value
     * @param string $purgeDate
     * @return \StructType\VehicleReservationSummaryType
     */
    public function setPurgeDate($purgeDate = null)
    {
        // validation for constraint: string
        if (!is_null($purgeDate) && !is_string($purgeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purgeDate, true), gettype($purgeDate)), __LINE__);
        }
        $this->PurgeDate = $purgeDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleReservationSummaryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
