<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleReservationRQCoreType StructType
 * Meta information extracted from the WSDL
 * - documentation: The VehicleReservationRQCoreType complex type identifies the core, or common, information that is typically included when requesting the reservation of avehicle.
 * @subpackage Structs
 */
class VehicleReservationRQCoreType extends AbstractStructBase
{
    /**
     * The UniqueID
     * Meta information extracted from the WSDL
     * - documentation: A unique identifier by which to reference the reservation. This is typically referred to as a reservation number.
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\UniqueID_Type[]
     */
    public $UniqueID;
    /**
     * The VehRentalCore
     * Meta information extracted from the WSDL
     * - documentation: Information that is common, or core, to all requests and responses associated with the reservation of a vehicle.
     * - minOccurs: 0
     * @var \StructType\VehicleRentalCoreType
     */
    public $VehRentalCore;
    /**
     * The Customer
     * Meta information extracted from the WSDL
     * - documentation: Information on the one primary driver and, optionally, several additional drivers. This may be used to provide a frequent renter number.
     * - minOccurs: 0
     * @var \StructType\CustomerPrimaryAdditionalType
     */
    public $Customer;
    /**
     * The VendorPref
     * Meta information extracted from the WSDL
     * - documentation: Indicates the preferred Vendor Company for car rental. If a company name is supplied, the rates will be supplied for the specific Vendor Company. The company name is unique amongst the vendors. The name of the company is provided in
     * this element.
     * - minOccurs: 0
     * @var \StructType\CompanyNamePrefType
     */
    public $VendorPref;
    /**
     * The VehPref
     * Meta information extracted from the WSDL
     * - documentation: Indicates any preferences for the vehicle, such as type, class, transmission, air conditioning.
     * - minOccurs: 0
     * @var \StructType\VehiclePrefType
     */
    public $VehPref;
    /**
     * The DriverType
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\DriverType[]
     */
    public $DriverType;
    /**
     * The RateQualifier
     * Meta information extracted from the WSDL
     * - documentation: Indicates the type of rates to be booked, along with any discount number or promotional codes that may affect the rate.
     * - minOccurs: 0
     * @var \StructType\RateQualifierType
     */
    public $RateQualifier;
    /**
     * The Fees
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Fees
     */
    public $Fees;
    /**
     * The VehicleCharges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VehicleCharges
     */
    public $VehicleCharges;
    /**
     * The SpecialEquipPrefs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SpecialEquipPrefs
     */
    public $SpecialEquipPrefs;
    /**
     * The RateDistance
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\RateDistance[]
     */
    public $RateDistance;
    /**
     * The TotalCharge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TotalCharge
     */
    public $TotalCharge;
    /**
     * The Queue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Queue
     */
    public $Queue;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var \StructType\TPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Status;
    /**
     * Constructor method for VehicleReservationRQCoreType
     * @uses VehicleReservationRQCoreType::setUniqueID()
     * @uses VehicleReservationRQCoreType::setVehRentalCore()
     * @uses VehicleReservationRQCoreType::setCustomer()
     * @uses VehicleReservationRQCoreType::setVendorPref()
     * @uses VehicleReservationRQCoreType::setVehPref()
     * @uses VehicleReservationRQCoreType::setDriverType()
     * @uses VehicleReservationRQCoreType::setRateQualifier()
     * @uses VehicleReservationRQCoreType::setFees()
     * @uses VehicleReservationRQCoreType::setVehicleCharges()
     * @uses VehicleReservationRQCoreType::setSpecialEquipPrefs()
     * @uses VehicleReservationRQCoreType::setRateDistance()
     * @uses VehicleReservationRQCoreType::setTotalCharge()
     * @uses VehicleReservationRQCoreType::setQueue()
     * @uses VehicleReservationRQCoreType::setTPA_Extensions()
     * @uses VehicleReservationRQCoreType::setStatus()
     * @param \StructType\UniqueID_Type[] $uniqueID
     * @param \StructType\VehicleRentalCoreType $vehRentalCore
     * @param \StructType\CustomerPrimaryAdditionalType $customer
     * @param \StructType\CompanyNamePrefType $vendorPref
     * @param \StructType\VehiclePrefType $vehPref
     * @param \StructType\DriverType[] $driverType
     * @param \StructType\RateQualifierType $rateQualifier
     * @param \StructType\Fees $fees
     * @param \StructType\VehicleCharges $vehicleCharges
     * @param \StructType\SpecialEquipPrefs $specialEquipPrefs
     * @param \StructType\RateDistance[] $rateDistance
     * @param \StructType\TotalCharge $totalCharge
     * @param \StructType\Queue $queue
     * @param \StructType\TPA_ExtensionsType $tPA_Extensions
     * @param string $status
     */
    public function __construct(array $uniqueID = array(), \StructType\VehicleRentalCoreType $vehRentalCore = null, \StructType\CustomerPrimaryAdditionalType $customer = null, \StructType\CompanyNamePrefType $vendorPref = null, \StructType\VehiclePrefType $vehPref = null, array $driverType = array(), \StructType\RateQualifierType $rateQualifier = null, \StructType\Fees $fees = null, \StructType\VehicleCharges $vehicleCharges = null, \StructType\SpecialEquipPrefs $specialEquipPrefs = null, array $rateDistance = array(), \StructType\TotalCharge $totalCharge = null, \StructType\Queue $queue = null, \StructType\TPA_ExtensionsType $tPA_Extensions = null, $status = null)
    {
        $this
            ->setUniqueID($uniqueID)
            ->setVehRentalCore($vehRentalCore)
            ->setCustomer($customer)
            ->setVendorPref($vendorPref)
            ->setVehPref($vehPref)
            ->setDriverType($driverType)
            ->setRateQualifier($rateQualifier)
            ->setFees($fees)
            ->setVehicleCharges($vehicleCharges)
            ->setSpecialEquipPrefs($specialEquipPrefs)
            ->setRateDistance($rateDistance)
            ->setTotalCharge($totalCharge)
            ->setQueue($queue)
            ->setTPA_Extensions($tPA_Extensions)
            ->setStatus($status);
    }
    /**
     * Get UniqueID value
     * @return \StructType\UniqueID_Type[]|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * This method is responsible for validating the values passed to the setUniqueID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUniqueID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUniqueIDForArrayConstraintsFromSetUniqueID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleReservationRQCoreTypeUniqueIDItem) {
            // validation for constraint: itemType
            if (!$vehicleReservationRQCoreTypeUniqueIDItem instanceof \StructType\UniqueID_Type) {
                $invalidValues[] = is_object($vehicleReservationRQCoreTypeUniqueIDItem) ? get_class($vehicleReservationRQCoreTypeUniqueIDItem) : sprintf('%s(%s)', gettype($vehicleReservationRQCoreTypeUniqueIDItem), var_export($vehicleReservationRQCoreTypeUniqueIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UniqueID property can only contain items of type \StructType\UniqueID_Type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UniqueID value
     * @throws \InvalidArgumentException
     * @param \StructType\UniqueID_Type[] $uniqueID
     * @return \StructType\VehicleReservationRQCoreType
     */
    public function setUniqueID(array $uniqueID = array())
    {
        // validation for constraint: array
        if ('' !== ($uniqueIDArrayErrorMessage = self::validateUniqueIDForArrayConstraintsFromSetUniqueID($uniqueID))) {
            throw new \InvalidArgumentException($uniqueIDArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($uniqueID) && count($uniqueID) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($uniqueID)), __LINE__);
        }
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Add item to UniqueID value
     * @throws \InvalidArgumentException
     * @param \StructType\UniqueID_Type $item
     * @return \StructType\VehicleReservationRQCoreType
     */
    public function addToUniqueID(\StructType\UniqueID_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UniqueID_Type) {
            throw new \InvalidArgumentException(sprintf('The UniqueID property can only contain items of type \StructType\UniqueID_Type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->UniqueID) && count($this->UniqueID) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->UniqueID)), __LINE__);
        }
        $this->UniqueID[] = $item;
        return $this;
    }
    /**
     * Get VehRentalCore value
     * @return \StructType\VehicleRentalCoreType|null
     */
    public function getVehRentalCore()
    {
        return $this->VehRentalCore;
    }
    /**
     * Set VehRentalCore value
     * @param \StructType\VehicleRentalCoreType $vehRentalCore
     * @return \StructType\VehicleReservationRQCoreType
     */
    public function setVehRentalCore(\StructType\VehicleRentalCoreType $vehRentalCore = null)
    {
        $this->VehRentalCore = $vehRentalCore;
        return $this;
    }
    /**
     * Get Customer value
     * @return \StructType\CustomerPrimaryAdditionalType|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \StructType\CustomerPrimaryAdditionalType $customer
     * @return \StructType\VehicleReservationRQCoreType
     */
    public function setCustomer(\StructType\CustomerPrimaryAdditionalType $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get VendorPref value
     * @return \StructType\CompanyNamePrefType|null
     */
    public function getVendorPref()
    {
        return $this->VendorPref;
    }
    /**
     * Set VendorPref value
     * @param \StructType\CompanyNamePrefType $vendorPref
     * @return \StructType\VehicleReservationRQCoreType
     */
    public function setVendorPref(\StructType\CompanyNamePrefType $vendorPref = null)
    {
        $this->VendorPref = $vendorPref;
        return $this;
    }
    /**
     * Get VehPref value
     * @return \StructType\VehiclePrefType|null
     */
    public function getVehPref()
    {
        return $this->VehPref;
    }
    /**
     * Set VehPref value
     * @param \StructType\VehiclePrefType $vehPref
     * @return \StructType\VehicleReservationRQCoreType
     */
    public function setVehPref(\StructType\VehiclePrefType $vehPref = null)
    {
        $this->VehPref = $vehPref;
        return $this;
    }
    /**
     * Get DriverType value
     * @return \StructType\DriverType[]|null
     */
    public function getDriverType()
    {
        return $this->DriverType;
    }
    /**
     * This method is responsible for validating the values passed to the setDriverType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDriverType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDriverTypeForArrayConstraintsFromSetDriverType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleReservationRQCoreTypeDriverTypeItem) {
            // validation for constraint: itemType
            if (!$vehicleReservationRQCoreTypeDriverTypeItem instanceof \StructType\DriverType) {
                $invalidValues[] = is_object($vehicleReservationRQCoreTypeDriverTypeItem) ? get_class($vehicleReservationRQCoreTypeDriverTypeItem) : sprintf('%s(%s)', gettype($vehicleReservationRQCoreTypeDriverTypeItem), var_export($vehicleReservationRQCoreTypeDriverTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DriverType property can only contain items of type \StructType\DriverType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DriverType value
     * @throws \InvalidArgumentException
     * @param \StructType\DriverType[] $driverType
     * @return \StructType\VehicleReservationRQCoreType
     */
    public function setDriverType(array $driverType = array())
    {
        // validation for constraint: array
        if ('' !== ($driverTypeArrayErrorMessage = self::validateDriverTypeForArrayConstraintsFromSetDriverType($driverType))) {
            throw new \InvalidArgumentException($driverTypeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($driverType) && count($driverType) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($driverType)), __LINE__);
        }
        $this->DriverType = $driverType;
        return $this;
    }
    /**
     * Add item to DriverType value
     * @throws \InvalidArgumentException
     * @param \StructType\DriverType $item
     * @return \StructType\VehicleReservationRQCoreType
     */
    public function addToDriverType(\StructType\DriverType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DriverType) {
            throw new \InvalidArgumentException(sprintf('The DriverType property can only contain items of type \StructType\DriverType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->DriverType) && count($this->DriverType) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->DriverType)), __LINE__);
        }
        $this->DriverType[] = $item;
        return $this;
    }
    /**
     * Get RateQualifier value
     * @return \StructType\RateQualifierType|null
     */
    public function getRateQualifier()
    {
        return $this->RateQualifier;
    }
    /**
     * Set RateQualifier value
     * @param \StructType\RateQualifierType $rateQualifier
     * @return \StructType\VehicleReservationRQCoreType
     */
    public function setRateQualifier(\StructType\RateQualifierType $rateQualifier = null)
    {
        $this->RateQualifier = $rateQualifier;
        return $this;
    }
    /**
     * Get Fees value
     * @return \StructType\Fees|null
     */
    public function getFees()
    {
        return $this->Fees;
    }
    /**
     * Set Fees value
     * @param \StructType\Fees $fees
     * @return \StructType\VehicleReservationRQCoreType
     */
    public function setFees(\StructType\Fees $fees = null)
    {
        $this->Fees = $fees;
        return $this;
    }
    /**
     * Get VehicleCharges value
     * @return \StructType\VehicleCharges|null
     */
    public function getVehicleCharges()
    {
        return $this->VehicleCharges;
    }
    /**
     * Set VehicleCharges value
     * @param \StructType\VehicleCharges $vehicleCharges
     * @return \StructType\VehicleReservationRQCoreType
     */
    public function setVehicleCharges(\StructType\VehicleCharges $vehicleCharges = null)
    {
        $this->VehicleCharges = $vehicleCharges;
        return $this;
    }
    /**
     * Get SpecialEquipPrefs value
     * @return \StructType\SpecialEquipPrefs|null
     */
    public function getSpecialEquipPrefs()
    {
        return $this->SpecialEquipPrefs;
    }
    /**
     * Set SpecialEquipPrefs value
     * @param \StructType\SpecialEquipPrefs $specialEquipPrefs
     * @return \StructType\VehicleReservationRQCoreType
     */
    public function setSpecialEquipPrefs(\StructType\SpecialEquipPrefs $specialEquipPrefs = null)
    {
        $this->SpecialEquipPrefs = $specialEquipPrefs;
        return $this;
    }
    /**
     * Get RateDistance value
     * @return \StructType\RateDistance[]|null
     */
    public function getRateDistance()
    {
        return $this->RateDistance;
    }
    /**
     * This method is responsible for validating the values passed to the setRateDistance method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRateDistance method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRateDistanceForArrayConstraintsFromSetRateDistance(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleReservationRQCoreTypeRateDistanceItem) {
            // validation for constraint: itemType
            if (!$vehicleReservationRQCoreTypeRateDistanceItem instanceof \StructType\RateDistance) {
                $invalidValues[] = is_object($vehicleReservationRQCoreTypeRateDistanceItem) ? get_class($vehicleReservationRQCoreTypeRateDistanceItem) : sprintf('%s(%s)', gettype($vehicleReservationRQCoreTypeRateDistanceItem), var_export($vehicleReservationRQCoreTypeRateDistanceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RateDistance property can only contain items of type \StructType\RateDistance, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RateDistance value
     * @throws \InvalidArgumentException
     * @param \StructType\RateDistance[] $rateDistance
     * @return \StructType\VehicleReservationRQCoreType
     */
    public function setRateDistance(array $rateDistance = array())
    {
        // validation for constraint: array
        if ('' !== ($rateDistanceArrayErrorMessage = self::validateRateDistanceForArrayConstraintsFromSetRateDistance($rateDistance))) {
            throw new \InvalidArgumentException($rateDistanceArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($rateDistance) && count($rateDistance) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($rateDistance)), __LINE__);
        }
        $this->RateDistance = $rateDistance;
        return $this;
    }
    /**
     * Add item to RateDistance value
     * @throws \InvalidArgumentException
     * @param \StructType\RateDistance $item
     * @return \StructType\VehicleReservationRQCoreType
     */
    public function addToRateDistance(\StructType\RateDistance $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RateDistance) {
            throw new \InvalidArgumentException(sprintf('The RateDistance property can only contain items of type \StructType\RateDistance, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->RateDistance) && count($this->RateDistance) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->RateDistance)), __LINE__);
        }
        $this->RateDistance[] = $item;
        return $this;
    }
    /**
     * Get TotalCharge value
     * @return \StructType\TotalCharge|null
     */
    public function getTotalCharge()
    {
        return $this->TotalCharge;
    }
    /**
     * Set TotalCharge value
     * @param \StructType\TotalCharge $totalCharge
     * @return \StructType\VehicleReservationRQCoreType
     */
    public function setTotalCharge(\StructType\TotalCharge $totalCharge = null)
    {
        $this->TotalCharge = $totalCharge;
        return $this;
    }
    /**
     * Get Queue value
     * @return \StructType\Queue|null
     */
    public function getQueue()
    {
        return $this->Queue;
    }
    /**
     * Set Queue value
     * @param \StructType\Queue $queue
     * @return \StructType\VehicleReservationRQCoreType
     */
    public function setQueue(\StructType\Queue $queue = null)
    {
        $this->Queue = $queue;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \StructType\TPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \StructType\TPA_ExtensionsType $tPA_Extensions
     * @return \StructType\VehicleReservationRQCoreType
     */
    public function setTPA_Extensions(\StructType\TPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\VehicleReservationRQCoreType
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleReservationRQCoreType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
