<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleRentalRateType StructType
 * Meta information extracted from the WSDL
 * - documentation: This describes time, mileage and other charges.
 * @subpackage Structs
 */
class VehicleRentalRateType extends AbstractStructBase
{
    /**
     * The RateDistance
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\RateDistance[]
     */
    public $RateDistance;
    /**
     * The VehicleCharges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VehicleCharges
     */
    public $VehicleCharges;
    /**
     * The RateQualifier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RateQualifier
     */
    public $RateQualifier;
    /**
     * The RateRestrictions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RateRestrictions
     */
    public $RateRestrictions;
    /**
     * The RateGuarantee
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RateGuarantee
     */
    public $RateGuarantee;
    /**
     * The PickupReturnRule
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\PickupReturnRule[]
     */
    public $PickupReturnRule;
    /**
     * The QuoteID
     * Meta information extracted from the WSDL
     * - documentation: A reference string used to match a query, with rates, to a given time. This is useful for matching prices within a given quote period. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $QuoteID;
    /**
     * Constructor method for VehicleRentalRateType
     * @uses VehicleRentalRateType::setRateDistance()
     * @uses VehicleRentalRateType::setVehicleCharges()
     * @uses VehicleRentalRateType::setRateQualifier()
     * @uses VehicleRentalRateType::setRateRestrictions()
     * @uses VehicleRentalRateType::setRateGuarantee()
     * @uses VehicleRentalRateType::setPickupReturnRule()
     * @uses VehicleRentalRateType::setQuoteID()
     * @param \StructType\RateDistance[] $rateDistance
     * @param \StructType\VehicleCharges $vehicleCharges
     * @param \StructType\RateQualifier $rateQualifier
     * @param \StructType\RateRestrictions $rateRestrictions
     * @param \StructType\RateGuarantee $rateGuarantee
     * @param \StructType\PickupReturnRule[] $pickupReturnRule
     * @param string $quoteID
     */
    public function __construct(array $rateDistance = array(), \StructType\VehicleCharges $vehicleCharges = null, \StructType\RateQualifier $rateQualifier = null, \StructType\RateRestrictions $rateRestrictions = null, \StructType\RateGuarantee $rateGuarantee = null, array $pickupReturnRule = array(), $quoteID = null)
    {
        $this
            ->setRateDistance($rateDistance)
            ->setVehicleCharges($vehicleCharges)
            ->setRateQualifier($rateQualifier)
            ->setRateRestrictions($rateRestrictions)
            ->setRateGuarantee($rateGuarantee)
            ->setPickupReturnRule($pickupReturnRule)
            ->setQuoteID($quoteID);
    }
    /**
     * Get RateDistance value
     * @return \StructType\RateDistance[]|null
     */
    public function getRateDistance()
    {
        return $this->RateDistance;
    }
    /**
     * This method is responsible for validating the values passed to the setRateDistance method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRateDistance method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRateDistanceForArrayConstraintsFromSetRateDistance(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleRentalRateTypeRateDistanceItem) {
            // validation for constraint: itemType
            if (!$vehicleRentalRateTypeRateDistanceItem instanceof \StructType\RateDistance) {
                $invalidValues[] = is_object($vehicleRentalRateTypeRateDistanceItem) ? get_class($vehicleRentalRateTypeRateDistanceItem) : sprintf('%s(%s)', gettype($vehicleRentalRateTypeRateDistanceItem), var_export($vehicleRentalRateTypeRateDistanceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RateDistance property can only contain items of type \StructType\RateDistance, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RateDistance value
     * @throws \InvalidArgumentException
     * @param \StructType\RateDistance[] $rateDistance
     * @return \StructType\VehicleRentalRateType
     */
    public function setRateDistance(array $rateDistance = array())
    {
        // validation for constraint: array
        if ('' !== ($rateDistanceArrayErrorMessage = self::validateRateDistanceForArrayConstraintsFromSetRateDistance($rateDistance))) {
            throw new \InvalidArgumentException($rateDistanceArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($rateDistance) && count($rateDistance) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($rateDistance)), __LINE__);
        }
        $this->RateDistance = $rateDistance;
        return $this;
    }
    /**
     * Add item to RateDistance value
     * @throws \InvalidArgumentException
     * @param \StructType\RateDistance $item
     * @return \StructType\VehicleRentalRateType
     */
    public function addToRateDistance(\StructType\RateDistance $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RateDistance) {
            throw new \InvalidArgumentException(sprintf('The RateDistance property can only contain items of type \StructType\RateDistance, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->RateDistance) && count($this->RateDistance) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->RateDistance)), __LINE__);
        }
        $this->RateDistance[] = $item;
        return $this;
    }
    /**
     * Get VehicleCharges value
     * @return \StructType\VehicleCharges|null
     */
    public function getVehicleCharges()
    {
        return $this->VehicleCharges;
    }
    /**
     * Set VehicleCharges value
     * @param \StructType\VehicleCharges $vehicleCharges
     * @return \StructType\VehicleRentalRateType
     */
    public function setVehicleCharges(\StructType\VehicleCharges $vehicleCharges = null)
    {
        $this->VehicleCharges = $vehicleCharges;
        return $this;
    }
    /**
     * Get RateQualifier value
     * @return \StructType\RateQualifier|null
     */
    public function getRateQualifier()
    {
        return $this->RateQualifier;
    }
    /**
     * Set RateQualifier value
     * @param \StructType\RateQualifier $rateQualifier
     * @return \StructType\VehicleRentalRateType
     */
    public function setRateQualifier(\StructType\RateQualifier $rateQualifier = null)
    {
        $this->RateQualifier = $rateQualifier;
        return $this;
    }
    /**
     * Get RateRestrictions value
     * @return \StructType\RateRestrictions|null
     */
    public function getRateRestrictions()
    {
        return $this->RateRestrictions;
    }
    /**
     * Set RateRestrictions value
     * @param \StructType\RateRestrictions $rateRestrictions
     * @return \StructType\VehicleRentalRateType
     */
    public function setRateRestrictions(\StructType\RateRestrictions $rateRestrictions = null)
    {
        $this->RateRestrictions = $rateRestrictions;
        return $this;
    }
    /**
     * Get RateGuarantee value
     * @return \StructType\RateGuarantee|null
     */
    public function getRateGuarantee()
    {
        return $this->RateGuarantee;
    }
    /**
     * Set RateGuarantee value
     * @param \StructType\RateGuarantee $rateGuarantee
     * @return \StructType\VehicleRentalRateType
     */
    public function setRateGuarantee(\StructType\RateGuarantee $rateGuarantee = null)
    {
        $this->RateGuarantee = $rateGuarantee;
        return $this;
    }
    /**
     * Get PickupReturnRule value
     * @return \StructType\PickupReturnRule[]|null
     */
    public function getPickupReturnRule()
    {
        return $this->PickupReturnRule;
    }
    /**
     * This method is responsible for validating the values passed to the setPickupReturnRule method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPickupReturnRule method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePickupReturnRuleForArrayConstraintsFromSetPickupReturnRule(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleRentalRateTypePickupReturnRuleItem) {
            // validation for constraint: itemType
            if (!$vehicleRentalRateTypePickupReturnRuleItem instanceof \StructType\PickupReturnRule) {
                $invalidValues[] = is_object($vehicleRentalRateTypePickupReturnRuleItem) ? get_class($vehicleRentalRateTypePickupReturnRuleItem) : sprintf('%s(%s)', gettype($vehicleRentalRateTypePickupReturnRuleItem), var_export($vehicleRentalRateTypePickupReturnRuleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PickupReturnRule property can only contain items of type \StructType\PickupReturnRule, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PickupReturnRule value
     * @throws \InvalidArgumentException
     * @param \StructType\PickupReturnRule[] $pickupReturnRule
     * @return \StructType\VehicleRentalRateType
     */
    public function setPickupReturnRule(array $pickupReturnRule = array())
    {
        // validation for constraint: array
        if ('' !== ($pickupReturnRuleArrayErrorMessage = self::validatePickupReturnRuleForArrayConstraintsFromSetPickupReturnRule($pickupReturnRule))) {
            throw new \InvalidArgumentException($pickupReturnRuleArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($pickupReturnRule) && count($pickupReturnRule) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($pickupReturnRule)), __LINE__);
        }
        $this->PickupReturnRule = $pickupReturnRule;
        return $this;
    }
    /**
     * Add item to PickupReturnRule value
     * @throws \InvalidArgumentException
     * @param \StructType\PickupReturnRule $item
     * @return \StructType\VehicleRentalRateType
     */
    public function addToPickupReturnRule(\StructType\PickupReturnRule $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PickupReturnRule) {
            throw new \InvalidArgumentException(sprintf('The PickupReturnRule property can only contain items of type \StructType\PickupReturnRule, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->PickupReturnRule) && count($this->PickupReturnRule) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->PickupReturnRule)), __LINE__);
        }
        $this->PickupReturnRule[] = $item;
        return $this;
    }
    /**
     * Get QuoteID value
     * @return string|null
     */
    public function getQuoteID()
    {
        return $this->QuoteID;
    }
    /**
     * Set QuoteID value
     * @param string $quoteID
     * @return \StructType\VehicleRentalRateType
     */
    public function setQuoteID($quoteID = null)
    {
        // validation for constraint: string
        if (!is_null($quoteID) && !is_string($quoteID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quoteID, true), gettype($quoteID)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($quoteID) && mb_strlen($quoteID) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($quoteID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($quoteID) && mb_strlen($quoteID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($quoteID)), __LINE__);
        }
        $this->QuoteID = $quoteID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleRentalRateType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
