<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleProfileRentalPrefType StructType
 * Meta information extracted from the WSDL
 * - documentation: Vehicle rental preferences can be specified for customers or companies to indicate their preferences for types of vehicles to be rented in specific travel situations. Companies may wish to specify certain class or types of cars that
 * their employees are allowed to rent, or indicate special business needs for trucks for hauling goods, etc. Personal travelers may wish to indicate preferences for types of vehicles such as vans or SUVs for family vacations, or smaller, more sporty
 * models when travelling alone. A customer may prefer to have a convertible or sun roof in a warm destination, but request a ski rack when vacationing in the wintertime. The VehicleProfileRentalPrefType complex type has elements for specific features
 * on rental cars including vehicle type (major category such as car, truck, SUV) and vehicle class (more precise kind of vehicle), air conditioning, transmission, and special equipment. In addition, the specification captures preferences for vendors
 * and loyalty programs, insurance coverage, forms of payment for rental cars, and other special requirements.
 * @subpackage Structs
 */
class VehicleProfileRentalPrefType extends AbstractStructBase
{
    /**
     * The LoyaltyPref
     * Meta information extracted from the WSDL
     * - maxOccurs: 20
     * - minOccurs: 0
     * @var \StructType\LoyaltyPref[]
     */
    public $LoyaltyPref;
    /**
     * The VendorPref
     * Meta information extracted from the WSDL
     * - documentation: Vendor Preferences indicates a preference for a specific car rental agency when used in a travel collection. The VendorPref element uses the Company Name entity to identify the preferred company by name and by vendor code.
     * - maxOccurs: 20
     * - minOccurs: 0
     * @var \StructType\CompanyNamePrefType[]
     */
    public $VendorPref;
    /**
     * The PaymentFormPref
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \StructType\PaymentFormPref[]
     */
    public $PaymentFormPref;
    /**
     * The CoveragePref
     * Meta information extracted from the WSDL
     * - maxOccurs: 30
     * - minOccurs: 0
     * @var \StructType\CoveragePref[]
     */
    public $CoveragePref;
    /**
     * The SpecialReqPref
     * Meta information extracted from the WSDL
     * - documentation: The special request preference element allows the customer to designate a special request to be associated with the vehicle rental.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\VehicleSpecialReqPrefType[]
     */
    public $SpecialReqPref;
    /**
     * The VehTypePref
     * Meta information extracted from the WSDL
     * - documentation: The vehicle type preference element allows the customer to designate a major category of vehicle preferred for rental.
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \StructType\VehiclePrefType[]
     */
    public $VehTypePref;
    /**
     * The SpecialEquipPref
     * Meta information extracted from the WSDL
     * - maxOccurs: 15
     * - minOccurs: 0
     * @var \StructType\SpecialEquipPref[]
     */
    public $SpecialEquipPref;
    /**
     * The GasPrePay
     * Meta information extracted from the WSDL
     * - documentation: false | The GasPrePay attribute defines a set of valid values for the choice of prepaying for gas at the time of the pick up of the rental vehicle. This information is useful in that it allows a customer's preference to be made known
     * to the vendor. It also allows the vendor to provide more detailed and accurate pricing up front.
     * - use: optional
     * @var bool
     */
    public $GasPrePay;
    /**
     * The PreferLevel
     * @var string
     */
    public $PreferLevel;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The SmokingAllowed
     * @var bool
     */
    public $SmokingAllowed;
    /**
     * Constructor method for VehicleProfileRentalPrefType
     * @uses VehicleProfileRentalPrefType::setLoyaltyPref()
     * @uses VehicleProfileRentalPrefType::setVendorPref()
     * @uses VehicleProfileRentalPrefType::setPaymentFormPref()
     * @uses VehicleProfileRentalPrefType::setCoveragePref()
     * @uses VehicleProfileRentalPrefType::setSpecialReqPref()
     * @uses VehicleProfileRentalPrefType::setVehTypePref()
     * @uses VehicleProfileRentalPrefType::setSpecialEquipPref()
     * @uses VehicleProfileRentalPrefType::setGasPrePay()
     * @uses VehicleProfileRentalPrefType::setPreferLevel()
     * @uses VehicleProfileRentalPrefType::setShareSynchInd()
     * @uses VehicleProfileRentalPrefType::setShareMarketInd()
     * @uses VehicleProfileRentalPrefType::setSmokingAllowed()
     * @param \StructType\LoyaltyPref[] $loyaltyPref
     * @param \StructType\CompanyNamePrefType[] $vendorPref
     * @param \StructType\PaymentFormPref[] $paymentFormPref
     * @param \StructType\CoveragePref[] $coveragePref
     * @param \StructType\VehicleSpecialReqPrefType[] $specialReqPref
     * @param \StructType\VehiclePrefType[] $vehTypePref
     * @param \StructType\SpecialEquipPref[] $specialEquipPref
     * @param bool $gasPrePay
     * @param string $preferLevel
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param bool $smokingAllowed
     */
    public function __construct(array $loyaltyPref = array(), array $vendorPref = array(), array $paymentFormPref = array(), array $coveragePref = array(), array $specialReqPref = array(), array $vehTypePref = array(), array $specialEquipPref = array(), $gasPrePay = null, $preferLevel = null, $shareSynchInd = null, $shareMarketInd = null, $smokingAllowed = null)
    {
        $this
            ->setLoyaltyPref($loyaltyPref)
            ->setVendorPref($vendorPref)
            ->setPaymentFormPref($paymentFormPref)
            ->setCoveragePref($coveragePref)
            ->setSpecialReqPref($specialReqPref)
            ->setVehTypePref($vehTypePref)
            ->setSpecialEquipPref($specialEquipPref)
            ->setGasPrePay($gasPrePay)
            ->setPreferLevel($preferLevel)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setSmokingAllowed($smokingAllowed);
    }
    /**
     * Get LoyaltyPref value
     * @return \StructType\LoyaltyPref[]|null
     */
    public function getLoyaltyPref()
    {
        return $this->LoyaltyPref;
    }
    /**
     * This method is responsible for validating the values passed to the setLoyaltyPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLoyaltyPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLoyaltyPrefForArrayConstraintsFromSetLoyaltyPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleProfileRentalPrefTypeLoyaltyPrefItem) {
            // validation for constraint: itemType
            if (!$vehicleProfileRentalPrefTypeLoyaltyPrefItem instanceof \StructType\LoyaltyPref) {
                $invalidValues[] = is_object($vehicleProfileRentalPrefTypeLoyaltyPrefItem) ? get_class($vehicleProfileRentalPrefTypeLoyaltyPrefItem) : sprintf('%s(%s)', gettype($vehicleProfileRentalPrefTypeLoyaltyPrefItem), var_export($vehicleProfileRentalPrefTypeLoyaltyPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LoyaltyPref property can only contain items of type \StructType\LoyaltyPref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LoyaltyPref value
     * @throws \InvalidArgumentException
     * @param \StructType\LoyaltyPref[] $loyaltyPref
     * @return \StructType\VehicleProfileRentalPrefType
     */
    public function setLoyaltyPref(array $loyaltyPref = array())
    {
        // validation for constraint: array
        if ('' !== ($loyaltyPrefArrayErrorMessage = self::validateLoyaltyPrefForArrayConstraintsFromSetLoyaltyPref($loyaltyPref))) {
            throw new \InvalidArgumentException($loyaltyPrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(20)
        if (is_array($loyaltyPref) && count($loyaltyPref) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 20', count($loyaltyPref)), __LINE__);
        }
        $this->LoyaltyPref = $loyaltyPref;
        return $this;
    }
    /**
     * Add item to LoyaltyPref value
     * @throws \InvalidArgumentException
     * @param \StructType\LoyaltyPref $item
     * @return \StructType\VehicleProfileRentalPrefType
     */
    public function addToLoyaltyPref(\StructType\LoyaltyPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LoyaltyPref) {
            throw new \InvalidArgumentException(sprintf('The LoyaltyPref property can only contain items of type \StructType\LoyaltyPref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(20)
        if (is_array($this->LoyaltyPref) && count($this->LoyaltyPref) >= 20) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 20', count($this->LoyaltyPref)), __LINE__);
        }
        $this->LoyaltyPref[] = $item;
        return $this;
    }
    /**
     * Get VendorPref value
     * @return \StructType\CompanyNamePrefType[]|null
     */
    public function getVendorPref()
    {
        return $this->VendorPref;
    }
    /**
     * This method is responsible for validating the values passed to the setVendorPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVendorPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVendorPrefForArrayConstraintsFromSetVendorPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleProfileRentalPrefTypeVendorPrefItem) {
            // validation for constraint: itemType
            if (!$vehicleProfileRentalPrefTypeVendorPrefItem instanceof \StructType\CompanyNamePrefType) {
                $invalidValues[] = is_object($vehicleProfileRentalPrefTypeVendorPrefItem) ? get_class($vehicleProfileRentalPrefTypeVendorPrefItem) : sprintf('%s(%s)', gettype($vehicleProfileRentalPrefTypeVendorPrefItem), var_export($vehicleProfileRentalPrefTypeVendorPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VendorPref property can only contain items of type \StructType\CompanyNamePrefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VendorPref value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyNamePrefType[] $vendorPref
     * @return \StructType\VehicleProfileRentalPrefType
     */
    public function setVendorPref(array $vendorPref = array())
    {
        // validation for constraint: array
        if ('' !== ($vendorPrefArrayErrorMessage = self::validateVendorPrefForArrayConstraintsFromSetVendorPref($vendorPref))) {
            throw new \InvalidArgumentException($vendorPrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(20)
        if (is_array($vendorPref) && count($vendorPref) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 20', count($vendorPref)), __LINE__);
        }
        $this->VendorPref = $vendorPref;
        return $this;
    }
    /**
     * Add item to VendorPref value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyNamePrefType $item
     * @return \StructType\VehicleProfileRentalPrefType
     */
    public function addToVendorPref(\StructType\CompanyNamePrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CompanyNamePrefType) {
            throw new \InvalidArgumentException(sprintf('The VendorPref property can only contain items of type \StructType\CompanyNamePrefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(20)
        if (is_array($this->VendorPref) && count($this->VendorPref) >= 20) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 20', count($this->VendorPref)), __LINE__);
        }
        $this->VendorPref[] = $item;
        return $this;
    }
    /**
     * Get PaymentFormPref value
     * @return \StructType\PaymentFormPref[]|null
     */
    public function getPaymentFormPref()
    {
        return $this->PaymentFormPref;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentFormPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentFormPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentFormPrefForArrayConstraintsFromSetPaymentFormPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleProfileRentalPrefTypePaymentFormPrefItem) {
            // validation for constraint: itemType
            if (!$vehicleProfileRentalPrefTypePaymentFormPrefItem instanceof \StructType\PaymentFormPref) {
                $invalidValues[] = is_object($vehicleProfileRentalPrefTypePaymentFormPrefItem) ? get_class($vehicleProfileRentalPrefTypePaymentFormPrefItem) : sprintf('%s(%s)', gettype($vehicleProfileRentalPrefTypePaymentFormPrefItem), var_export($vehicleProfileRentalPrefTypePaymentFormPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentFormPref property can only contain items of type \StructType\PaymentFormPref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentFormPref value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentFormPref[] $paymentFormPref
     * @return \StructType\VehicleProfileRentalPrefType
     */
    public function setPaymentFormPref(array $paymentFormPref = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentFormPrefArrayErrorMessage = self::validatePaymentFormPrefForArrayConstraintsFromSetPaymentFormPref($paymentFormPref))) {
            throw new \InvalidArgumentException($paymentFormPrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($paymentFormPref) && count($paymentFormPref) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($paymentFormPref)), __LINE__);
        }
        $this->PaymentFormPref = $paymentFormPref;
        return $this;
    }
    /**
     * Add item to PaymentFormPref value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentFormPref $item
     * @return \StructType\VehicleProfileRentalPrefType
     */
    public function addToPaymentFormPref(\StructType\PaymentFormPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentFormPref) {
            throw new \InvalidArgumentException(sprintf('The PaymentFormPref property can only contain items of type \StructType\PaymentFormPref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->PaymentFormPref) && count($this->PaymentFormPref) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->PaymentFormPref)), __LINE__);
        }
        $this->PaymentFormPref[] = $item;
        return $this;
    }
    /**
     * Get CoveragePref value
     * @return \StructType\CoveragePref[]|null
     */
    public function getCoveragePref()
    {
        return $this->CoveragePref;
    }
    /**
     * This method is responsible for validating the values passed to the setCoveragePref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCoveragePref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCoveragePrefForArrayConstraintsFromSetCoveragePref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleProfileRentalPrefTypeCoveragePrefItem) {
            // validation for constraint: itemType
            if (!$vehicleProfileRentalPrefTypeCoveragePrefItem instanceof \StructType\CoveragePref) {
                $invalidValues[] = is_object($vehicleProfileRentalPrefTypeCoveragePrefItem) ? get_class($vehicleProfileRentalPrefTypeCoveragePrefItem) : sprintf('%s(%s)', gettype($vehicleProfileRentalPrefTypeCoveragePrefItem), var_export($vehicleProfileRentalPrefTypeCoveragePrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CoveragePref property can only contain items of type \StructType\CoveragePref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CoveragePref value
     * @throws \InvalidArgumentException
     * @param \StructType\CoveragePref[] $coveragePref
     * @return \StructType\VehicleProfileRentalPrefType
     */
    public function setCoveragePref(array $coveragePref = array())
    {
        // validation for constraint: array
        if ('' !== ($coveragePrefArrayErrorMessage = self::validateCoveragePrefForArrayConstraintsFromSetCoveragePref($coveragePref))) {
            throw new \InvalidArgumentException($coveragePrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($coveragePref) && count($coveragePref) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 30', count($coveragePref)), __LINE__);
        }
        $this->CoveragePref = $coveragePref;
        return $this;
    }
    /**
     * Add item to CoveragePref value
     * @throws \InvalidArgumentException
     * @param \StructType\CoveragePref $item
     * @return \StructType\VehicleProfileRentalPrefType
     */
    public function addToCoveragePref(\StructType\CoveragePref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CoveragePref) {
            throw new \InvalidArgumentException(sprintf('The CoveragePref property can only contain items of type \StructType\CoveragePref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($this->CoveragePref) && count($this->CoveragePref) >= 30) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 30', count($this->CoveragePref)), __LINE__);
        }
        $this->CoveragePref[] = $item;
        return $this;
    }
    /**
     * Get SpecialReqPref value
     * @return \StructType\VehicleSpecialReqPrefType[]|null
     */
    public function getSpecialReqPref()
    {
        return $this->SpecialReqPref;
    }
    /**
     * This method is responsible for validating the values passed to the setSpecialReqPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecialReqPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecialReqPrefForArrayConstraintsFromSetSpecialReqPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleProfileRentalPrefTypeSpecialReqPrefItem) {
            // validation for constraint: itemType
            if (!$vehicleProfileRentalPrefTypeSpecialReqPrefItem instanceof \StructType\VehicleSpecialReqPrefType) {
                $invalidValues[] = is_object($vehicleProfileRentalPrefTypeSpecialReqPrefItem) ? get_class($vehicleProfileRentalPrefTypeSpecialReqPrefItem) : sprintf('%s(%s)', gettype($vehicleProfileRentalPrefTypeSpecialReqPrefItem), var_export($vehicleProfileRentalPrefTypeSpecialReqPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SpecialReqPref property can only contain items of type \StructType\VehicleSpecialReqPrefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SpecialReqPref value
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleSpecialReqPrefType[] $specialReqPref
     * @return \StructType\VehicleProfileRentalPrefType
     */
    public function setSpecialReqPref(array $specialReqPref = array())
    {
        // validation for constraint: array
        if ('' !== ($specialReqPrefArrayErrorMessage = self::validateSpecialReqPrefForArrayConstraintsFromSetSpecialReqPref($specialReqPref))) {
            throw new \InvalidArgumentException($specialReqPrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($specialReqPref) && count($specialReqPref) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($specialReqPref)), __LINE__);
        }
        $this->SpecialReqPref = $specialReqPref;
        return $this;
    }
    /**
     * Add item to SpecialReqPref value
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleSpecialReqPrefType $item
     * @return \StructType\VehicleProfileRentalPrefType
     */
    public function addToSpecialReqPref(\StructType\VehicleSpecialReqPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VehicleSpecialReqPrefType) {
            throw new \InvalidArgumentException(sprintf('The SpecialReqPref property can only contain items of type \StructType\VehicleSpecialReqPrefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->SpecialReqPref) && count($this->SpecialReqPref) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->SpecialReqPref)), __LINE__);
        }
        $this->SpecialReqPref[] = $item;
        return $this;
    }
    /**
     * Get VehTypePref value
     * @return \StructType\VehiclePrefType[]|null
     */
    public function getVehTypePref()
    {
        return $this->VehTypePref;
    }
    /**
     * This method is responsible for validating the values passed to the setVehTypePref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVehTypePref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVehTypePrefForArrayConstraintsFromSetVehTypePref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleProfileRentalPrefTypeVehTypePrefItem) {
            // validation for constraint: itemType
            if (!$vehicleProfileRentalPrefTypeVehTypePrefItem instanceof \StructType\VehiclePrefType) {
                $invalidValues[] = is_object($vehicleProfileRentalPrefTypeVehTypePrefItem) ? get_class($vehicleProfileRentalPrefTypeVehTypePrefItem) : sprintf('%s(%s)', gettype($vehicleProfileRentalPrefTypeVehTypePrefItem), var_export($vehicleProfileRentalPrefTypeVehTypePrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VehTypePref property can only contain items of type \StructType\VehiclePrefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VehTypePref value
     * @throws \InvalidArgumentException
     * @param \StructType\VehiclePrefType[] $vehTypePref
     * @return \StructType\VehicleProfileRentalPrefType
     */
    public function setVehTypePref(array $vehTypePref = array())
    {
        // validation for constraint: array
        if ('' !== ($vehTypePrefArrayErrorMessage = self::validateVehTypePrefForArrayConstraintsFromSetVehTypePref($vehTypePref))) {
            throw new \InvalidArgumentException($vehTypePrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($vehTypePref) && count($vehTypePref) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($vehTypePref)), __LINE__);
        }
        $this->VehTypePref = $vehTypePref;
        return $this;
    }
    /**
     * Add item to VehTypePref value
     * @throws \InvalidArgumentException
     * @param \StructType\VehiclePrefType $item
     * @return \StructType\VehicleProfileRentalPrefType
     */
    public function addToVehTypePref(\StructType\VehiclePrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VehiclePrefType) {
            throw new \InvalidArgumentException(sprintf('The VehTypePref property can only contain items of type \StructType\VehiclePrefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->VehTypePref) && count($this->VehTypePref) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->VehTypePref)), __LINE__);
        }
        $this->VehTypePref[] = $item;
        return $this;
    }
    /**
     * Get SpecialEquipPref value
     * @return \StructType\SpecialEquipPref[]|null
     */
    public function getSpecialEquipPref()
    {
        return $this->SpecialEquipPref;
    }
    /**
     * This method is responsible for validating the values passed to the setSpecialEquipPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecialEquipPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecialEquipPrefForArrayConstraintsFromSetSpecialEquipPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleProfileRentalPrefTypeSpecialEquipPrefItem) {
            // validation for constraint: itemType
            if (!$vehicleProfileRentalPrefTypeSpecialEquipPrefItem instanceof \StructType\SpecialEquipPref) {
                $invalidValues[] = is_object($vehicleProfileRentalPrefTypeSpecialEquipPrefItem) ? get_class($vehicleProfileRentalPrefTypeSpecialEquipPrefItem) : sprintf('%s(%s)', gettype($vehicleProfileRentalPrefTypeSpecialEquipPrefItem), var_export($vehicleProfileRentalPrefTypeSpecialEquipPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SpecialEquipPref property can only contain items of type \StructType\SpecialEquipPref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SpecialEquipPref value
     * @throws \InvalidArgumentException
     * @param \StructType\SpecialEquipPref[] $specialEquipPref
     * @return \StructType\VehicleProfileRentalPrefType
     */
    public function setSpecialEquipPref(array $specialEquipPref = array())
    {
        // validation for constraint: array
        if ('' !== ($specialEquipPrefArrayErrorMessage = self::validateSpecialEquipPrefForArrayConstraintsFromSetSpecialEquipPref($specialEquipPref))) {
            throw new \InvalidArgumentException($specialEquipPrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(15)
        if (is_array($specialEquipPref) && count($specialEquipPref) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 15', count($specialEquipPref)), __LINE__);
        }
        $this->SpecialEquipPref = $specialEquipPref;
        return $this;
    }
    /**
     * Add item to SpecialEquipPref value
     * @throws \InvalidArgumentException
     * @param \StructType\SpecialEquipPref $item
     * @return \StructType\VehicleProfileRentalPrefType
     */
    public function addToSpecialEquipPref(\StructType\SpecialEquipPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SpecialEquipPref) {
            throw new \InvalidArgumentException(sprintf('The SpecialEquipPref property can only contain items of type \StructType\SpecialEquipPref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(15)
        if (is_array($this->SpecialEquipPref) && count($this->SpecialEquipPref) >= 15) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 15', count($this->SpecialEquipPref)), __LINE__);
        }
        $this->SpecialEquipPref[] = $item;
        return $this;
    }
    /**
     * Get GasPrePay value
     * @return bool|null
     */
    public function getGasPrePay()
    {
        return $this->GasPrePay;
    }
    /**
     * Set GasPrePay value
     * @param bool $gasPrePay
     * @return \StructType\VehicleProfileRentalPrefType
     */
    public function setGasPrePay($gasPrePay = null)
    {
        // validation for constraint: boolean
        if (!is_null($gasPrePay) && !is_bool($gasPrePay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($gasPrePay, true), gettype($gasPrePay)), __LINE__);
        }
        $this->GasPrePay = $gasPrePay;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \EnumType\PreferLevelType::valueIsValid()
     * @uses \EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \StructType\VehicleProfileRentalPrefType
     */
    public function setPreferLevel($preferLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PreferLevelType', is_array($preferLevel) ? implode(', ', $preferLevel) : var_export($preferLevel, true), implode(', ', \EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \StructType\VehicleProfileRentalPrefType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareSynchInd, true), gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \StructType\VehicleProfileRentalPrefType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareMarketInd, true), gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get SmokingAllowed value
     * @return bool|null
     */
    public function getSmokingAllowed()
    {
        return $this->SmokingAllowed;
    }
    /**
     * Set SmokingAllowed value
     * @param bool $smokingAllowed
     * @return \StructType\VehicleProfileRentalPrefType
     */
    public function setSmokingAllowed($smokingAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($smokingAllowed) && !is_bool($smokingAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($smokingAllowed, true), gettype($smokingAllowed)), __LINE__);
        }
        $this->SmokingAllowed = $smokingAllowed;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleProfileRentalPrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
