<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleEquipmentType StructType
 * Meta information extracted from the WSDL
 * - documentation: The VehicleEquipmentType complex type identifies the data that fully describes a piece of special equipment, including the description and any restrictions that may apply to its rental.
 * @subpackage Structs
 */
class VehicleEquipmentType extends AbstractStructBase
{
    /**
     * The EquipType
     * Meta information extracted from the WSDL
     * - documentation: Identifies the specific type of special equipment. Refer to OpenTravel Code List Equipment Type (EQP). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: required
     * @var string
     */
    public $EquipType;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Restriction
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Restriction;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - type: xs:positiveInteger
     * - use: optional
     * @var int
     */
    public $Quantity;
    /**
     * Constructor method for VehicleEquipmentType
     * @uses VehicleEquipmentType::setEquipType()
     * @uses VehicleEquipmentType::setDescription()
     * @uses VehicleEquipmentType::setRestriction()
     * @uses VehicleEquipmentType::setQuantity()
     * @param string $equipType
     * @param string $description
     * @param string $restriction
     * @param int $quantity
     */
    public function __construct($equipType = null, $description = null, $restriction = null, $quantity = null)
    {
        $this
            ->setEquipType($equipType)
            ->setDescription($description)
            ->setRestriction($restriction)
            ->setQuantity($quantity);
    }
    /**
     * Get EquipType value
     * @return string
     */
    public function getEquipType()
    {
        return $this->EquipType;
    }
    /**
     * Set EquipType value
     * @param string $equipType
     * @return \StructType\VehicleEquipmentType
     */
    public function setEquipType($equipType = null)
    {
        // validation for constraint: string
        if (!is_null($equipType) && !is_string($equipType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($equipType, true), gettype($equipType)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($equipType) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $equipType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($equipType, true)), __LINE__);
        }
        $this->EquipType = $equipType;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\VehicleEquipmentType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Restriction value
     * @return string|null
     */
    public function getRestriction()
    {
        return $this->Restriction;
    }
    /**
     * Set Restriction value
     * @uses \EnumType\EquipmentRestrictionType::valueIsValid()
     * @uses \EnumType\EquipmentRestrictionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $restriction
     * @return \StructType\VehicleEquipmentType
     */
    public function setRestriction($restriction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EquipmentRestrictionType::valueIsValid($restriction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EquipmentRestrictionType', is_array($restriction) ? implode(', ', $restriction) : var_export($restriction, true), implode(', ', \EnumType\EquipmentRestrictionType::getValidValues())), __LINE__);
        }
        $this->Restriction = $restriction;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\VehicleEquipmentType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleEquipmentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
