<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleCharges StructType
 * Meta information extracted from the WSDL
 * - documentation: Information on the charges associated with this vehicle. Such charges may include the base rental amount, additional mileage amounts, fuel costs, etc.
 * @subpackage Structs
 */
class VehicleCharges extends AbstractStructBase
{
    /**
     * The VehicleCharge
     * Meta information extracted from the WSDL
     * - documentation: Detailed information on one specific charge including an indication of the type of charge.
     * - maxOccurs: 99
     * @var \StructType\VehicleChargePurposeType[]
     */
    public $VehicleCharge;
    /**
     * Constructor method for VehicleCharges
     * @uses VehicleCharges::setVehicleCharge()
     * @param \StructType\VehicleChargePurposeType[] $vehicleCharge
     */
    public function __construct(array $vehicleCharge = array())
    {
        $this
            ->setVehicleCharge($vehicleCharge);
    }
    /**
     * Get VehicleCharge value
     * @return \StructType\VehicleChargePurposeType[]|null
     */
    public function getVehicleCharge()
    {
        return $this->VehicleCharge;
    }
    /**
     * This method is responsible for validating the values passed to the setVehicleCharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVehicleCharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVehicleChargeForArrayConstraintsFromSetVehicleCharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleChargesVehicleChargeItem) {
            // validation for constraint: itemType
            if (!$vehicleChargesVehicleChargeItem instanceof \StructType\VehicleChargePurposeType) {
                $invalidValues[] = is_object($vehicleChargesVehicleChargeItem) ? get_class($vehicleChargesVehicleChargeItem) : sprintf('%s(%s)', gettype($vehicleChargesVehicleChargeItem), var_export($vehicleChargesVehicleChargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VehicleCharge property can only contain items of type \StructType\VehicleChargePurposeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VehicleCharge value
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleChargePurposeType[] $vehicleCharge
     * @return \StructType\VehicleCharges
     */
    public function setVehicleCharge(array $vehicleCharge = array())
    {
        // validation for constraint: array
        if ('' !== ($vehicleChargeArrayErrorMessage = self::validateVehicleChargeForArrayConstraintsFromSetVehicleCharge($vehicleCharge))) {
            throw new \InvalidArgumentException($vehicleChargeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($vehicleCharge) && count($vehicleCharge) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($vehicleCharge)), __LINE__);
        }
        $this->VehicleCharge = $vehicleCharge;
        return $this;
    }
    /**
     * Add item to VehicleCharge value
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleChargePurposeType $item
     * @return \StructType\VehicleCharges
     */
    public function addToVehicleCharge(\StructType\VehicleChargePurposeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VehicleChargePurposeType) {
            throw new \InvalidArgumentException(sprintf('The VehicleCharge property can only contain items of type \StructType\VehicleChargePurposeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->VehicleCharge) && count($this->VehicleCharge) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->VehicleCharge)), __LINE__);
        }
        $this->VehicleCharge[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleCharges
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
