<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehRentLocInfos StructType
 * Meta information extracted from the WSDL
 * - documentation: Descriptive information allowing the vendor to present informational messages about the rental location. These may include after-hour return of vehicle messages, messages providing directions to the location, or other similar
 * messages.
 * @subpackage Structs
 */
class VehRentLocInfos extends AbstractStructBase
{
    /**
     * The VehRentLocInfo
     * Meta information extracted from the WSDL
     * - documentation: Descriptive information of one specific aspect of the rental location.
     * - maxOccurs: 99
     * @var \StructType\VehicleLocationInformationType[]
     */
    public $VehRentLocInfo;
    /**
     * Constructor method for VehRentLocInfos
     * @uses VehRentLocInfos::setVehRentLocInfo()
     * @param \StructType\VehicleLocationInformationType[] $vehRentLocInfo
     */
    public function __construct(array $vehRentLocInfo = array())
    {
        $this
            ->setVehRentLocInfo($vehRentLocInfo);
    }
    /**
     * Get VehRentLocInfo value
     * @return \StructType\VehicleLocationInformationType[]|null
     */
    public function getVehRentLocInfo()
    {
        return $this->VehRentLocInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setVehRentLocInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVehRentLocInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVehRentLocInfoForArrayConstraintsFromSetVehRentLocInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehRentLocInfosVehRentLocInfoItem) {
            // validation for constraint: itemType
            if (!$vehRentLocInfosVehRentLocInfoItem instanceof \StructType\VehicleLocationInformationType) {
                $invalidValues[] = is_object($vehRentLocInfosVehRentLocInfoItem) ? get_class($vehRentLocInfosVehRentLocInfoItem) : sprintf('%s(%s)', gettype($vehRentLocInfosVehRentLocInfoItem), var_export($vehRentLocInfosVehRentLocInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VehRentLocInfo property can only contain items of type \StructType\VehicleLocationInformationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VehRentLocInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleLocationInformationType[] $vehRentLocInfo
     * @return \StructType\VehRentLocInfos
     */
    public function setVehRentLocInfo(array $vehRentLocInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($vehRentLocInfoArrayErrorMessage = self::validateVehRentLocInfoForArrayConstraintsFromSetVehRentLocInfo($vehRentLocInfo))) {
            throw new \InvalidArgumentException($vehRentLocInfoArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($vehRentLocInfo) && count($vehRentLocInfo) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($vehRentLocInfo)), __LINE__);
        }
        $this->VehRentLocInfo = $vehRentLocInfo;
        return $this;
    }
    /**
     * Add item to VehRentLocInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleLocationInformationType $item
     * @return \StructType\VehRentLocInfos
     */
    public function addToVehRentLocInfo(\StructType\VehicleLocationInformationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VehicleLocationInformationType) {
            throw new \InvalidArgumentException(sprintf('The VehRentLocInfo property can only contain items of type \StructType\VehicleLocationInformationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->VehRentLocInfo) && count($this->VehRentLocInfo) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->VehRentLocInfo)), __LINE__);
        }
        $this->VehRentLocInfo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehRentLocInfos
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
