<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehIdentity StructType
 * Meta information extracted from the WSDL
 * - documentation: The specific identifiers of the vehicle (e.g., Motor Vehicle Asset Number).
 * @subpackage Structs
 */
class VehIdentity extends AbstractStructBase
{
    /**
     * The VehicleAssetNumber
     * Meta information extracted from the WSDL
     * - documentation: This is the number assigned by a rental car company to manage inventory, it is not the Vehicle Identification Number (VIN). | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - type: StringLength1to16
     * - use: optional
     * @var string
     */
    public $VehicleAssetNumber;
    /**
     * The LicensePlateNumber
     * Meta information extracted from the WSDL
     * - documentation: This is the license plate number of the vehicle rented. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - type: StringLength1to16
     * - use: optional
     * @var string
     */
    public $LicensePlateNumber;
    /**
     * The StateProvCode
     * Meta information extracted from the WSDL
     * - documentation: This identifies the standard code or abbreviation for the state, province, or region of vehicle registration. | Used for Character Strings, length 1 to 8. | The standard code or abbreviation for the state, province, or region.
     * - base: StringLength1to8
     * - maxLength: 8
     * - minLength: 2
     * - type: StateProvCodeType
     * - use: optional
     * @var string
     */
    public $StateProvCode;
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - documentation: This identifies the standard code or abbreviation for the country of vehicle registration. | Specifies a 2 character country code as defined in ISO3166.
     * - base: xs:string
     * - pattern: [a-zA-Z]{2}
     * - type: ISO3166
     * - use: optional
     * @var string
     */
    public $CountryCode;
    /**
     * The VehicleID_Number
     * Meta information extracted from the WSDL
     * - documentation: This is the manufacturers' assigned vehicle identification number (VIN). | Used for Character Strings, length 0 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 0
     * - type: StringLength0to32
     * - use: optional
     * @var string
     */
    public $VehicleID_Number;
    /**
     * The VehicleColor
     * Meta information extracted from the WSDL
     * - documentation: This is the color of the vehicle being rented. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - type: StringLength1to16
     * - use: optional
     * @var string
     */
    public $VehicleColor;
    /**
     * Constructor method for VehIdentity
     * @uses VehIdentity::setVehicleAssetNumber()
     * @uses VehIdentity::setLicensePlateNumber()
     * @uses VehIdentity::setStateProvCode()
     * @uses VehIdentity::setCountryCode()
     * @uses VehIdentity::setVehicleID_Number()
     * @uses VehIdentity::setVehicleColor()
     * @param string $vehicleAssetNumber
     * @param string $licensePlateNumber
     * @param string $stateProvCode
     * @param string $countryCode
     * @param string $vehicleID_Number
     * @param string $vehicleColor
     */
    public function __construct($vehicleAssetNumber = null, $licensePlateNumber = null, $stateProvCode = null, $countryCode = null, $vehicleID_Number = null, $vehicleColor = null)
    {
        $this
            ->setVehicleAssetNumber($vehicleAssetNumber)
            ->setLicensePlateNumber($licensePlateNumber)
            ->setStateProvCode($stateProvCode)
            ->setCountryCode($countryCode)
            ->setVehicleID_Number($vehicleID_Number)
            ->setVehicleColor($vehicleColor);
    }
    /**
     * Get VehicleAssetNumber value
     * @return string|null
     */
    public function getVehicleAssetNumber()
    {
        return $this->VehicleAssetNumber;
    }
    /**
     * Set VehicleAssetNumber value
     * @param string $vehicleAssetNumber
     * @return \StructType\VehIdentity
     */
    public function setVehicleAssetNumber($vehicleAssetNumber = null)
    {
        // validation for constraint: string
        if (!is_null($vehicleAssetNumber) && !is_string($vehicleAssetNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vehicleAssetNumber, true), gettype($vehicleAssetNumber)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($vehicleAssetNumber) && mb_strlen($vehicleAssetNumber) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($vehicleAssetNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($vehicleAssetNumber) && mb_strlen($vehicleAssetNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($vehicleAssetNumber)), __LINE__);
        }
        $this->VehicleAssetNumber = $vehicleAssetNumber;
        return $this;
    }
    /**
     * Get LicensePlateNumber value
     * @return string|null
     */
    public function getLicensePlateNumber()
    {
        return $this->LicensePlateNumber;
    }
    /**
     * Set LicensePlateNumber value
     * @param string $licensePlateNumber
     * @return \StructType\VehIdentity
     */
    public function setLicensePlateNumber($licensePlateNumber = null)
    {
        // validation for constraint: string
        if (!is_null($licensePlateNumber) && !is_string($licensePlateNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($licensePlateNumber, true), gettype($licensePlateNumber)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($licensePlateNumber) && mb_strlen($licensePlateNumber) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($licensePlateNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($licensePlateNumber) && mb_strlen($licensePlateNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($licensePlateNumber)), __LINE__);
        }
        $this->LicensePlateNumber = $licensePlateNumber;
        return $this;
    }
    /**
     * Get StateProvCode value
     * @return string|null
     */
    public function getStateProvCode()
    {
        return $this->StateProvCode;
    }
    /**
     * Set StateProvCode value
     * @param string $stateProvCode
     * @return \StructType\VehIdentity
     */
    public function setStateProvCode($stateProvCode = null)
    {
        // validation for constraint: string
        if (!is_null($stateProvCode) && !is_string($stateProvCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateProvCode, true), gettype($stateProvCode)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($stateProvCode) && mb_strlen($stateProvCode) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($stateProvCode)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($stateProvCode) && mb_strlen($stateProvCode) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($stateProvCode)), __LINE__);
        }
        $this->StateProvCode = $stateProvCode;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\VehIdentity
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{2})
        if (!is_null($countryCode) && !preg_match('/[a-zA-Z]{2}/', $countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{2}', var_export($countryCode, true)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get VehicleID_Number value
     * @return string|null
     */
    public function getVehicleID_Number()
    {
        return $this->VehicleID_Number;
    }
    /**
     * Set VehicleID_Number value
     * @param string $vehicleID_Number
     * @return \StructType\VehIdentity
     */
    public function setVehicleID_Number($vehicleID_Number = null)
    {
        // validation for constraint: string
        if (!is_null($vehicleID_Number) && !is_string($vehicleID_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vehicleID_Number, true), gettype($vehicleID_Number)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($vehicleID_Number) && mb_strlen($vehicleID_Number) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($vehicleID_Number)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($vehicleID_Number) && mb_strlen($vehicleID_Number) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($vehicleID_Number)), __LINE__);
        }
        $this->VehicleID_Number = $vehicleID_Number;
        return $this;
    }
    /**
     * Get VehicleColor value
     * @return string|null
     */
    public function getVehicleColor()
    {
        return $this->VehicleColor;
    }
    /**
     * Set VehicleColor value
     * @param string $vehicleColor
     * @return \StructType\VehIdentity
     */
    public function setVehicleColor($vehicleColor = null)
    {
        // validation for constraint: string
        if (!is_null($vehicleColor) && !is_string($vehicleColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vehicleColor, true), gettype($vehicleColor)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($vehicleColor) && mb_strlen($vehicleColor) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($vehicleColor)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($vehicleColor) && mb_strlen($vehicleColor) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($vehicleColor)), __LINE__);
        }
        $this->VehicleColor = $vehicleColor;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehIdentity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
