<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnstructuredFareCalc StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains the fare calc information for the stored fare for the passenger.
 * @subpackage Structs
 */
class UnstructuredFareCalc extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The FareCalcMode
     * Meta information extracted from the WSDL
     * - documentation: Used to identify the method of pricing for this transaction (e.g., manual, automated pricing). Should be 1 character in length. | Used for Alpha-Numeric Strings, length 1.
     * - base: xs:string
     * - pattern: [0-9a-zA-Z]{1}
     * - use: optional
     * @var string
     */
    public $FareCalcMode;
    /**
     * The Operation
     * Meta information extracted from the WSDL
     * - documentation: Indicates the required modification to the element.
     * - use: optional
     * @var string
     */
    public $Operation;
    /**
     * Constructor method for UnstructuredFareCalc
     * @uses UnstructuredFareCalc::set_()
     * @uses UnstructuredFareCalc::setFareCalcMode()
     * @uses UnstructuredFareCalc::setOperation()
     * @param string $_
     * @param string $fareCalcMode
     * @param string $operation
     */
    public function __construct($_ = null, $fareCalcMode = null, $operation = null)
    {
        $this
            ->set_($_)
            ->setFareCalcMode($fareCalcMode)
            ->setOperation($operation);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\UnstructuredFareCalc
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get FareCalcMode value
     * @return string|null
     */
    public function getFareCalcMode()
    {
        return $this->FareCalcMode;
    }
    /**
     * Set FareCalcMode value
     * @param string $fareCalcMode
     * @return \StructType\UnstructuredFareCalc
     */
    public function setFareCalcMode($fareCalcMode = null)
    {
        // validation for constraint: string
        if (!is_null($fareCalcMode) && !is_string($fareCalcMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareCalcMode, true), gettype($fareCalcMode)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-zA-Z]{1})
        if (!is_null($fareCalcMode) && !preg_match('/[0-9a-zA-Z]{1}/', $fareCalcMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-zA-Z]{1}', var_export($fareCalcMode, true)), __LINE__);
        }
        $this->FareCalcMode = $fareCalcMode;
        return $this;
    }
    /**
     * Get Operation value
     * @return string|null
     */
    public function getOperation()
    {
        return $this->Operation;
    }
    /**
     * Set Operation value
     * @uses \EnumType\ActionType::valueIsValid()
     * @uses \EnumType\ActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operation
     * @return \StructType\UnstructuredFareCalc
     */
    public function setOperation($operation = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionType::valueIsValid($operation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ActionType', is_array($operation) ? implode(', ', $operation) : var_export($operation, true), implode(', ', \EnumType\ActionType::getValidValues())), __LINE__);
        }
        $this->Operation = $operation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UnstructuredFareCalc
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
