<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TravelerRPHs StructType
 * Meta information extracted from the WSDL
 * - documentation: A container to relate individual travelers to an inventory or chargeable item.
 * @subpackage Structs
 */
class TravelerRPHs extends AbstractStructBase
{
    /**
     * The TravelerRPH
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\TravelerRPH[]
     */
    public $TravelerRPH;
    /**
     * Constructor method for TravelerRPHs
     * @uses TravelerRPHs::setTravelerRPH()
     * @param \StructType\TravelerRPH[] $travelerRPH
     */
    public function __construct(array $travelerRPH = array())
    {
        $this
            ->setTravelerRPH($travelerRPH);
    }
    /**
     * Get TravelerRPH value
     * @return \StructType\TravelerRPH[]|null
     */
    public function getTravelerRPH()
    {
        return $this->TravelerRPH;
    }
    /**
     * This method is responsible for validating the values passed to the setTravelerRPH method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTravelerRPH method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTravelerRPHForArrayConstraintsFromSetTravelerRPH(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $travelerRPHsTravelerRPHItem) {
            // validation for constraint: itemType
            if (!$travelerRPHsTravelerRPHItem instanceof \StructType\TravelerRPH) {
                $invalidValues[] = is_object($travelerRPHsTravelerRPHItem) ? get_class($travelerRPHsTravelerRPHItem) : sprintf('%s(%s)', gettype($travelerRPHsTravelerRPHItem), var_export($travelerRPHsTravelerRPHItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TravelerRPH property can only contain items of type \StructType\TravelerRPH, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TravelerRPH value
     * @throws \InvalidArgumentException
     * @param \StructType\TravelerRPH[] $travelerRPH
     * @return \StructType\TravelerRPHs
     */
    public function setTravelerRPH(array $travelerRPH = array())
    {
        // validation for constraint: array
        if ('' !== ($travelerRPHArrayErrorMessage = self::validateTravelerRPHForArrayConstraintsFromSetTravelerRPH($travelerRPH))) {
            throw new \InvalidArgumentException($travelerRPHArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($travelerRPH) && count($travelerRPH) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($travelerRPH)), __LINE__);
        }
        $this->TravelerRPH = $travelerRPH;
        return $this;
    }
    /**
     * Add item to TravelerRPH value
     * @throws \InvalidArgumentException
     * @param \StructType\TravelerRPH $item
     * @return \StructType\TravelerRPHs
     */
    public function addToTravelerRPH(\StructType\TravelerRPH $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TravelerRPH) {
            throw new \InvalidArgumentException(sprintf('The TravelerRPH property can only contain items of type \StructType\TravelerRPH, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->TravelerRPH) && count($this->TravelerRPH) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->TravelerRPH)), __LINE__);
        }
        $this->TravelerRPH[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TravelerRPHs
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
