<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TravelDateTimeType StructType
 * Meta information extracted from the WSDL
 * - documentation: Date and time of trip that allows specifying a time window before and after the given date.
 * @subpackage Structs
 */
class TravelDateTimeType extends AbstractStructBase
{
    /**
     * The DepartureDateTime
     * Meta information extracted from the WSDL
     * - documentation: The departure date and optionally a time period that can be applied before and/or after the departure date.
     * - choice: DepartureDateTime | ArrivalDateTime
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\TimeInstantType
     */
    public $DepartureDateTime;
    /**
     * The ArrivalDateTime
     * Meta information extracted from the WSDL
     * - documentation: The arrival date and optionally a time period that can be applied before and/or after the arrival date.
     * - choice: DepartureDateTime | ArrivalDateTime
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\TimeInstantType
     */
    public $ArrivalDateTime;
    /**
     * Constructor method for TravelDateTimeType
     * @uses TravelDateTimeType::setDepartureDateTime()
     * @uses TravelDateTimeType::setArrivalDateTime()
     * @param \StructType\TimeInstantType $departureDateTime
     * @param \StructType\TimeInstantType $arrivalDateTime
     */
    public function __construct(\StructType\TimeInstantType $departureDateTime = null, \StructType\TimeInstantType $arrivalDateTime = null)
    {
        $this
            ->setDepartureDateTime($departureDateTime)
            ->setArrivalDateTime($arrivalDateTime);
    }
    /**
     * Get DepartureDateTime value
     * @return \StructType\TimeInstantType|null
     */
    public function getDepartureDateTime()
    {
        return isset($this->DepartureDateTime) ? $this->DepartureDateTime : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDepartureDateTime method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDepartureDateTime method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDepartureDateTimeForChoiceConstraintsFromSetDepartureDateTime($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ArrivalDateTime',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property DepartureDateTime can\'t be set as the property %s is already set. Only one property must be set among these properties: DepartureDateTime, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set DepartureDateTime value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TimeInstantType $departureDateTime
     * @return \StructType\TravelDateTimeType
     */
    public function setDepartureDateTime(\StructType\TimeInstantType $departureDateTime = null)
    {
        // validation for constraint: choice(DepartureDateTime, ArrivalDateTime)
        if ('' !== ($departureDateTimeChoiceErrorMessage = self::validateDepartureDateTimeForChoiceConstraintsFromSetDepartureDateTime($departureDateTime))) {
            throw new \InvalidArgumentException($departureDateTimeChoiceErrorMessage, __LINE__);
        }
        if (is_null($departureDateTime) || (is_array($departureDateTime) && empty($departureDateTime))) {
            unset($this->DepartureDateTime);
        } else {
            $this->DepartureDateTime = $departureDateTime;
        }
        return $this;
    }
    /**
     * Get ArrivalDateTime value
     * @return \StructType\TimeInstantType|null
     */
    public function getArrivalDateTime()
    {
        return isset($this->ArrivalDateTime) ? $this->ArrivalDateTime : null;
    }
    /**
     * This method is responsible for validating the value passed to the setArrivalDateTime method
     * This method is willingly generated in order to preserve the one-line inline validation within the setArrivalDateTime method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateArrivalDateTimeForChoiceConstraintsFromSetArrivalDateTime($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'DepartureDateTime',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ArrivalDateTime can\'t be set as the property %s is already set. Only one property must be set among these properties: ArrivalDateTime, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ArrivalDateTime value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TimeInstantType $arrivalDateTime
     * @return \StructType\TravelDateTimeType
     */
    public function setArrivalDateTime(\StructType\TimeInstantType $arrivalDateTime = null)
    {
        // validation for constraint: choice(DepartureDateTime, ArrivalDateTime)
        if ('' !== ($arrivalDateTimeChoiceErrorMessage = self::validateArrivalDateTimeForChoiceConstraintsFromSetArrivalDateTime($arrivalDateTime))) {
            throw new \InvalidArgumentException($arrivalDateTimeChoiceErrorMessage, __LINE__);
        }
        if (is_null($arrivalDateTime) || (is_array($arrivalDateTime) && empty($arrivalDateTime))) {
            unset($this->ArrivalDateTime);
        } else {
            $this->ArrivalDateTime = $arrivalDateTime;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TravelDateTimeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
