<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TourCodePref StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides the contract code for a negotiated fare.
 * @subpackage Structs
 */
class TourCodePref extends AbstractStructBase
{
    /**
     * The TourCodeInfo
     * Meta information extracted from the WSDL
     * - choice: TourCodeInfo | StaffTourCodeInfo
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\TourCodeInfo
     */
    public $TourCodeInfo;
    /**
     * The StaffTourCodeInfo
     * Meta information extracted from the WSDL
     * - choice: TourCodeInfo | StaffTourCodeInfo
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\StaffTourCodeInfo
     */
    public $StaffTourCodeInfo;
    /**
     * The PassengerTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Code used to indicate the type of traveler (e.g., ADT, CHD, INF, GRP). | Used for an Alpha String, length exactly 3.
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * - use: optional
     * @var string
     */
    public $PassengerTypeCode;
    /**
     * The AirlineVendorPrefRPH
     * Meta information extracted from the WSDL
     * - documentation: Reference to one or more airlines in AirlinePrefType/VendorPref. | The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign individual passengers or clients to
     * particular itinerary items). | List of Reference Place Holders.
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string[]
     */
    public $AirlineVendorPrefRPH;
    /**
     * The TransferAction
     * Meta information extracted from the WSDL
     * - documentation: Indicates under what conditions this element will be transfered to the booking.
     * - use: optional
     * @var string
     */
    public $TransferAction;
    /**
     * Constructor method for TourCodePref
     * @uses TourCodePref::setTourCodeInfo()
     * @uses TourCodePref::setStaffTourCodeInfo()
     * @uses TourCodePref::setPassengerTypeCode()
     * @uses TourCodePref::setAirlineVendorPrefRPH()
     * @uses TourCodePref::setTransferAction()
     * @param \StructType\TourCodeInfo $tourCodeInfo
     * @param \StructType\StaffTourCodeInfo $staffTourCodeInfo
     * @param string $passengerTypeCode
     * @param string[] $airlineVendorPrefRPH
     * @param string $transferAction
     */
    public function __construct(\StructType\TourCodeInfo $tourCodeInfo = null, \StructType\StaffTourCodeInfo $staffTourCodeInfo = null, $passengerTypeCode = null, array $airlineVendorPrefRPH = array(), $transferAction = null)
    {
        $this
            ->setTourCodeInfo($tourCodeInfo)
            ->setStaffTourCodeInfo($staffTourCodeInfo)
            ->setPassengerTypeCode($passengerTypeCode)
            ->setAirlineVendorPrefRPH($airlineVendorPrefRPH)
            ->setTransferAction($transferAction);
    }
    /**
     * Get TourCodeInfo value
     * @return \StructType\TourCodeInfo|null
     */
    public function getTourCodeInfo()
    {
        return isset($this->TourCodeInfo) ? $this->TourCodeInfo : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTourCodeInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTourCodeInfo method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTourCodeInfoForChoiceConstraintsFromSetTourCodeInfo($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'StaffTourCodeInfo',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property TourCodeInfo can\'t be set as the property %s is already set. Only one property must be set among these properties: TourCodeInfo, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set TourCodeInfo value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TourCodeInfo $tourCodeInfo
     * @return \StructType\TourCodePref
     */
    public function setTourCodeInfo(\StructType\TourCodeInfo $tourCodeInfo = null)
    {
        // validation for constraint: choice(TourCodeInfo, StaffTourCodeInfo)
        if ('' !== ($tourCodeInfoChoiceErrorMessage = self::validateTourCodeInfoForChoiceConstraintsFromSetTourCodeInfo($tourCodeInfo))) {
            throw new \InvalidArgumentException($tourCodeInfoChoiceErrorMessage, __LINE__);
        }
        if (is_null($tourCodeInfo) || (is_array($tourCodeInfo) && empty($tourCodeInfo))) {
            unset($this->TourCodeInfo);
        } else {
            $this->TourCodeInfo = $tourCodeInfo;
        }
        return $this;
    }
    /**
     * Get StaffTourCodeInfo value
     * @return \StructType\StaffTourCodeInfo|null
     */
    public function getStaffTourCodeInfo()
    {
        return isset($this->StaffTourCodeInfo) ? $this->StaffTourCodeInfo : null;
    }
    /**
     * This method is responsible for validating the value passed to the setStaffTourCodeInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStaffTourCodeInfo method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateStaffTourCodeInfoForChoiceConstraintsFromSetStaffTourCodeInfo($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'TourCodeInfo',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property StaffTourCodeInfo can\'t be set as the property %s is already set. Only one property must be set among these properties: StaffTourCodeInfo, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set StaffTourCodeInfo value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\StaffTourCodeInfo $staffTourCodeInfo
     * @return \StructType\TourCodePref
     */
    public function setStaffTourCodeInfo(\StructType\StaffTourCodeInfo $staffTourCodeInfo = null)
    {
        // validation for constraint: choice(TourCodeInfo, StaffTourCodeInfo)
        if ('' !== ($staffTourCodeInfoChoiceErrorMessage = self::validateStaffTourCodeInfoForChoiceConstraintsFromSetStaffTourCodeInfo($staffTourCodeInfo))) {
            throw new \InvalidArgumentException($staffTourCodeInfoChoiceErrorMessage, __LINE__);
        }
        if (is_null($staffTourCodeInfo) || (is_array($staffTourCodeInfo) && empty($staffTourCodeInfo))) {
            unset($this->StaffTourCodeInfo);
        } else {
            $this->StaffTourCodeInfo = $staffTourCodeInfo;
        }
        return $this;
    }
    /**
     * Get PassengerTypeCode value
     * @return string|null
     */
    public function getPassengerTypeCode()
    {
        return $this->PassengerTypeCode;
    }
    /**
     * Set PassengerTypeCode value
     * @param string $passengerTypeCode
     * @return \StructType\TourCodePref
     */
    public function setPassengerTypeCode($passengerTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($passengerTypeCode) && !is_string($passengerTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passengerTypeCode, true), gettype($passengerTypeCode)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{3})
        if (!is_null($passengerTypeCode) && !preg_match('/[a-zA-Z]{3}/', $passengerTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{3}', var_export($passengerTypeCode, true)), __LINE__);
        }
        $this->PassengerTypeCode = $passengerTypeCode;
        return $this;
    }
    /**
     * Get AirlineVendorPrefRPH value
     * @return string[]|null
     */
    public function getAirlineVendorPrefRPH()
    {
        return $this->AirlineVendorPrefRPH;
    }
    /**
     * This method is responsible for validating the values passed to the setAirlineVendorPrefRPH method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirlineVendorPrefRPH method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirlineVendorPrefRPHForArrayConstraintsFromSetAirlineVendorPrefRPH(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tourCodePrefAirlineVendorPrefRPHItem) {
            // validation for constraint: itemType
            if (!is_string($tourCodePrefAirlineVendorPrefRPHItem)) {
                $invalidValues[] = is_object($tourCodePrefAirlineVendorPrefRPHItem) ? get_class($tourCodePrefAirlineVendorPrefRPHItem) : sprintf('%s(%s)', gettype($tourCodePrefAirlineVendorPrefRPHItem), var_export($tourCodePrefAirlineVendorPrefRPHItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AirlineVendorPrefRPH property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AirlineVendorPrefRPH value
     * @param string[] $airlineVendorPrefRPH
     * @return \StructType\TourCodePref
     */
    public function setAirlineVendorPrefRPH(array $airlineVendorPrefRPH = array())
    {
        // validation for constraint: list
        if ('' !== ($airlineVendorPrefRPHArrayErrorMessage = self::validateAirlineVendorPrefRPHForArrayConstraintsFromSetAirlineVendorPrefRPH($airlineVendorPrefRPH))) {
            throw new \InvalidArgumentException($airlineVendorPrefRPHArrayErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($airlineVendorPrefRPH) && !preg_match('/[0-9]{1,8}/', $airlineVendorPrefRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($airlineVendorPrefRPH, true)), __LINE__);
        }
        $this->AirlineVendorPrefRPH = is_array($airlineVendorPrefRPH) ? implode(' ', $airlineVendorPrefRPH) : null;
        return $this;
    }
    /**
     * Get TransferAction value
     * @return string|null
     */
    public function getTransferAction()
    {
        return $this->TransferAction;
    }
    /**
     * Set TransferAction value
     * @uses \EnumType\TransferActionType::valueIsValid()
     * @uses \EnumType\TransferActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transferAction
     * @return \StructType\TourCodePref
     */
    public function setTransferAction($transferAction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransferActionType::valueIsValid($transferAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TransferActionType', is_array($transferAction) ? implode(', ', $transferAction) : var_export($transferAction, true), implode(', ', \EnumType\TransferActionType::getValidValues())), __LINE__);
        }
        $this->TransferAction = $transferAction;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TourCodePref
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
