<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TourCodeInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Used to provide a promotion code and the associated vendor. | Provides the tour code.
 * @subpackage Structs
 */
class TourCodeInfo extends AbstractStructBase
{
    /**
     * The TourTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Type of tour (e.g., IT=inclusive Tour, BT= Bulk Tour, NR=Net Remit). | Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $TourTypeCode;
    /**
     * The YearNum
     * Meta information extracted from the WSDL
     * - base: xs:integer
     * - maxInclusive: 9
     * - minInclusive: 0
     * - use: optional
     * @var int
     */
    public $YearNum;
    /**
     * The PartyID
     * Meta information extracted from the WSDL
     * - documentation: Identifier assigned to a tour group by the airline. | Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $PartyID;
    /**
     * The PromotionCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $PromotionCode;
    /**
     * The PromotionVendorCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 8. | List of StringLength1to8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * @var string[]
     */
    public $PromotionVendorCode;
    /**
     * Constructor method for TourCodeInfo
     * @uses TourCodeInfo::setTourTypeCode()
     * @uses TourCodeInfo::setYearNum()
     * @uses TourCodeInfo::setPartyID()
     * @uses TourCodeInfo::setPromotionCode()
     * @uses TourCodeInfo::setPromotionVendorCode()
     * @param string $tourTypeCode
     * @param int $yearNum
     * @param string $partyID
     * @param string $promotionCode
     * @param string[] $promotionVendorCode
     */
    public function __construct($tourTypeCode = null, $yearNum = null, $partyID = null, $promotionCode = null, array $promotionVendorCode = array())
    {
        $this
            ->setTourTypeCode($tourTypeCode)
            ->setYearNum($yearNum)
            ->setPartyID($partyID)
            ->setPromotionCode($promotionCode)
            ->setPromotionVendorCode($promotionVendorCode);
    }
    /**
     * Get TourTypeCode value
     * @return string|null
     */
    public function getTourTypeCode()
    {
        return $this->TourTypeCode;
    }
    /**
     * Set TourTypeCode value
     * @param string $tourTypeCode
     * @return \StructType\TourCodeInfo
     */
    public function setTourTypeCode($tourTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($tourTypeCode) && !is_string($tourTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tourTypeCode, true), gettype($tourTypeCode)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($tourTypeCode) && mb_strlen($tourTypeCode) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($tourTypeCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($tourTypeCode) && mb_strlen($tourTypeCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($tourTypeCode)), __LINE__);
        }
        $this->TourTypeCode = $tourTypeCode;
        return $this;
    }
    /**
     * Get YearNum value
     * @return int|null
     */
    public function getYearNum()
    {
        return $this->YearNum;
    }
    /**
     * Set YearNum value
     * @param int $yearNum
     * @return \StructType\TourCodeInfo
     */
    public function setYearNum($yearNum = null)
    {
        // validation for constraint: int
        if (!is_null($yearNum) && !(is_int($yearNum) || ctype_digit($yearNum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($yearNum, true), gettype($yearNum)), __LINE__);
        }
        // validation for constraint: maxInclusive(9)
        if (!is_null($yearNum) && $yearNum > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9', var_export($yearNum, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($yearNum) && $yearNum < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($yearNum, true)), __LINE__);
        }
        $this->YearNum = $yearNum;
        return $this;
    }
    /**
     * Get PartyID value
     * @return string|null
     */
    public function getPartyID()
    {
        return $this->PartyID;
    }
    /**
     * Set PartyID value
     * @param string $partyID
     * @return \StructType\TourCodeInfo
     */
    public function setPartyID($partyID = null)
    {
        // validation for constraint: string
        if (!is_null($partyID) && !is_string($partyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partyID, true), gettype($partyID)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($partyID) && mb_strlen($partyID) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($partyID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($partyID) && mb_strlen($partyID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($partyID)), __LINE__);
        }
        $this->PartyID = $partyID;
        return $this;
    }
    /**
     * Get PromotionCode value
     * @return string|null
     */
    public function getPromotionCode()
    {
        return $this->PromotionCode;
    }
    /**
     * Set PromotionCode value
     * @param string $promotionCode
     * @return \StructType\TourCodeInfo
     */
    public function setPromotionCode($promotionCode = null)
    {
        // validation for constraint: string
        if (!is_null($promotionCode) && !is_string($promotionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promotionCode, true), gettype($promotionCode)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($promotionCode) && mb_strlen($promotionCode) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($promotionCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($promotionCode) && mb_strlen($promotionCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($promotionCode)), __LINE__);
        }
        $this->PromotionCode = $promotionCode;
        return $this;
    }
    /**
     * Get PromotionVendorCode value
     * @return string[]|null
     */
    public function getPromotionVendorCode()
    {
        return $this->PromotionVendorCode;
    }
    /**
     * This method is responsible for validating the values passed to the setPromotionVendorCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPromotionVendorCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePromotionVendorCodeForArrayConstraintsFromSetPromotionVendorCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tourCodeInfoPromotionVendorCodeItem) {
            // validation for constraint: itemType
            if (!is_string($tourCodeInfoPromotionVendorCodeItem)) {
                $invalidValues[] = is_object($tourCodeInfoPromotionVendorCodeItem) ? get_class($tourCodeInfoPromotionVendorCodeItem) : sprintf('%s(%s)', gettype($tourCodeInfoPromotionVendorCodeItem), var_export($tourCodeInfoPromotionVendorCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PromotionVendorCode property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PromotionVendorCode value
     * @param string[] $promotionVendorCode
     * @return \StructType\TourCodeInfo
     */
    public function setPromotionVendorCode(array $promotionVendorCode = array())
    {
        // validation for constraint: list
        if ('' !== ($promotionVendorCodeArrayErrorMessage = self::validatePromotionVendorCodeForArrayConstraintsFromSetPromotionVendorCode($promotionVendorCode))) {
            throw new \InvalidArgumentException($promotionVendorCodeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($promotionVendorCode) && mb_strlen($promotionVendorCode) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($promotionVendorCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($promotionVendorCode) && mb_strlen($promotionVendorCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($promotionVendorCode)), __LINE__);
        }
        $this->PromotionVendorCode = is_array($promotionVendorCode) ? implode(' ', $promotionVendorCode) : null;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TourCodeInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
