<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TotalCharge StructType
 * Meta information extracted from the WSDL
 * - documentation: The total cost of this reservation, the sum of the individual charges, optional charges and associated fees. | Total cost for this reservation as returned from an availability search. | The anticipated total cost of a rental, the sum
 * of the individual charges, optional charges, and associated fees. | The anticipated total cost of a reservation, the sum of the individual charges, optional charges and associated fees.
 * @subpackage Structs
 */
class TotalCharge extends AbstractStructBase
{
    /**
     * The RateConvertInd
     * Meta information extracted from the WSDL
     * - documentation: When true, the rates have been converted to a different currency.
     * - use: optional
     * @var bool
     */
    public $RateConvertInd;
    /**
     * The RateTotalAmount
     * Meta information extracted from the WSDL
     * - documentation: Total rental charges excluding any additional mandatory charges. | Specifies an amount, max 3 decimals.
     * - base: xs:decimal
     * - fractionDigits: 3
     * - type: Money
     * - use: optional
     * @var float
     */
    public $RateTotalAmount;
    /**
     * The EstimatedTotalAmount
     * Meta information extracted from the WSDL
     * - documentation: Total rental charges including any additional mandatory charges (e.g., taxes). | Specifies an amount, max 3 decimals.
     * - base: xs:decimal
     * - fractionDigits: 3
     * - type: Money
     * - use: optional
     * @var float
     */
    public $EstimatedTotalAmount;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: Used for an Alpha String, length exactly 3.
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * @var int
     */
    public $DecimalPlaces;
    /**
     * Constructor method for TotalCharge
     * @uses TotalCharge::setRateConvertInd()
     * @uses TotalCharge::setRateTotalAmount()
     * @uses TotalCharge::setEstimatedTotalAmount()
     * @uses TotalCharge::setCurrencyCode()
     * @uses TotalCharge::setDecimalPlaces()
     * @param bool $rateConvertInd
     * @param float $rateTotalAmount
     * @param float $estimatedTotalAmount
     * @param string $currencyCode
     * @param int $decimalPlaces
     */
    public function __construct($rateConvertInd = null, $rateTotalAmount = null, $estimatedTotalAmount = null, $currencyCode = null, $decimalPlaces = null)
    {
        $this
            ->setRateConvertInd($rateConvertInd)
            ->setRateTotalAmount($rateTotalAmount)
            ->setEstimatedTotalAmount($estimatedTotalAmount)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces);
    }
    /**
     * Get RateConvertInd value
     * @return bool|null
     */
    public function getRateConvertInd()
    {
        return $this->RateConvertInd;
    }
    /**
     * Set RateConvertInd value
     * @param bool $rateConvertInd
     * @return \StructType\TotalCharge
     */
    public function setRateConvertInd($rateConvertInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($rateConvertInd) && !is_bool($rateConvertInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($rateConvertInd, true), gettype($rateConvertInd)), __LINE__);
        }
        $this->RateConvertInd = $rateConvertInd;
        return $this;
    }
    /**
     * Get RateTotalAmount value
     * @return float|null
     */
    public function getRateTotalAmount()
    {
        return $this->RateTotalAmount;
    }
    /**
     * Set RateTotalAmount value
     * @param float $rateTotalAmount
     * @return \StructType\TotalCharge
     */
    public function setRateTotalAmount($rateTotalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($rateTotalAmount) && !(is_float($rateTotalAmount) || is_numeric($rateTotalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rateTotalAmount, true), gettype($rateTotalAmount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($rateTotalAmount) && mb_strlen(mb_substr($rateTotalAmount, mb_strpos($rateTotalAmount, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($rateTotalAmount, true), mb_strlen(mb_substr($rateTotalAmount, mb_strpos($rateTotalAmount, '.') + 1))), __LINE__);
        }
        $this->RateTotalAmount = $rateTotalAmount;
        return $this;
    }
    /**
     * Get EstimatedTotalAmount value
     * @return float|null
     */
    public function getEstimatedTotalAmount()
    {
        return $this->EstimatedTotalAmount;
    }
    /**
     * Set EstimatedTotalAmount value
     * @param float $estimatedTotalAmount
     * @return \StructType\TotalCharge
     */
    public function setEstimatedTotalAmount($estimatedTotalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($estimatedTotalAmount) && !(is_float($estimatedTotalAmount) || is_numeric($estimatedTotalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estimatedTotalAmount, true), gettype($estimatedTotalAmount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($estimatedTotalAmount) && mb_strlen(mb_substr($estimatedTotalAmount, mb_strpos($estimatedTotalAmount, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($estimatedTotalAmount, true), mb_strlen(mb_substr($estimatedTotalAmount, mb_strpos($estimatedTotalAmount, '.') + 1))), __LINE__);
        }
        $this->EstimatedTotalAmount = $estimatedTotalAmount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\TotalCharge
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{3})
        if (!is_null($currencyCode) && !preg_match('/[a-zA-Z]{3}/', $currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{3}', var_export($currencyCode, true)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \StructType\TotalCharge
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($decimalPlaces) && !(is_int($decimalPlaces) || ctype_digit($decimalPlaces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($decimalPlaces, true), gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TotalCharge
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
