<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TimeInstantType StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies a time window. | A construct to validate either a date or a dateTime value.
 * - union: date | dateTime
 * @subpackage Structs
 */
class TimeInstantType extends AbstractStructBase
{
    /**
     * The _
     * Meta information extracted from the WSDL
     * - documentation: A construct to validate either a date or a dateTime value.
     * - union: date | dateTime
     * @var string
     */
    public $_;
    /**
     * The WindowBefore
     * Meta information extracted from the WSDL
     * - documentation: A period of time that can be applied to another time resulting in an earlier range of time.
     * - use: optional
     * @var string
     */
    public $WindowBefore;
    /**
     * The WindowAfter
     * Meta information extracted from the WSDL
     * - documentation: A period of time that can be applied to another time resulting in a later range of time.
     * - use: optional
     * @var string
     */
    public $WindowAfter;
    /**
     * The CrossDateAllowedIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true the requested period may extend over the previous or following day. When false, the search period is restricted to the date specified. Normally used when the window duration is in hours.
     * - use: optional
     * @var bool
     */
    public $CrossDateAllowedIndicator;
    /**
     * Constructor method for TimeInstantType
     * @uses TimeInstantType::set_()
     * @uses TimeInstantType::setWindowBefore()
     * @uses TimeInstantType::setWindowAfter()
     * @uses TimeInstantType::setCrossDateAllowedIndicator()
     * @param string $_
     * @param string $windowBefore
     * @param string $windowAfter
     * @param bool $crossDateAllowedIndicator
     */
    public function __construct($_ = null, $windowBefore = null, $windowAfter = null, $crossDateAllowedIndicator = null)
    {
        $this
            ->set_($_)
            ->setWindowBefore($windowBefore)
            ->setWindowAfter($windowAfter)
            ->setCrossDateAllowedIndicator($crossDateAllowedIndicator);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * This method is responsible for validating the value passed to the set_ method
     * This method is willingly generated in order to preserve the one-line inline validation within the set_ method
     * This is a set of validation rules based on the union types associated to the property being set by the set_ method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validate_ForUnionConstraintsFromSet_($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\TimeInstantType
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        // validation for constraint: union(date, dateTime)
        if ('' !== ($_UnionErrorMessage = self::validate_ForUnionConstraintsFromSet_($_))) {
            throw new \InvalidArgumentException($_UnionErrorMessage, __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get WindowBefore value
     * @return string|null
     */
    public function getWindowBefore()
    {
        return $this->WindowBefore;
    }
    /**
     * Set WindowBefore value
     * @param string $windowBefore
     * @return \StructType\TimeInstantType
     */
    public function setWindowBefore($windowBefore = null)
    {
        // validation for constraint: string
        if (!is_null($windowBefore) && !is_string($windowBefore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($windowBefore, true), gettype($windowBefore)), __LINE__);
        }
        $this->WindowBefore = $windowBefore;
        return $this;
    }
    /**
     * Get WindowAfter value
     * @return string|null
     */
    public function getWindowAfter()
    {
        return $this->WindowAfter;
    }
    /**
     * Set WindowAfter value
     * @param string $windowAfter
     * @return \StructType\TimeInstantType
     */
    public function setWindowAfter($windowAfter = null)
    {
        // validation for constraint: string
        if (!is_null($windowAfter) && !is_string($windowAfter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($windowAfter, true), gettype($windowAfter)), __LINE__);
        }
        $this->WindowAfter = $windowAfter;
        return $this;
    }
    /**
     * Get CrossDateAllowedIndicator value
     * @return bool|null
     */
    public function getCrossDateAllowedIndicator()
    {
        return $this->CrossDateAllowedIndicator;
    }
    /**
     * Set CrossDateAllowedIndicator value
     * @param bool $crossDateAllowedIndicator
     * @return \StructType\TimeInstantType
     */
    public function setCrossDateAllowedIndicator($crossDateAllowedIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($crossDateAllowedIndicator) && !is_bool($crossDateAllowedIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($crossDateAllowedIndicator, true), gettype($crossDateAllowedIndicator)), __LINE__);
        }
        $this->CrossDateAllowedIndicator = $crossDateAllowedIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TimeInstantType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
